/* data.c generated by valac 0.14.2, the Vala compiler
 * generated from data.vala, do not modify */

/*
 * Copyright (C) 2010-2011 Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <freesmartphone.h>
#include <msmcomm-specs.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MSM_PIN_STATUS (msm_pin_status_get_type ())

#define TYPE_MSM_DATA (msm_data_get_type ())
#define MSM_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MSM_DATA, MsmData))
#define MSM_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MSM_DATA, MsmDataClass))
#define IS_MSM_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MSM_DATA))
#define IS_MSM_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MSM_DATA))
#define MSM_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MSM_DATA, MsmDataClass))

typedef struct _MsmData MsmData;
typedef struct _MsmDataClass MsmDataClass;
typedef struct _MsmDataPrivate MsmDataPrivate;

#define MSM_DATA_TYPE_NETWORK_INFO (msm_data_network_info_get_type ())
typedef struct _MsmDataNetworkInfo MsmDataNetworkInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecMsmData ParamSpecMsmData;

typedef enum  {
	MSM_PIN_STATUS_DISABLED,
	MSM_PIN_STATUS_ENABLED,
	MSM_PIN_STATUS_BLOCKED,
	MSM_PIN_STATUS_PERM_BLOCKED
} MsmPinStatus;

struct _MsmData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MsmDataPrivate * priv;
};

struct _MsmDataClass {
	GTypeClass parent_class;
	void (*finalize) (MsmData *self);
};

struct _MsmDataNetworkInfo {
	MsmcommNetworkRegistrationStatus reg_status;
	MsmcommNetworkServiceStatus service_status;
	MsmcommNetworkDataService data_service;
	gchar* operator_name;
	guint rssi;
	guint ecio;
	guint mcc;
	guint mnc;
};

struct _ParamSpecMsmData {
	GParamSpec parent_instance;
};


static gpointer msm_data_parent_class = NULL;
extern MsmPinStatus msm_data_pin_status;
MsmPinStatus msm_data_pin_status = 0;
extern FreeSmartphoneGSMSIMAuthStatus msm_data_sim_auth_status;
FreeSmartphoneGSMSIMAuthStatus msm_data_sim_auth_status = 0;
extern MsmcommOperationMode msm_data_operation_mode;
MsmcommOperationMode msm_data_operation_mode = 0;
extern gboolean msm_data_sim_available;
gboolean msm_data_sim_available = FALSE;
extern guint msm_data_cell_id;
guint msm_data_cell_id = 0U;
extern MsmDataNetworkInfo msm_data_network_info;
MsmDataNetworkInfo msm_data_network_info = {0};
static GType msm_data_type_id = 0;

GType msm_pin_status_get_type (void) G_GNUC_CONST;
gpointer msm_data_ref (gpointer instance);
void msm_data_unref (gpointer instance);
GParamSpec* param_spec_msm_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_msm_data (GValue* value, gpointer v_object);
void value_take_msm_data (GValue* value, gpointer v_object);
gpointer value_get_msm_data (const GValue* value);
GType msm_data_get_type (void) G_GNUC_CONST;
GType msm_data_register_type (GTypeModule * module);
enum  {
	MSM_DATA_DUMMY_PROPERTY
};
GType msm_data_network_info_get_type (void) G_GNUC_CONST;
MsmDataNetworkInfo* msm_data_network_info_dup (const MsmDataNetworkInfo* self);
void msm_data_network_info_free (MsmDataNetworkInfo* self);
void msm_data_network_info_copy (const MsmDataNetworkInfo* self, MsmDataNetworkInfo* dest);
void msm_data_network_info_destroy (MsmDataNetworkInfo* self);
void msm_data_reset (void);
void msm_data_network_info_reset (MsmDataNetworkInfo *self);
MsmData* msm_data_new (void);
MsmData* msm_data_construct (GType object_type);
static void msm_data_finalize (MsmData* obj);


GType msm_pin_status_get_type (void) {
	static volatile gsize msm_pin_status_type_id__volatile = 0;
	if (g_once_init_enter (&msm_pin_status_type_id__volatile)) {
		static const GEnumValue values[] = {{MSM_PIN_STATUS_DISABLED, "MSM_PIN_STATUS_DISABLED", "disabled"}, {MSM_PIN_STATUS_ENABLED, "MSM_PIN_STATUS_ENABLED", "enabled"}, {MSM_PIN_STATUS_BLOCKED, "MSM_PIN_STATUS_BLOCKED", "blocked"}, {MSM_PIN_STATUS_PERM_BLOCKED, "MSM_PIN_STATUS_PERM_BLOCKED", "perm-blocked"}, {0, NULL, NULL}};
		GType msm_pin_status_type_id;
		msm_pin_status_type_id = g_enum_register_static ("MsmPinStatus", values);
		g_once_init_leave (&msm_pin_status_type_id__volatile, msm_pin_status_type_id);
	}
	return msm_pin_status_type_id__volatile;
}


void msm_data_reset (void) {
	MsmDataNetworkInfo _tmp0_ = {0};
	msm_data_pin_status = MSM_PIN_STATUS_DISABLED;
	msm_data_operation_mode = MSMCOMM_OPERATION_MODE_OFFLINE;
	msm_data_sim_available = FALSE;
	msm_data_sim_auth_status = FREE_SMARTPHONE_GSM_SIM_AUTH_STATUS_UNKNOWN;
	memset (&_tmp0_, 0, sizeof (MsmDataNetworkInfo));
	msm_data_network_info_destroy (&msm_data_network_info);
	msm_data_network_info = _tmp0_;
	msm_data_network_info_reset (&msm_data_network_info);
}


MsmData* msm_data_construct (GType object_type) {
	MsmData* self = NULL;
	self = (MsmData*) g_type_create_instance (object_type);
	return self;
}


MsmData* msm_data_new (void) {
	return msm_data_construct (TYPE_MSM_DATA);
}


void msm_data_network_info_reset (MsmDataNetworkInfo *self) {
	gchar* _tmp0_;
	(*self).reg_status = MSMCOMM_NETWORK_REGISTRATION_STATUS_NO_SERVICE;
	(*self).service_status = MSMCOMM_NETWORK_SERVICE_STATUS_NO_SERVICE;
	(*self).data_service = MSMCOMM_NETWORK_DATA_SERVICE_NONE;
	_tmp0_ = g_strdup ("");
	_g_free0 ((*self).operator_name);
	(*self).operator_name = _tmp0_;
	(*self).rssi = (guint) 0;
	(*self).ecio = (guint) 0;
	(*self).mcc = (guint) 0;
	(*self).mnc = (guint) 0;
}


void msm_data_network_info_copy (const MsmDataNetworkInfo* self, MsmDataNetworkInfo* dest) {
	MsmcommNetworkRegistrationStatus _tmp0_;
	MsmcommNetworkServiceStatus _tmp1_;
	MsmcommNetworkDataService _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	_tmp0_ = (*self).reg_status;
	(*dest).reg_status = _tmp0_;
	_tmp1_ = (*self).service_status;
	(*dest).service_status = _tmp1_;
	_tmp2_ = (*self).data_service;
	(*dest).data_service = _tmp2_;
	_tmp3_ = (*self).operator_name;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).operator_name);
	(*dest).operator_name = _tmp4_;
	_tmp5_ = (*self).rssi;
	(*dest).rssi = _tmp5_;
	_tmp6_ = (*self).ecio;
	(*dest).ecio = _tmp6_;
	_tmp7_ = (*self).mcc;
	(*dest).mcc = _tmp7_;
	_tmp8_ = (*self).mnc;
	(*dest).mnc = _tmp8_;
}


void msm_data_network_info_destroy (MsmDataNetworkInfo* self) {
	_g_free0 ((*self).operator_name);
}


MsmDataNetworkInfo* msm_data_network_info_dup (const MsmDataNetworkInfo* self) {
	MsmDataNetworkInfo* dup;
	dup = g_new0 (MsmDataNetworkInfo, 1);
	msm_data_network_info_copy (self, dup);
	return dup;
}


void msm_data_network_info_free (MsmDataNetworkInfo* self) {
	msm_data_network_info_destroy (self);
	g_free (self);
}


GType msm_data_network_info_get_type (void) {
	static volatile gsize msm_data_network_info_type_id__volatile = 0;
	if (g_once_init_enter (&msm_data_network_info_type_id__volatile)) {
		GType msm_data_network_info_type_id;
		msm_data_network_info_type_id = g_boxed_type_register_static ("MsmDataNetworkInfo", (GBoxedCopyFunc) msm_data_network_info_dup, (GBoxedFreeFunc) msm_data_network_info_free);
		g_once_init_leave (&msm_data_network_info_type_id__volatile, msm_data_network_info_type_id);
	}
	return msm_data_network_info_type_id__volatile;
}


static void value_msm_data_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_msm_data_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		msm_data_unref (value->data[0].v_pointer);
	}
}


static void value_msm_data_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = msm_data_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_msm_data_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_msm_data_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		MsmData* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = msm_data_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_msm_data_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	MsmData** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = msm_data_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_msm_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMsmData* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MSM_DATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_msm_data (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MSM_DATA), NULL);
	return value->data[0].v_pointer;
}


void value_set_msm_data (GValue* value, gpointer v_object) {
	MsmData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MSM_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MSM_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		msm_data_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		msm_data_unref (old);
	}
}


void value_take_msm_data (GValue* value, gpointer v_object) {
	MsmData* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MSM_DATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MSM_DATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		msm_data_unref (old);
	}
}


static void msm_data_class_init (MsmDataClass * klass) {
	msm_data_parent_class = g_type_class_peek_parent (klass);
	MSM_DATA_CLASS (klass)->finalize = msm_data_finalize;
}


static void msm_data_instance_init (MsmData * self) {
	self->ref_count = 1;
}


static void msm_data_finalize (MsmData* obj) {
	MsmData * self;
	self = MSM_DATA (obj);
}


/**
 * Holds data comming from the modem through various urc messages. Most of this fields are
 * only accessible through the incomming urc messages so we have the save it at some place
 * for later access.
 **/
GType msm_data_get_type (void) {
	return msm_data_type_id;
}


GType msm_data_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { value_msm_data_init, value_msm_data_free_value, value_msm_data_copy_value, value_msm_data_peek_pointer, "p", value_msm_data_collect_value, "p", value_msm_data_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (MsmDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) msm_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MsmData), 0, (GInstanceInitFunc) msm_data_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	msm_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "MsmData", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return msm_data_type_id;
}


gpointer msm_data_ref (gpointer instance) {
	MsmData* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void msm_data_unref (gpointer instance) {
	MsmData* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MSM_DATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



