/* rfs.c generated by valac 0.14.2, the Vala compiler
 * generated from rfs.vala, do not modify */

/*
 * Copyright (C) 2012 Simon Busch <morphis@gravedo.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsotransport.h>
#include <fsogsm.h>
#include <radio.h>
#include <fsosystem.h>
#include <stdlib.h>
#include <string.h>
#include <fsobasics.h>
#include <gio/gio.h>


#define SAMSUNG_TYPE_RFS_CHANNEL (samsung_rfs_channel_get_type ())
#define SAMSUNG_RFS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SAMSUNG_TYPE_RFS_CHANNEL, SamsungRfsChannel))
#define SAMSUNG_RFS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SAMSUNG_TYPE_RFS_CHANNEL, SamsungRfsChannelClass))
#define SAMSUNG_IS_RFS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SAMSUNG_TYPE_RFS_CHANNEL))
#define SAMSUNG_IS_RFS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SAMSUNG_TYPE_RFS_CHANNEL))
#define SAMSUNG_RFS_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SAMSUNG_TYPE_RFS_CHANNEL, SamsungRfsChannelClass))

typedef struct _SamsungRfsChannel SamsungRfsChannel;
typedef struct _SamsungRfsChannelClass SamsungRfsChannelClass;
typedef struct _SamsungRfsChannelPrivate SamsungRfsChannelPrivate;
#define _ipc_client_free0(var) ((var == NULL) ? NULL : (var = (ipc_client_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SamsungRfsChannelOpenData SamsungRfsChannelOpenData;
typedef struct _SamsungRfsChannelCloseData SamsungRfsChannelCloseData;
typedef struct _SamsungRfsChannelSuspendData SamsungRfsChannelSuspendData;
typedef struct _SamsungRfsChannelResumeData SamsungRfsChannelResumeData;

struct _SamsungRfsChannel {
	FsoFrameworkAbstractCommandQueue parent_instance;
	SamsungRfsChannelPrivate * priv;
};

struct _SamsungRfsChannelClass {
	FsoFrameworkAbstractCommandQueueClass parent_class;
};

struct _SamsungRfsChannelPrivate {
	struct ipc_client* rfsclient;
	FsoFrameworkWakelock* wakelock;
	gchar* _name;
};

struct _SamsungRfsChannelOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungRfsChannel* self;
	gboolean result;
	gboolean _result_;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	struct ipc_client* _tmp4_;
};

struct _SamsungRfsChannelCloseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungRfsChannel* self;
	struct ipc_client* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkTransport* _tmp2_;
};

struct _SamsungRfsChannelSuspendData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungRfsChannel* self;
	gboolean result;
};

struct _SamsungRfsChannelResumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SamsungRfsChannel* self;
	gboolean result;
};

typedef void (*SamsungRfsChannelUnsolicitedHandler) (const gchar* prefix, const gchar* response, const gchar* pdu, void* user_data);

static gpointer samsung_rfs_channel_parent_class = NULL;
static FsoGsmChannelIface* samsung_rfs_channel_fso_gsm_channel_parent_iface = NULL;
static GType samsung_rfs_channel_type_id = 0;

GType samsung_rfs_channel_get_type (void) G_GNUC_CONST;
GType samsung_rfs_channel_register_type (GTypeModule * module);
#define SAMSUNG_RFS_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SAMSUNG_TYPE_RFS_CHANNEL, SamsungRfsChannelPrivate))
enum  {
	SAMSUNG_RFS_CHANNEL_DUMMY_PROPERTY,
	SAMSUNG_RFS_CHANNEL_NAME
};
static void samsung_rfs_channel_real_onReadFromTransport (FsoFrameworkAbstractCommandQueue* base, FsoFrameworkTransport* t);
const gchar* samsung_ipc_message_type_to_string (unsigned short self);
static const char* _samsung_ipc_message_type_to_string (unsigned short value);
gint samsung_rfs_channel_modem_read_request (SamsungRfsChannel* self, guint8* data, int data_length1);
gint samsung_rfs_channel_modem_write_request (SamsungRfsChannel* self, guint8* data, int data_length1);
static void _samsung_rfs_channel_onHupFromTransport (SamsungRfsChannel* self);
SamsungRfsChannel* samsung_rfs_channel_new (const gchar* name, FsoFrameworkTransport* transport);
SamsungRfsChannel* samsung_rfs_channel_construct (GType object_type, const gchar* name, FsoFrameworkTransport* transport);
static void _fso_framework_abstract_command_queue_onReadFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
static void __samsung_rfs_channel_onHupFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self);
static void samsung_rfs_channel_set_name (SamsungRfsChannel* self, const gchar* value);
static void __lambda5_ (SamsungRfsChannel* self, const gchar* message);
static void ___lambda5__samsung_ipc_log_handler_cb (const gchar* message, gpointer self);
static gint _samsung_rfs_channel_modem_read_request_samsung_ipc_transport_cb (guint8* data, int data_length1, gpointer self);
static gint _samsung_rfs_channel_modem_write_request_samsung_ipc_transport_cb (guint8* data, int data_length1, gpointer self);
static void samsung_rfs_channel_real_open_data_free (gpointer _data);
static void samsung_rfs_channel_real_open (FsoFrameworkAbstractCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_rfs_channel_real_open_co (SamsungRfsChannelOpenData* _data_);
static void samsung_rfs_channel_open_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void samsung_rfs_channel_real_close_data_free (gpointer _data);
static void samsung_rfs_channel_real_close (FsoFrameworkAbstractCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_rfs_channel_real_close_co (SamsungRfsChannelCloseData* _data_);
static void samsung_rfs_channel_real_suspend_data_free (gpointer _data);
static void samsung_rfs_channel_real_suspend (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_rfs_channel_real_suspend_co (SamsungRfsChannelSuspendData* _data_);
static void samsung_rfs_channel_real_resume_data_free (gpointer _data);
static void samsung_rfs_channel_real_resume (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean samsung_rfs_channel_real_resume_co (SamsungRfsChannelResumeData* _data_);
void samsung_rfs_channel_registerUnsolicitedHandler (SamsungRfsChannel* self, SamsungRfsChannelUnsolicitedHandler urchandler, void* urchandler_target);
static void samsung_rfs_channel_real_injectResponse (FsoGsmChannel* base, const gchar* response);
const gchar* samsung_rfs_channel_get_name (SamsungRfsChannel* self);
static void samsung_rfs_channel_finalize (GObject* obj);
static void _vala_samsung_rfs_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_samsung_rfs_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static unsigned short samsung_ipc_response_get_command (struct ipc_message_info* self) {
	unsigned short result;
	guint8 _tmp0_;
	guint8 _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = (*self).group;
	_tmp1_ = (*self).index;
	result = (unsigned short) ((_tmp0_ << 8) | _tmp1_);
	return result;
}


static void samsung_ipc_response_set_command (struct ipc_message_info* self, unsigned short value) {
	unsigned short _tmp0_;
	unsigned short _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	(*self).group = (guint8) (_tmp0_ >> 8);
	_tmp1_ = value;
	(*self).index = (guint8) (_tmp1_ & 0xff);
}


static const char* _samsung_ipc_message_type_to_string (unsigned short value) {
	switch (value) {
		case IPC_PWR_PHONE_PWR_OFF:
		return "IPC_PWR_PHONE_PWR_OFF";
		case IPC_PWR_PHONE_PWR_UP:
		return "IPC_PWR_PHONE_PWR_UP";
		case IPC_PWR_PHONE_RESET:
		return "IPC_PWR_PHONE_RESET";
		case IPC_PWR_BATT_STATUS:
		return "IPC_PWR_BATT_STATUS";
		case IPC_PWR_BATT_TYPE:
		return "IPC_PWR_BATT_TYPE";
		case IPC_PWR_BATT_COMP:
		return "IPC_PWR_BATT_COMP";
		case IPC_PWR_PHONE_STATE:
		return "IPC_PWR_PHONE_STATE";
		case IPC_PB_ACCESS:
		return "IPC_PB_ACCESS";
		case IPC_PB_STORAGE:
		return "IPC_PB_STORAGE";
		case IPC_PB_STORAGE_LIST:
		return "IPC_PB_STORAGE_LIST";
		case IPC_PB_ENTRY_INFO:
		return "IPC_PB_ENTRY_INFO";
		case IPC_PB_CAPABILITY_INFO:
		return "IPC_PB_CAPABILITY_INFO";
		case IPC_SS_WAITING:
		return "IPC_SS_WAITING";
		case IPC_SS_CLI:
		return "IPC_SS_CLI";
		case IPC_SS_BARRING:
		return "IPC_SS_BARRING";
		case IPC_SS_BARRING_PW:
		return "IPC_SS_BARRING_PW";
		case IPC_SS_FORWARDING:
		return "IPC_SS_FORWARDING";
		case IPC_SS_INFO:
		return "IPC_SS_INFO";
		case IPC_SS_MANAGE_CALL:
		return "IPC_SS_MANAGE_CALL";
		case IPC_SS_USSD:
		return "IPC_SS_USSD";
		case IPC_SS_AOC:
		return "IPC_SS_AOC";
		case IPC_SS_RELEASE_COMPLETE:
		return "IPC_SS_RELEASE_COMPLETE";
		case IPC_GPRS_DEFINE_PDP_CONTEXT:
		return "IPC_GPRS_DEFINE_PDP_CONTEXT";
		case IPC_GPRS_QOS:
		return "IPC_GPRS_QOS";
		case IPC_GPRS_PS:
		return "IPC_GPRS_PS";
		case IPC_GPRS_PDP_CONTEXT:
		return "IPC_GPRS_PDP_CONTEXT";
		case IPC_GPRS_SHOW_PDP_ADDR:
		return "IPC_GPRS_SHOW_PDP_ADDR";
		case IPC_GPRS_3G_QUAL_SERVICE_PROFILE:
		return "IPC_GPRS_3G_QUAL_SERVICE_PROFILE";
		case IPC_GPRS_IP_CONFIGURATION:
		return "IPC_GPRS_IP_CONFIGURATION";
		case IPC_GPRS_DEFINE_SEC_PDP_CONTEXT:
		return "IPC_GPRS_DEFINE_SEC_PDP_CONTEXT";
		case IPC_GPRS_TFT:
		return "IPC_GPRS_TFT";
		case IPC_GPRS_HSDPA_STATUS:
		return "IPC_GPRS_HSDPA_STATUS";
		case IPC_GPRS_CURRENT_SESSION_DATA_COUNT:
		return "IPC_GPRS_CURRENT_SESSION_DATA_COUNT";
		case IPC_GPRS_DATA_DORMANT:
		return "IPC_GPRS_DATA_DORMANT";
		case IPC_GPRS_DUN_PIN_CTRL:
		return "IPC_GPRS_DUN_PIN_CTRL";
		case IPC_GPRS_CALL_STATUS:
		return "IPC_GPRS_CALL_STATUS";
		case IPC_SAT_PROFILE_DOWNLOAD:
		return "IPC_SAT_PROFILE_DOWNLOAD";
		case IPC_SAT_ENVELOPE_CMD:
		return "IPC_SAT_ENVELOPE_CMD";
		case IPC_SAT_PROACTIVE_CMD:
		return "IPC_SAT_PROACTIVE_CMD";
		case IPC_SAT_TERMINATE_USAT_SESSION:
		return "IPC_SAT_TERMINATE_USAT_SESSION";
		case IPC_SAT_EVENT_DOWNLOAD:
		return "IPC_SAT_EVENT_DOWNLOAD";
		case IPC_SAT_PROVIDE_LOCAL_INFO:
		return "IPC_SAT_PROVIDE_LOCAL_INFO";
		case IPC_SAT_POLLING:
		return "IPC_SAT_POLLING";
		case IPC_SAT_REFRESH:
		return "IPC_SAT_REFRESH";
		case IPC_SAT_SETUP_EVENT_LIST:
		return "IPC_SAT_SETUP_EVENT_LIST";
		case IPC_SAT_CALL_CONTROL_RESULT:
		return "IPC_SAT_CALL_CONTROL_RESULT";
		case IPC_SAT_IMAGE_CLUT:
		return "IPC_SAT_IMAGE_CLUT";
		case IPC_SAT_CALL_PROCESSING:
		return "IPC_SAT_CALL_PROCESSING";
		case IPC_IMEI_START:
		return "IPC_IMEI_START";
		case IPC_IMEI_CHECK_DEVICE_INFO:
		return "IPC_IMEI_CHECK_DEVICE_INFO";
		case IPC_CALL_OUTGOING:
		return "IPC_CALL_OUTGOING";
		case IPC_CALL_INCOMING:
		return "IPC_CALL_INCOMING";
		case IPC_CALL_RELEASE:
		return "IPC_CALL_RELEASE";
		case IPC_CALL_ANSWER:
		return "IPC_CALL_ANSWER";
		case IPC_CALL_STATUS:
		return "IPC_CALL_STATUS";
		case IPC_CALL_LIST:
		return "IPC_CALL_LIST";
		case IPC_CALL_BURST_DTMF:
		return "IPC_CALL_BURST_DTMF";
		case IPC_CALL_CONT_DTMF:
		return "IPC_CALL_CONT_DTMF";
		case IPC_CALL_WAITING:
		return "IPC_CALL_WAITING";
		case IPC_CALL_LINE_ID:
		return "IPC_CALL_LINE_ID";
		case IPC_DISP_ICON_INFO:
		return "IPC_DISP_ICON_INFO";
		case IPC_DISP_HOMEZONE_INFO:
		return "IPC_DISP_HOMEZONE_INFO";
		case IPC_DISP_RSSI_INFO:
		return "IPC_DISP_RSSI_INFO";
		case IPC_SEC_PIN_STATUS:
		return "IPC_SEC_PIN_STATUS";
		case IPC_SEC_PHONE_LOCK:
		return "IPC_SEC_PHONE_LOCK";
		case IPC_SEC_CHANGE_LOCKING_PW:
		return "IPC_SEC_CHANGE_LOCKING_PW";
		case IPC_SEC_SIM_LANG:
		return "IPC_SEC_SIM_LANG";
		case IPC_SEC_RSIM_ACCESS:
		return "IPC_SEC_RSIM_ACCESS";
		case IPC_SEC_GSIM_ACCESS:
		return "IPC_SEC_GSIM_ACCESS";
		case IPC_SEC_SIM_ICC_TYPE:
		return "IPC_SEC_SIM_ICC_TYPE";
		case IPC_SEC_LOCK_INFO:
		return "IPC_SEC_LOCK_INFO";
		case IPC_SEC_ISIM_AUTH:
		return "IPC_SEC_ISIM_AUTH";
		case IPC_NET_PREF_PLMN:
		return "IPC_NET_PREF_PLMN";
		case IPC_NET_PLMN_SEL:
		return "IPC_NET_PLMN_SEL";
		case IPC_NET_CURRENT_PLMN:
		return "IPC_NET_CURRENT_PLMN";
		case IPC_NET_PLMN_LIST:
		return "IPC_NET_PLMN_LIST";
		case IPC_NET_REGIST:
		return "IPC_NET_REGIST";
		case IPC_NET_SUBSCRIBER_NUM:
		return "IPC_NET_SUBSCRIBER_NUM";
		case IPC_NET_BAND_SEL:
		return "IPC_NET_BAND_SEL";
		case IPC_NET_SERVICE_DOMAIN_CONFIG:
		return "IPC_NET_SERVICE_DOMAIN_CONFIG";
		case IPC_NET_POWERON_ATTACH:
		return "IPC_NET_POWERON_ATTACH";
		case IPC_NET_MODE_SEL:
		return "IPC_NET_MODE_SEL";
		case IPC_NET_ACQ_ORDER:
		return "IPC_NET_ACQ_ORDER";
		case IPC_NET_IDENTITY:
		return "IPC_NET_IDENTITY";
		case IPC_NET_CURRENT_RRC_STATUS:
		return "IPC_NET_CURRENT_RRC_STATUS";
		case IPC_GEN_PHONE_RES:
		return "IPC_GEN_PHONE_RES";
		case IPC_MISC_ME_VERSION:
		return "IPC_MISC_ME_VERSION";
		case IPC_MISC_ME_IMSI:
		return "IPC_MISC_ME_IMSI";
		case IPC_MISC_ME_SN:
		return "IPC_MISC_ME_SN";
		case IPC_MISC_TIME_INFO:
		return "IPC_MISC_TIME_INFO";
		case IPC_SMS_SEND_MSG:
		return "IPC_SMS_SEND_MSG";
		case IPC_SMS_INCOMING_MSG:
		return "IPC_SMS_INCOMING_MSG";
		case IPC_SMS_READ_MSG:
		return "IPC_SMS_READ_MSG";
		case IPC_SMS_SAVE_MSG:
		return "IPC_SMS_SAVE_MSG";
		case IPC_SMS_DEL_MSG:
		return "IPC_SMS_DEL_MSG";
		case IPC_SMS_DELIVER_REPORT:
		return "IPC_SMS_DELIVER_REPORT";
		case IPC_SMS_DEVICE_READY:
		return "IPC_SMS_DEVICE_READY";
		case IPC_SMS_SEL_MEM:
		return "IPC_SMS_SEL_MEM";
		case IPC_SMS_STORED_MSG_COUNT:
		return "IPC_SMS_STORED_MSG_COUNT";
		case IPC_SMS_SVC_CENTER_ADDR:
		return "IPC_SMS_SVC_CENTER_ADDR";
		case IPC_SMS_SVC_OPTION:
		return "IPC_SMS_SVC_OPTION";
		case IPC_SMS_MEM_STATUS:
		return "IPC_SMS_MEM_STATUS";
		case IPC_SMS_CBS_MSG:
		return "IPC_SMS_CBS_MSG";
		case IPC_SMS_CBS_CONFIG:
		return "IPC_SMS_CBS_CONFIG";
		case IPC_SMS_STORED_MSG_STATUS:
		return "IPC_SMS_STORED_MSG_STATUS";
		case IPC_SMS_PARAM_COUNT:
		return "IPC_SMS_PARAM_COUNT";
		case IPC_SMS_PARAM:
		return "IPC_SMS_PARAM";
		case IPC_SND_SPKR_VOLUME_CTRL:
		return "IPC_SND_SPKR_VOLUME_CTRL";
		case IPC_SND_MIC_MUTE_CTRL:
		return "IPC_SND_MIC_MUTE_CTRL";
		case IPC_SND_AUDIO_PATH_CTRL:
		return "IPC_SND_AUDIO_PATH_CTRL";
		case IPC_SND_RINGBACK_TONE_CTRL:
		return "IPC_SND_RINGBACK_TONE_CTRL";
		case IPC_SND_CLOCK_CTRL:
		return "IPC_SND_CLOCK_CTRL";
		case IPC_RFS_NV_READ_ITEM:
		return "IPC_RFS_NV_READ_ITEM";
		case IPC_RFS_NV_WRITE_ITEM:
		return "IPC_RFS_NV_WRITE_ITEM";
	}
	return NULL;
}


static void samsung_rfs_channel_real_onReadFromTransport (FsoFrameworkAbstractCommandQueue* base, FsoFrameworkTransport* t) {
	SamsungRfsChannel * self;
	struct ipc_message_info request = {0};
	FsoFrameworkWakelock* _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_ = FALSE;
	struct ipc_client* _tmp3_;
	struct ipc_message_info _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint rc;
	gint _tmp6_;
	FsoFrameworkLogger* _tmp8_;
	struct ipc_message_info _tmp9_;
	unsigned short _tmp10_;
	unsigned short _tmp11_;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	struct ipc_message_info _tmp16_;
	unsigned short _tmp17_;
	unsigned short _tmp18_;
	struct ipc_message_info _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	FsoFrameworkLogger* _tmp28_;
	gboolean _tmp29_ = FALSE;
	FsoFrameworkWakelock* _tmp30_;
	self = (SamsungRfsChannel*) base;
	g_return_if_fail (t != NULL);
	memset (&request, 0, sizeof (struct ipc_message_info));
	_tmp0_ = self->priv->wakelock;
	fso_framework_wakelock_acquire (_tmp0_);
	_tmp1_ = fso_framework_theLogger;
	_tmp2_ = fso_framework_logger_debug (_tmp1_, "Received data from modem; start processing ...");
	g_assert (_tmp2_);
	_tmp3_ = self->priv->rfsclient;
	_tmp5_ = ipc_client_recv (_tmp3_, &_tmp4_);
	 (&request);
	request = _tmp4_;
	rc = _tmp5_;
	_tmp6_ = rc;
	if (_tmp6_ != 0) {
		FsoFrameworkLogger* _tmp7_;
		_tmp7_ = fso_framework_theLogger;
		fso_framework_logger_error (_tmp7_, "Something went wrong while receiving data from the modem ... discardin" \
"g this request!");
		 (&request);
		return;
	}
	_tmp8_ = fso_framework_theLogger;
	_tmp9_ = request;
	_tmp10_ = samsung_ipc_response_get_command (&_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _samsung_ipc_message_type_to_string (_tmp11_);
	_tmp13_ = g_strconcat ("Got RFS request from modem: command = ", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = fso_framework_logger_debug (_tmp8_, _tmp14_);
	g_assert (_tmp15_);
	_g_free0 (_tmp14_);
	_tmp16_ = request;
	_tmp17_ = samsung_ipc_response_get_command (&_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ == IPC_RFS_NV_WRITE_ITEM) {
		struct ipc_client* _tmp19_;
		struct ipc_message_info _tmp20_;
		_tmp19_ = self->priv->rfsclient;
		_tmp20_ = request;
		ipc_rfs_send_io_confirm_for_nv_write_item (_tmp19_, &_tmp20_);
	} else {
		struct ipc_message_info _tmp21_;
		unsigned short _tmp22_;
		unsigned short _tmp23_;
		_tmp21_ = request;
		_tmp22_ = samsung_ipc_response_get_command (&_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == IPC_RFS_NV_READ_ITEM) {
			struct ipc_client* _tmp24_;
			struct ipc_message_info _tmp25_;
			_tmp24_ = self->priv->rfsclient;
			_tmp25_ = request;
			ipc_rfs_send_io_confirm_for_nv_read_item (_tmp24_, &_tmp25_);
		}
	}
	_tmp26_ = request;
	_tmp27_ = _tmp26_.data;
	_tmp27__length1 = _tmp26_.length;
	g_free (_tmp27_);
	_tmp28_ = fso_framework_theLogger;
	_tmp29_ = fso_framework_logger_debug (_tmp28_, "Handled request from modem successfully!");
	g_assert (_tmp29_);
	_tmp30_ = self->priv->wakelock;
	fso_framework_wakelock_release (_tmp30_);
	 (&request);
}


gint samsung_rfs_channel_modem_read_request (SamsungRfsChannel* self, guint8* data, int data_length1) {
	gint result = 0;
	guint8* _tmp0_;
	gint _tmp0__length1;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkTransport* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	_tmp1_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = data;
	_tmp4__length1 = data_length1;
	_tmp5_ = fso_framework_transport_read (_tmp2_, _tmp3_, _tmp4__length1);
	result = _tmp5_;
	return result;
}


gint samsung_rfs_channel_modem_write_request (SamsungRfsChannel* self, guint8* data, int data_length1) {
	gint result = 0;
	guint8* _tmp0_;
	gint _tmp0__length1;
	FsoFrameworkTransport* _tmp1_;
	FsoFrameworkTransport* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	_tmp1_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = data;
	_tmp3__length1 = data_length1;
	_tmp4_ = data;
	_tmp4__length1 = data_length1;
	_tmp5_ = fso_framework_transport_write (_tmp2_, _tmp3_, _tmp4__length1);
	result = _tmp5_;
	return result;
}


static void _samsung_rfs_channel_onHupFromTransport (SamsungRfsChannel* self) {
	g_return_if_fail (self != NULL);
}


static void _fso_framework_abstract_command_queue_onReadFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	fso_framework_abstract_command_queue_onReadFromTransport (self, transport);
}


static void __samsung_rfs_channel_onHupFromTransport_fso_framework_transport_func (FsoFrameworkTransport* transport, gpointer self) {
	_samsung_rfs_channel_onHupFromTransport (self);
}


static void __lambda5_ (SamsungRfsChannel* self, const gchar* message) {
	FsoFrameworkLogger* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (message != NULL);
	_tmp0_ = fso_framework_theLogger;
	_tmp1_ = message;
	fso_framework_logger_info (_tmp0_, _tmp1_);
}


static void ___lambda5__samsung_ipc_log_handler_cb (const gchar* message, gpointer self) {
	__lambda5_ (self, message);
}


static gint _samsung_rfs_channel_modem_read_request_samsung_ipc_transport_cb (guint8* data, int data_length1, gpointer self) {
	gint result;
	result = samsung_rfs_channel_modem_read_request (self, data, data_length1);
	return result;
}


static gint _samsung_rfs_channel_modem_write_request_samsung_ipc_transport_cb (guint8* data, int data_length1, gpointer self) {
	gint result;
	result = samsung_rfs_channel_modem_write_request (self, data, data_length1);
	return result;
}


SamsungRfsChannel* samsung_rfs_channel_construct (GType object_type, const gchar* name, FsoFrameworkTransport* transport) {
	SamsungRfsChannel * self = NULL;
	FsoFrameworkTransport* _tmp0_;
	FsoFrameworkTransport* _tmp1_;
	const gchar* _tmp2_;
	FsoFrameworkWakelock* _tmp3_;
	FsoGsmModem* _tmp4_;
	const gchar* _tmp5_;
	struct ipc_client* _tmp6_;
	struct ipc_client* _tmp7_;
	struct ipc_client* _tmp8_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = transport;
	self = (SamsungRfsChannel*) fso_framework_abstract_command_queue_construct (object_type, _tmp0_);
	_tmp1_ = transport;
	fso_framework_transport_setDelegates (_tmp1_, _fso_framework_abstract_command_queue_onReadFromTransport_fso_framework_transport_func, (FsoFrameworkAbstractCommandQueue*) self, __samsung_rfs_channel_onHupFromTransport_fso_framework_transport_func, self);
	_tmp2_ = name;
	samsung_rfs_channel_set_name (self, _tmp2_);
	_tmp3_ = fso_framework_wakelock_new ("fsogsmd-modem-samsung-rfs");
	_g_object_unref0 (self->priv->wakelock);
	self->priv->wakelock = _tmp3_;
	_tmp4_ = fso_gsm_theModem;
	_tmp5_ = name;
	fso_gsm_modem_registerChannel (_tmp4_, _tmp5_, (FsoGsmChannel*) self);
	_tmp6_ = ipc_client_new (IPC_CLIENT_TYPE_RFS);
	_ipc_client_free0 (self->priv->rfsclient);
	self->priv->rfsclient = _tmp6_;
	_tmp7_ = self->priv->rfsclient;
	ipc_client_set_log_handler (_tmp7_, ___lambda5__samsung_ipc_log_handler_cb, self);
	_tmp8_ = self->priv->rfsclient;
	ipc_client_set_io_handlers (_tmp8_, _samsung_rfs_channel_modem_read_request_samsung_ipc_transport_cb, self, _samsung_rfs_channel_modem_write_request_samsung_ipc_transport_cb, self);
	return self;
}


SamsungRfsChannel* samsung_rfs_channel_new (const gchar* name, FsoFrameworkTransport* transport) {
	return samsung_rfs_channel_construct (SAMSUNG_TYPE_RFS_CHANNEL, name, transport);
}


static void samsung_rfs_channel_real_open_data_free (gpointer _data) {
	SamsungRfsChannelOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungRfsChannelOpenData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void samsung_rfs_channel_real_open (FsoFrameworkAbstractCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungRfsChannel * self;
	SamsungRfsChannelOpenData* _data_;
	SamsungRfsChannel* _tmp0_;
	self = (SamsungRfsChannel*) base;
	_data_ = g_slice_new0 (SamsungRfsChannelOpenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_rfs_channel_real_open);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_rfs_channel_real_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_rfs_channel_real_open_co (_data_);
}


static gboolean samsung_rfs_channel_real_open_finish (FsoFrameworkAbstractCommandQueue* base, GAsyncResult* _res_) {
	gboolean result;
	SamsungRfsChannelOpenData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void samsung_rfs_channel_open_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	SamsungRfsChannelOpenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	samsung_rfs_channel_real_open_co (_data_);
}


static gboolean samsung_rfs_channel_real_open_co (SamsungRfsChannelOpenData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_result_ = TRUE;
	_data_->_tmp0_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	fso_framework_transport_openAsync (_data_->_tmp1_, samsung_rfs_channel_open_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = fso_framework_transport_openAsync_finish (_data_->_tmp1_, _data_->_res_);
	_data_->_result_ = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->_result_;
	if (!_data_->_tmp3_) {
		_data_->result = FALSE;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->rfsclient;
	ipc_client_open (_data_->_tmp4_);
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_rfs_channel_real_close_data_free (gpointer _data) {
	SamsungRfsChannelCloseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungRfsChannelCloseData, _data_);
}


static void samsung_rfs_channel_real_close (FsoFrameworkAbstractCommandQueue* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungRfsChannel * self;
	SamsungRfsChannelCloseData* _data_;
	SamsungRfsChannel* _tmp0_;
	self = (SamsungRfsChannel*) base;
	_data_ = g_slice_new0 (SamsungRfsChannelCloseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_rfs_channel_real_close);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_rfs_channel_real_close_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_rfs_channel_real_close_co (_data_);
}


static void samsung_rfs_channel_real_close_finish (FsoFrameworkAbstractCommandQueue* base, GAsyncResult* _res_) {
	SamsungRfsChannelCloseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean samsung_rfs_channel_real_close_co (SamsungRfsChannelCloseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->rfsclient;
	ipc_client_close (_data_->_tmp0_);
	_data_->_tmp1_ = fso_framework_command_queue_get_transport ((FsoFrameworkCommandQueue*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	fso_framework_transport_close (_data_->_tmp2_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_rfs_channel_real_suspend_data_free (gpointer _data) {
	SamsungRfsChannelSuspendData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungRfsChannelSuspendData, _data_);
}


static void samsung_rfs_channel_real_suspend (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungRfsChannel * self;
	SamsungRfsChannelSuspendData* _data_;
	SamsungRfsChannel* _tmp0_;
	self = (SamsungRfsChannel*) base;
	_data_ = g_slice_new0 (SamsungRfsChannelSuspendData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_rfs_channel_real_suspend);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_rfs_channel_real_suspend_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_rfs_channel_real_suspend_co (_data_);
}


static gboolean samsung_rfs_channel_real_suspend_finish (FsoGsmChannel* base, GAsyncResult* _res_) {
	gboolean result;
	SamsungRfsChannelSuspendData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean samsung_rfs_channel_real_suspend_co (SamsungRfsChannelSuspendData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void samsung_rfs_channel_real_resume_data_free (gpointer _data) {
	SamsungRfsChannelResumeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SamsungRfsChannelResumeData, _data_);
}


static void samsung_rfs_channel_real_resume (FsoGsmChannel* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SamsungRfsChannel * self;
	SamsungRfsChannelResumeData* _data_;
	SamsungRfsChannel* _tmp0_;
	self = (SamsungRfsChannel*) base;
	_data_ = g_slice_new0 (SamsungRfsChannelResumeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, samsung_rfs_channel_real_resume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, samsung_rfs_channel_real_resume_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	samsung_rfs_channel_real_resume_co (_data_);
}


static gboolean samsung_rfs_channel_real_resume_finish (FsoGsmChannel* base, GAsyncResult* _res_) {
	gboolean result;
	SamsungRfsChannelResumeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean samsung_rfs_channel_real_resume_co (SamsungRfsChannelResumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void samsung_rfs_channel_registerUnsolicitedHandler (SamsungRfsChannel* self, SamsungRfsChannelUnsolicitedHandler urchandler, void* urchandler_target) {
	g_return_if_fail (self != NULL);
}


static void samsung_rfs_channel_real_injectResponse (FsoGsmChannel* base, const gchar* response) {
	SamsungRfsChannel * self;
	self = (SamsungRfsChannel*) base;
	g_return_if_fail (response != NULL);
	g_assert_not_reached ();
}


const gchar* samsung_rfs_channel_get_name (SamsungRfsChannel* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void samsung_rfs_channel_set_name (SamsungRfsChannel* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static void samsung_rfs_channel_class_init (SamsungRfsChannelClass * klass) {
	samsung_rfs_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SamsungRfsChannelPrivate));
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->onReadFromTransport = samsung_rfs_channel_real_onReadFromTransport;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->open = samsung_rfs_channel_real_open;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->open_finish = samsung_rfs_channel_real_open_finish;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->close = samsung_rfs_channel_real_close;
	FSO_FRAMEWORK_ABSTRACT_COMMAND_QUEUE_CLASS (klass)->close_finish = samsung_rfs_channel_real_close_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_samsung_rfs_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_samsung_rfs_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = samsung_rfs_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SAMSUNG_RFS_CHANNEL_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void samsung_rfs_channel_fso_gsm_channel_interface_init (FsoGsmChannelIface * iface) {
	samsung_rfs_channel_fso_gsm_channel_parent_iface = g_type_interface_peek_parent (iface);
	iface->suspend = (gboolean (*)(FsoGsmChannel*)) samsung_rfs_channel_real_suspend;
	iface->suspend_finish = samsung_rfs_channel_real_suspend_finish;
	iface->resume = (gboolean (*)(FsoGsmChannel*)) samsung_rfs_channel_real_resume;
	iface->resume_finish = samsung_rfs_channel_real_resume_finish;
	iface->injectResponse = (void (*)(FsoGsmChannel*, const gchar*)) samsung_rfs_channel_real_injectResponse;
}


static void samsung_rfs_channel_instance_init (SamsungRfsChannel * self) {
	self->priv = SAMSUNG_RFS_CHANNEL_GET_PRIVATE (self);
}


static void samsung_rfs_channel_finalize (GObject* obj) {
	SamsungRfsChannel * self;
	self = SAMSUNG_RFS_CHANNEL (obj);
	_ipc_client_free0 (self->priv->rfsclient);
	_g_object_unref0 (self->priv->wakelock);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (samsung_rfs_channel_parent_class)->finalize (obj);
}


GType samsung_rfs_channel_get_type (void) {
	return samsung_rfs_channel_type_id;
}


GType samsung_rfs_channel_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (SamsungRfsChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) samsung_rfs_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SamsungRfsChannel), 0, (GInstanceInitFunc) samsung_rfs_channel_instance_init, NULL };
	static const GInterfaceInfo fso_gsm_channel_info = { (GInterfaceInitFunc) samsung_rfs_channel_fso_gsm_channel_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	samsung_rfs_channel_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_COMMAND_QUEUE, "SamsungRfsChannel", &g_define_type_info, 0);
	g_type_module_add_interface (module, samsung_rfs_channel_type_id, FSO_GSM_TYPE_CHANNEL, &fso_gsm_channel_info);
	return samsung_rfs_channel_type_id;
}


static void _vala_samsung_rfs_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SamsungRfsChannel * self;
	self = SAMSUNG_RFS_CHANNEL (object);
	switch (property_id) {
		case SAMSUNG_RFS_CHANNEL_NAME:
		g_value_set_string (value, samsung_rfs_channel_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_samsung_rfs_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SamsungRfsChannel * self;
	self = SAMSUNG_RFS_CHANNEL (object);
	switch (property_id) {
		case SAMSUNG_RFS_CHANNEL_NAME:
		samsung_rfs_channel_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



