#!/usr/X11R6/bin/wish -f
# Program: ftape-tool
# Tcl version: 7.6 (Tcl/Tk/XF)
# Tk version: 4.2
# XF version: 4.0
#

# module inclusion
global env
global xfLoadPath
global xfLoadInfo
set xfLoadInfo 0
global xfMisc
set xfMisc(separator) :
# Procedure: FtapeToolDir
proc FtapeToolDir {} {
    global env

    if {[info exists env(FTAPE_TOOLDIR)] == 0} {
	set env(FTAPE_TOOLDIR) [pwd]
    }
    return $env(FTAPE_TOOLDIR)
}

set xfLoadPath [FtapeToolDir]

global argc
global argv
set tmpArgv ""
for {set counter 0} {$counter < $argc} {incr counter 1} {
  case [string tolower [lindex $argv $counter]] in {
    {-xfloadpath} {
      incr counter 1
      set xfLoadPath "[lindex $argv $counter]:$xfLoadPath"
    }
    {-xfstartup} {
      incr counter 1
      source [lindex $argv $counter]
    }
    {-xfbindfile} {
      incr counter 1
      set env(XF_BIND_FILE) "[lindex $argv $counter]"
    }
    {-xfcolorfile} {
      incr counter 1
      set env(XF_COLOR_FILE) "[lindex $argv $counter]"
    }
    {-xfcursorfile} {
      incr counter 1
      set env(XF_CURSOR_FILE) "[lindex $argv $counter]"
    }
    {-xffontfile} {
      incr counter 1
      set env(XF_FONT_FILE) "[lindex $argv $counter]"
    }
    {-xfmodelmono} {
      tk colormodel . monochrome
    }
    {-xfmodelcolor} {
      tk colormodel . color
    }
    {-xfloading} {
      set xfLoadInfo 1
    }
    {-xfnoloading} {
      set xfLoadInfo 0
    }
    {default} {
      lappend tmpArgv [lindex $argv $counter]
    }
  }
}
set argv $tmpArgv
set argc [llength $tmpArgv]
unset counter
unset tmpArgv


# procedure to show window .top5
proc ShowWindow.top5 {args} {# xf ignore me 7

  # build widget .top5
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top5"
  } {
    catch "destroy .top5"
  }
  toplevel .top5 

  # Window manager configurations
  wm positionfrom .top5 ""
  wm sizefrom .top5 program
  wm geometry .top5 212x84
  wm maxsize .top5 212 84
  wm minsize .top5 212 84
  wm protocol .top5 WM_DELETE_WINDOW {XFProcError {Application windows can not be destroyed.
Please use the "Current widget path:" to show/hide windows.}}
  wm title .top5 {Set Partition}


  # build widget .top5.frame7
  frame .top5.frame7 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .top5.frame7.scale6
  scale .top5.frame7.scale6 \
    -orient {horizontal} \
    -relief {raised} \
    -to {1.0} -variable PartitionNumber

  # build widget .top5.frame8
  frame .top5.frame8 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .top5.frame8.button9
  button .top5.frame8.button9 \
    -command {TapeCmd $Options(NoRewindDevice) "setpart $PartitionNumber" CmdPipeFD
DestroyWindow[SN SetPartDialog]} \
    -padx {9} \
    -pady {3} \
    -text {Accept}

  # build widget .top5.frame8.button10
  button .top5.frame8.button10 \
    -command {DestroyWindow[SN SetPartDialog]} \
    -padx {9} \
    -pady {3} \
    -text {Cancel}

  # pack master .top5.frame7
  pack configure .top5.frame7.scale6 \
    -anchor n \
    -expand 1 \
    -fill x

  # pack master .top5.frame8
  pack configure .top5.frame8.button9 \
    -expand 1 \
    -fill x \
    -side left
  pack configure .top5.frame8.button10 \
    -expand 1 \
    -fill both \
    -side left

  # pack master .top5
  pack configure .top5.frame7 \
    -expand 1 \
    -fill x
  pack configure .top5.frame8 \
    -fill x

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top5"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top5 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top5]" != ""} {
      global xfShowWindow.top5
      set xfShowWindow.top5 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top5; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top5"
    update
  }
}


# procedure to show window ShowWindow.top1
proc ShowWindow.top1 { args} {
# xf ignore me 7

  # build widget .top1
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top1"
  } {
    catch "destroy .top1"
  }
  toplevel .top1 

  # Window manager configurations
  wm positionfrom .top1 ""
  wm sizefrom .top1 program
  wm geometry .top1 212x202
  wm maxsize .top1 212 202
  wm minsize .top1 212 202
  wm protocol .top1 WM_DELETE_WINDOW DestroyWindow.top1
  wm title .top1 {Quit Dialog}
  wm resizable .top1 0 0


  # build widget .top1.frame7
  frame .top1.frame7  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top1.frame7.button11
  button .top1.frame7.button11  -image {ftapetoolsmallLOGO}  -padx {9}  -pady {3}  -text {button11}

  # build widget .top1.frame8
  frame .top1.frame8  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top1.frame8.button9
  button .top1.frame8.button9  -command {exit}  -padx {9}  -pady {3}  -text {Exit}

  # build widget .top1.frame8.button10
  button .top1.frame8.button10  -command {DestroyWindow.top1}  -padx {9}  -pady {3}  -state {active}  -text {Continue}

  # pack master .top1.frame7
  pack configure .top1.frame7.button11  -expand 1  -fill both

  # pack master .top1.frame8
  pack configure .top1.frame8.button9  -expand 1  -fill x  -side left
  pack configure .top1.frame8.button10  -expand 1  -fill both  -side left

  # pack master .top1
  pack configure .top1.frame7  -expand 1  -fill both
  pack configure .top1.frame8  -fill x

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top1"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top1 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top1]" != ""} {
      global xfShowWindow.top1
      set xfShowWindow.top1 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top1; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top1"
    update
  }
}


# procedure to show window ShowWindow.top2
proc ShowWindow.top2 { args} {
# xf ignore me 7

  # build widget .top2
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top2"
  } {
    catch "destroy .top2"
  }
  toplevel .top2 

  # Window manager configurations
  wm positionfrom .top2 ""
  wm sizefrom .top2 ""
  wm maxsize .top2 1000 1000
  wm minsize .top2 10 10
  wm title .top2 {User Information Window}
  wm resizable .top2 0 0


  # build widget .top2.frame4
  frame .top2.frame4  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top2.frame4.message6
  message .top2.frame4.message6  -aspect {1500}  -padx {5}  -pady {2}  -relief {sunken}  -text {Waiting for the tape drive to finish. Please have a little patience.}  -textvariable {UserInfoString}

  # build widget .top2.frame4.button0
  button .top2.frame4.button0  -background {White}  -image {ftapetoolsmallLOGO}  -padx {9}  -pady {3}  -state {active}  -text {button0}

  # pack master .top2.frame4
  pack configure .top2.frame4.message6  -fill both
  pack configure .top2.frame4.button0  -fill both

  # pack master .top2
  pack configure .top2.frame4  -fill both

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top2"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top2 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top2]" != ""} {
      global xfShowWindow.top2
      set xfShowWindow.top2 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top2; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top2"
    update
  }
}


# procedure to show window ShowWindow.top3
proc ShowWindow.top3 { args} {
# xf ignore me 7

  # build widget .top3
  if {"[info procs XFEdit]" != ""} {
    catch "XFDestroy .top3"
  } {
    catch "destroy .top3"
  }
  toplevel .top3 

  # Window manager configurations
  wm positionfrom .top3 ""
  wm sizefrom .top3 ""
  wm maxsize .top3 1000 1000
  wm minsize .top3 10 10
  wm protocol .top3 WM_DELETE_WINDOW DestroyWindow.top3
  wm title .top3 {Preferences}
  wm resizable .top3 0 0


  # build widget .top3.frame5
  frame .top3.frame5  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # build widget .top3.frame5.button6
  button .top3.frame5.button6  -command {set Options(NoRewindDevice) $newtapedev
set Options(RewindDevice) $newrtapedev
set Options(RawNoRewindDevice) $newrawdev
set Options(RawRewindDevice) $newrrawdev
DestroyWindow.top3}  -padx {9}  -pady {3}  -text {Accept}

  # build widget .top3.frame5.button7
  button .top3.frame5.button7  -command {DestroyWindow.top3}  -padx {9}  -pady {3}  -state {active}  -text {Cancel}

  # build widget .top3.frame5.button1
  button .top3.frame5.button1  -command {set Options(NoRewindDevice) $newtapedev
set Options(RewindDevice) $newrtapedev
set Options(RawNoRewindDevice) $newrawdev
set Options(RawRewindDevice) $newrrawdev
SaveOptions
DestroyWindow.top3}  -padx {9}  -pady {3}  -text {Save}

  # build widget .top3.frame
  frame .top3.frame  -relief {sunken}

  # build widget .top3.frame.entry5
  entry .top3.frame.entry5  -textvariable {newtapedev}  -width {14}

  # build widget .top3.frame.menubutton11
  menubutton .top3.frame.menubutton11  -menu {.top3.frame.menubutton11.m}  -padx {2}  -pady {2}  -relief {raised}  -text {Tape Device:}

  # build widget .top3.frame.menubutton11.m
  menu .top3.frame.menubutton11.m
  .top3.frame.menubutton11.m add command  -command {set newtapedev "/dev/nqft0"
set newrtapedev "/dev/qft0"
set newrawdev "/dev/nrawft0"
set newrrawdev "/dev/rawft0"}  -label {/dev/(n)qft0}
  .top3.frame.menubutton11.m add command  -command {set newtapedev "/dev/nqft1"
set newrtapedev "/dev/qft1"
set newrawdev "/dev/nrawft1"
set newrrawdev "/dev/rawft1"}  -label {/dev/(n)qft1}
  .top3.frame.menubutton11.m add command  -command {set newtapedev "/dev/nqft2"
set newrtapedev "/dev/qft2"
set newrawdev "/dev/nrawft2"
set newrrawdev "/dev/rawft2"}  -label {/dev/(n)qft2}
  .top3.frame.menubutton11.m add command  -command {set newtapedev "/dev/nqft3"
set newrtapedev "/dev/qft3"
set newrawdev "/dev/nrawft3"
set newrrawdev "/dev/rawft3"}  -label {/dev/(n)qft3}

  # build widget .top3.frame0
  frame .top3.frame0  -relief {raised}

  # build widget .top3.frame0.entry5
  entry .top3.frame0.entry5  -textvariable {newrawdev}  -width {14}

  # build widget .top3.frame0.menubutton12
  menubutton .top3.frame0.menubutton12  -menu {.top3.frame0.menubutton12.m}  -padx {2}  -pady {2}  -relief {raised}  -text {Raw Device:}

  # build widget .top3.frame0.menubutton12.m
  menu .top3.frame0.menubutton12.m
  .top3.frame0.menubutton12.m add command  -command {set newtapedev "/dev/nqft0"
set newrtapedev "/dev/qft0"
set newrawdev "/dev/nrawft0"
set newrrawdev "/dev/rawft0"}  -label {/dev/(n)rawft0}
  .top3.frame0.menubutton12.m add command  -command {set newtapedev "/dev/nqft1"
set newrtapedev "/dev/qft1"
set newrawdev "/dev/nrawft1"
set newrrawdev "/dev/rawft1"}  -label {/dev/(n)rawft1}
  .top3.frame0.menubutton12.m add command  -command {set newtapedev "/dev/nqft2"
set newrtapedev "/dev/qft2"
set newrawdev "/dev/nrawft2"
set newrrawdev "/dev/rawft2"}  -label {/dev/(n)rawft2}
  .top3.frame0.menubutton12.m add command  -command {set newtapedev "/dev/nqft3"
set newrtapedev "/dev/qft3"
set newrawdev "/dev/nrawft3"
set newrrawdev "/dev/rawft3"}  -label {/dev/(n)rawft3}

  # build widget .top3.frame13
  frame .top3.frame13  -borderwidth {2}  -height {30}  -relief {raised}  -width {30}

  # pack master .top3.frame5
  pack configure .top3.frame5.button6  -expand 1  -fill x  -side left
  pack configure .top3.frame5.button7  -expand 1  -fill x  -side right
  pack configure .top3.frame5.button1  -expand 1  -fill x  -side left

  # pack master .top3.frame
  pack configure .top3.frame.entry5  -expand 1  -fill x  -side right
  pack configure .top3.frame.menubutton11  -expand 1  -fill x  -side left

  # pack master .top3.frame0
  pack configure .top3.frame0.entry5  -expand 1  -fill x  -side right
  pack configure .top3.frame0.menubutton12  -expand 1  -fill x  -side left

  # pack master .top3
  pack configure .top3.frame5  -fill both  -side bottom
  pack configure .top3.frame  -fill both
  pack configure .top3.frame0  -expand 1  -fill both
  pack configure .top3.frame13  -expand 1  -fill both  -side left

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree .top3"
    after 2 "catch {XFEditSetShowWindows}"
  }
}

proc DestroyWindow.top3 {} {# xf ignore me 7
  if {"[info procs XFEdit]" != ""} {
    if {"[info commands .top3]" != ""} {
      global xfShowWindow.top3
      set xfShowWindow.top3 0
      XFEditSetPath .
      after 2 "XFSaveAsProc .top3; XFEditSetShowWindows"
    }
  } {
    catch "destroy .top3"
    update
  }
}


# procedure to show window .
proc ShowWindow. {args} {# xf ignore me 7

  # Window manager configurations
  wm positionfrom . user
  wm sizefrom . ""
  wm maxsize . 1280 1024
  wm minsize . 443 411
  wm protocol . WM_DELETE_WINDOW ShowWindow[SN QuitDialog]
  wm title . {ftape-tool}
  wm resizable . 0 0

  # build widget .frame0
  frame .frame0 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .frame0.menubutton5
  menubutton .frame0.menubutton5 \
    -menu {.frame0.menubutton5.m} \
    -padx {4} \
    -pady {3} \
    -text {File}

  # build widget .frame0.menubutton5.m
  menu .frame0.menubutton5.m \
    -tearoff {1}
  .frame0.menubutton5.m add command \
    -command {set cmdstatus "ready"
	if {"[info procs XFEdit]" == ""} {
	    for {set i 0} {$i < 100} {set i [expr $i + 1]} {
		catch {destroy .frame$i}
		catch {destroy .tearoff$i}
		catch {destroy .top$i}
	    }
	    exec $argv0 &
	    catch {destroy .}
	}
	global outputframe
	catch {destroy $outputframe}
	set outputframe [SN logoframe]
	VFrame[SN logoframe] [SN logoframe]
	UpdateTapeButtons "" "stop"} \
    -label {Restart}
  .frame0.menubutton5.m add command \
    -command {ShowWindow[SN QuitDialog]
CloseFD CmdPipeFD 1} \
    -label {Quit}

  # build widget .frame0.menubutton0
  menubutton .frame0.menubutton0 \
    -menu {.frame0.menubutton0.m} \
    -padx {4} \
    -pady {3} \
    -text {Help}

  # build widget .frame0.menubutton0.m
  menu .frame0.menubutton0.m \
    -tearoff {1}
  .frame0.menubutton0.m add command \
    -command {ShowWindow.top0} \
    -label {About}
  .frame0.menubutton0.m add command \
    -command {ShowWindow[SN COPYING]
	  catch {FileInList [SN COPYING].frame.listbox1 [FtapeToolDir]/COPYING}} \
    -label {COPYING}

  # build widget .frame0.menubutton13
  menubutton .frame0.menubutton13 \
    -menu {.frame0.menubutton13.m} \
    -padx {4} \
    -pady {3} \
    -text {Tape}

  # build widget .frame0.menubutton13.m
  menu .frame0.menubutton13.m \
    -tearoff {1}
  .frame0.menubutton13.m add command \
    -command {TapeCmd $Options(NoRewindDevice) "status" CmdPipeFD} \
    -label {Status}
  .frame0.menubutton13.m add command \
    -command {MakeContentsFrame} \
    -label {Contents}
  .frame0.menubutton13.m add command \
    -command {TapeCmd $Options(NoRewindDevice) "rewind" CmdPipeFD} \
    -label {Rewind}
  .frame0.menubutton13.m add command \
    -command {TapeCmd $Options(NoRewindDevice) "reten" CmdPipeFD} \
    -label {Retension}
  .frame0.menubutton13.m add command \
    -command {TapeCmd $Options(NoRewindDevice) "rewoffl" CmdPipeFD} \
    -label {Eject}
  .frame0.menubutton13.m add command \
    -command {TapeCmd $Options(NoRewindDevice) "load" CmdPipeFD} \
    -label {Load}
  .frame0.menubutton13.m add command \
    -command {ShowWindow[SN SetPartDialog]} \
    -label {SetPart}
  .frame0.menubutton13.m add command \
    -command {if {[AlertBox "WARNING: FILE MARKS AND DATA MIGHT BE LOST"  "" "" "Reset" "CANCEL" "OK"] == 1} {
	AlertBox "YOU HAVE BEEN WARNED" "" "" "Reset" "CONTINUE"
	TapeCmd $Options(NoRewindDevice) "reset" CmdPipeFD
}} \
    -label {Reset}
  .frame0.menubutton13.m add command \
    -command {if {[AlertBox "WARNING: ALL DATA WILL BE ERASED"  "" "" "Erase" "CANCEL" "OK"] == 1} {
	AlertBox "YOU HAVE BEEN WARNED" "" "" "Erase" "CONTINUE"
	TapeCmd $Options(NoRewindDevice) "erase" CmdPipeFD
}} \
    -label {Erase}
  .frame0.menubutton13.m add command \
    -command {MakeFormatFrame} \
    -label {Format}

  # build widget .frame0.menubutton1
  menubutton .frame0.menubutton1 \
    -menu {.frame0.menubutton1.m} \
    -padx {4} \
    -pady {3} \
    -text {Options}

  # build widget .frame0.menubutton1.m
  menu .frame0.menubutton1.m \
    -tearoff {1}
  .frame0.menubutton1.m add command \
    -command {set newtapedev $Options(NoRewindDevice)
set newrawdev $Options(RawNoRewindDevice)
ShowWindow.top3} \
    -label {Preferences}
  .frame0.menubutton1.m add command \
    -command {SaveOptions} \
    -label {Save Options}
  .frame0.menubutton1.m add command \
    -command {fileselect SaveOptions} \
    -label {Save Options As}
  .frame0.menubutton1.m add command \
    -command {ReadOptions Options} \
    -label {Read Options}
  .frame0.menubutton1.m add command \
    -command {fileselect ReadOptions} \
    -label {Read Options From}

  # build widget .frame1
  frame .frame1 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .frame1.button3
  button .frame1.button3 \
    -command {TapeCmd $Options(NoRewindDevice) "status" CmdPipeFD} \
    -padx {9} \
    -pady {3} \
    -text {Status}

  # build widget .frame1.button0
  button .frame1.button0 \
    -command {TapeCmd $Options(NoRewindDevice) "rewind" CmdPipeFD} \
    -padx {9} \
    -pady {3} \
    -text {Rewind}

  # build widget .frame1.button2
  button .frame1.button2 \
    -command {TapeCmd $Options(NoRewindDevice) "reten" CmdPipeFD} \
    -padx {9} \
    -pady {3} \
    -text {Retension}

  # build widget .frame1.button4
  button .frame1.button4 \
    -command {if {[AlertBox "WARNING: ALL DATA WILL BE ERASED"  "" "" "Erase" "CANCEL" "OK"] == 1} {
	AlertBox "YOU HAVE BEEN WARNED" "" "" "Erase" "CONTINUE"
	TapeCmd $Options(NoRewindDevice) "erase" CmdPipeFD
}} \
    -padx {9} \
    -pady {3} \
    -text {Erase}

  # build widget .frame1.button5
  button .frame1.button5 \
    -command {MakeContentsFrame} \
    -padx {9} \
    -pady {3} \
    -text {Contents}

  # build widget .frame1.button6
  button .frame1.button6 \
    -command {MakeFormatFrame
#ShowWindow.top2} \
    -padx {9} \
    -pady {3} \
    -text {Format}

  # build widget .frame1.button7
  button .frame1.button7 \
    -command {ShowWindow[SN QuitDialog]
CloseFD CmdPipeFD 1} \
    -padx {9} \
    -pady {3} \
    -text {Quit}

  # build widget .frame1.button1
  button .frame1.button1 \
    -command {if {[AlertBox "WARNING: FILE MARKS AND DATA MIGHT BE LOST"  "" "" "Reset" "CANCEL" "OK"] == 1} {
	AlertBox "YOU HAVE BEEN WARNED" "" "" "Reset" "CONTINUE"
	TapeCmd $Options(NoRewindDevice) "reset" CmdPipeFD
}} \
    -padx {9} \
    -pady {3} \
    -text {Reset}

  # build widget .frame1.button8
  button .frame1.button8 \
    -command {TapeCmd $Options(NoRewindDevice) "load" CmdPipeFD} \
    -padx {9} \
    -pady {3} \
    -text {Load}

  # build widget .frame1.button9
  button .frame1.button9 \
    -command {TapeCmd $Options(NoRewindDevice) "rewoffl" CmdPipeFD} \
    -padx {9} \
    -pady {3} \
    -text {Eject}

  # build widget .frame1.button10
  button .frame1.button10 \
    -command {ShowWindow[SN SetPartDialog]} \
    -padx {9} \
    -pady {3} \
    -text {SetPart}

  # build widget .frame3
  frame .frame3 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .frame3.frame0
  frame .frame3.frame0 \
    -relief {raised}

  # build widget .frame3.frame0.entry5
  entry .frame3.frame0.entry5 \
    -textvariable {Options(RawNoRewindDevice)} \
    -width {13}

  # build widget .frame3.frame0.menubutton12
  menubutton .frame3.frame0.menubutton12 \
    -menu {.frame3.frame0.menubutton12.m} \
    -padx {2} \
    -pady {2} \
    -relief {groove} \
    -text {v}

  # build widget .frame3.frame0.menubutton12.m
  menu .frame3.frame0.menubutton12.m
  .frame3.frame0.menubutton12.m add command \
    -command {set Options(NoRewindDevice) "/dev/nqft0"
set Options(RewindDevice) "/dev/qft0"
set Options(RawNoRewindDevice) "/dev/nrawft0"
set Options(RawRewindDevice) "/dev/rawft0"} \
    -label {/dev/(n)rawft0}
  .frame3.frame0.menubutton12.m add command \
    -command {set Options(NoRewindDevice) "/dev/nqft1"
set Options(RewindDevice) "/dev/qft1"
set Options(RawNoRewindDevice) "/dev/nrawft1"
set Options(RawRewindDevice) "/dev/rawft1"} \
    -label {/dev/(n)rawft1}
  .frame3.frame0.menubutton12.m add command \
    -command {set Options(NoRewindDevice) "/dev/nqft2"
set Options(RewindDevice) "/dev/qft2"
set Options(RawNoRewindDevice) "/dev/nrawft2"
set Options(RawRewindDevice) "/dev/rawft2"} \
    -label {/dev/(n)rawft2}
  .frame3.frame0.menubutton12.m add command \
    -command {set Options(NoRewindDevice) "/dev/nqft3"
set Options(RewindDevice) "/dev/qft3"
set Options(RawNoRewindDevice) "/dev/nrawft3"
set Options(RawRewindDevice) "/dev/rawft3"} \
    -label {/dev/(n)rawft3}

  # build widget .frame3.frame0.label2
  label .frame3.frame0.label2 \
    -text {Raw Device:}

  # build widget .frame3.frame
  frame .frame3.frame \
    -relief {sunken}

  # build widget .frame3.frame.entry5
  entry .frame3.frame.entry5 \
    -textvariable {Options(NoRewindDevice)} \
    -width {12}

  # build widget .frame3.frame.menubutton11
  menubutton .frame3.frame.menubutton11 \
    -menu {.frame3.frame.menubutton11.m} \
    -padx {2} \
    -pady {2} \
    -relief {groove} \
    -text {v}

  # build widget .frame3.frame.menubutton11.m
  menu .frame3.frame.menubutton11.m
  .frame3.frame.menubutton11.m add command \
    -command {set Options(NoRewindDevice) "/dev/nqft0"
set Options(RewindDevice) "/dev/qft0"
set Options(RawNoRewindDevice) "/dev/nrawft0"
set Options(RawRewindDevice) "/dev/rawft0"} \
    -label {/dev/(n)qft0}
  .frame3.frame.menubutton11.m add command \
    -command {set Options(NoRewindDevice) "/dev/nqft1"
set Options(RewindDevice) "/dev/qft1"
set Options(RawNoRewindDevice) "/dev/nrawft1"
set Options(RawRewindDevice) "/dev/rawft1"} \
    -label {/dev/(n)qft1}
  .frame3.frame.menubutton11.m add command \
    -command {set Options(NoRewindDevice) "/dev/nqft2"
set Options(RewindDevice) "/dev/qft2"
set Options(RawNoRewindDevice) "/dev/nrawft2"
set Options(RawRewindDevice) "/dev/rawft2"} \
    -label {/dev/(n)qft2}
  .frame3.frame.menubutton11.m add command \
    -command {set Options(NoRewindDevice) "/dev/nqft3"
set Options(RewindDevice) "/dev/qft3"
set Options(RawNoRewindDevice) "/dev/nrawft3"
set Options(RawRewindDevice) "/dev/rawft3"} \
    -label {/dev/(n)qft3}

  # build widget .frame3.frame.label1
  label .frame3.frame.label1 \
    -text {Tape Device:}

  # build widget .frame4
  frame .frame4 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .frame4.frame
  frame .frame4.frame

  # build widget .frame4.frame.scrollbar1
  scrollbar .frame4.frame.scrollbar1 \
    -command {.frame4.frame.entry2 xview} \
    -orient {horizontal} \
    -width {11}

  # build widget .frame4.frame.entry2
  entry .frame4.frame.entry2 \
    -foreground {Blue} \
    -textvariable {cmdstatus} \
    -xscrollcommand {.frame4.frame.scrollbar1 set}

  # build widget .tearoff1
  menu .tearoff1 \
    -tearoff {0}
  .tearoff1 add command \
    -command {TapeCmd $Options(NoRewindDevice) "status" CmdPipeFD} \
    -label {Status}
  .tearoff1 add command \
    -command {TapeCmd $Options(NoRewindDevice) "rewind" CmdPipeFD} \
    -label {Rewind}
  .tearoff1 add command \
    -command {TapeCmd $Options(NoRewindDevice) "reten" CmdPipeFD} \
    -label {Retension}
  .tearoff1 add command \
    -command {if {[AlertBox "WARNING: ALL DATA WILL BE ERASED"  "" "" "Erase" "CANCEL" "OK"] == 1} {
	AlertBox "YOU HAVE BEEN WARNED" "" "" "Erase" "CONTINUE"
	TapeCmd $Options(NoRewindDevice) "erase" CmdPipeFD
}} \
    -label {Erase}
  .tearoff1 add command \
    -command { TapeContents $Options(RawNoRewindDevice) CmdPipeFD } \
    -label {Contents}
  .tearoff1 add command \
    -command {ShowWindow.top8} \
    -label {Format}
  # bindings
  bind .tearoff1 <Enter> {
	set tkPriv(focus) %W
    }

  # build widget .frame2
  frame .frame2 \
    -borderwidth {2} \
    -height {30} \
    -relief {raised} \
    -width {30}

  # build widget .frame2.button6
  button .frame2.button6 \
    -image {ftapeLOGO} \
    -padx {9} \
    -pady {3} \
    -text {button6}

  # pack master .frame0
  pack configure .frame0.menubutton5 \
    -side left
  pack configure .frame0.menubutton0 \
    -fill x \
    -side right
  pack configure .frame0.menubutton13 \
    -fill x \
    -side left
  pack configure .frame0.menubutton1 \
    -anchor w \
    -side left

  # pack master .frame1
  pack configure .frame1.button3 \
    -expand 1 \
    -fill both
  pack configure .frame1.button5 \
    -expand 1 \
    -fill both
  pack configure .frame1.button0 \
    -expand 1 \
    -fill both
  pack configure .frame1.button2 \
    -expand 1 \
    -fill both
  pack configure .frame1.button9 \
    -expand 1 \
    -fill both
  pack configure .frame1.button8 \
    -expand 1 \
    -fill both
  pack configure .frame1.button10 \
    -expand 1 \
    -fill both
  pack configure .frame1.button1 \
    -expand 1 \
    -fill both
  pack configure .frame1.button4 \
    -expand 1 \
    -fill both
  pack configure .frame1.button6 \
    -expand 1 \
    -fill both
  pack configure .frame1.button7 \
    -expand 1 \
    -fill both

  # pack master .frame3
  pack configure .frame3.frame0 \
    -expand 1 \
    -fill x \
    -side right
  pack configure .frame3.frame \
    -fill both

  # pack master .frame3.frame0
  pack configure .frame3.frame0.entry5 \
    -expand 1 \
    -fill x \
    -side right
  pack configure .frame3.frame0.label2 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .frame3.frame0.menubutton12 \
    -expand 1 \
    -fill x \
    -side left

  # pack master .frame3.frame
  pack configure .frame3.frame.entry5 \
    -expand 1 \
    -fill x \
    -side right
  pack configure .frame3.frame.label1 \
    -expand 1 \
    -fill both \
    -side left
  pack configure .frame3.frame.menubutton11 \
    -expand 1 \
    -fill x \
    -side left

  # pack master .frame4
  pack configure .frame4.frame \
    -fill both

  # pack master .frame4.frame
  pack configure .frame4.frame.entry2 \
    -fill both
  pack configure .frame4.frame.scrollbar1 \
    -fill x

  # pack master .frame2
  pack configure .frame2.button6

  # pack master .
  pack configure .frame0 \
    -fill x
  pack configure .frame1 \
    -fill y \
    -side left
  pack configure .frame3 \
    -fill x \
    -side bottom
  pack configure .frame4 \
    -fill x \
    -side bottom
  pack configure .frame2 \
    -expand 1 \
    -fill both

  if {"[info procs XFEdit]" != ""} {
    catch "XFMiscBindWidgetTree ."
    after 2 "catch {XFEditSetShowWindows}"
  }
}


# User defined procedures


# Procedure: AlertBox
proc AlertBox { {alertBoxMessage "Alert message"} {alertBoxCommand ""} {alertBoxGeometry "350x150"} {alertBoxTitle "Alert box"} args} {
# xf ignore me 5
##########
# Procedure: AlertBox
# Description: show alert box
# Arguments: {alertBoxMessage} - the text to display
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          AlertBoxFile - to open and read a file automatically
#          AlertBoxFd - to read from an already opened filedescriptor
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxCommand\}" "\{$alertBoxGeometry\}" "\{$alertBoxTitle\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxCommand $alertBoxGeometry $alertBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $alertBox(toplevelName)
    tkwait window $alertBox(toplevelName)

    return $alertBox(button)
  }
}


# Procedure: AlertBoxFd
proc AlertBoxFd { {alertBoxInFile ""} {alertBoxCommand ""} {alertBoxGeometry "350x150"} {alertBoxTitle "Alert box"} args} {
# xf ignore me 5
##########
# Procedure: AlertBoxFd
# Description: show alert box containing a filedescriptor
# Arguments: {alertBoxInFile} - a filedescriptor to read. The descriptor
#                               is closed after reading
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          AlertBox - to display a passed string
#          AlertBoxFile - to open and read a file automatically
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  # check file existance
  if {"$alertBoxInFile" == ""} {
    puts stderr "No filedescriptor specified"
    return
  }

  set alertBoxMessage [read $alertBoxInFile]
  close $alertBoxInFile

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxCommand\}" "\{$alertBoxGeometry\}" "\{$alertBoxTitle\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxCommand $alertBoxGeometry $alertBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $alertBox(toplevelName)
    tkwait window $alertBox(toplevelName)

    return $alertBox(button)
  }
}


# Procedure: AlertBoxFile
proc AlertBoxFile { {alertBoxFile ""} {alertBoxCommand ""} {alertBoxGeometry "350x150"} {alertBoxTitle "Alert box"} args} {
# xf ignore me 5
##########
# Procedure: AlertBoxFile
# Description: show alert box containing a file
# Arguments: {alertBoxFile} - filename to read
#            {alertBoxCommand} - the command to call after ok
#            {alertBoxGeometry} - the geometry for the window
#            {alertBoxTitle} - the title for the window
#            {args} - labels of buttons
# Returns: The number of the selected button, ot nothing
# Sideeffects: none
# Notes: there exist also functions called:
#          AlertBox - to display a passed string
#          AlertBoxFd - to read from an already opened filedescriptor
##########
#
# global alertBox(activeBackground) - active background color
# global alertBox(activeForeground) - active foreground color
# global alertBox(after) - destroy alert box after n seconds
# global alertBox(anchor) - anchor for message box
# global alertBox(background) - background color
# global alertBox(font) - message font
# global alertBox(foreground) - foreground color
# global alertBox(justify) - justify for message box
# global alertBox(toplevelName) - the toplevel name

  global alertBox

  # check file existance
  if {"$alertBoxFile" == ""} {
    puts stderr "No filename specified"
    return
  }

  if {[catch "open $alertBoxFile r" alertBoxInFile]} {
    puts stderr "$alertBoxInFile"
    return
  }

  set alertBoxMessage [read $alertBoxInFile]
  close $alertBoxInFile

  # show alert box
  if {[llength $args] > 0} {
    eval AlertBoxInternal "\{$alertBoxMessage\}" "\{$alertBoxCommand\}" "\{$alertBoxGeometry\}" "\{$alertBoxTitle\}" $args
  } {
    AlertBoxInternal $alertBoxMessage $alertBoxCommand $alertBoxGeometry $alertBoxTitle
  }

  if {[llength $args] > 0} {
    # wait for the box to be destroyed
    update idletask
    grab $alertBox(toplevelName)
    tkwait window $alertBox(toplevelName)

    return $alertBox(button)
  }
}


# Procedure: AlertBoxInternal
proc AlertBoxInternal { alertBoxMessage alertBoxCommand alertBoxGeometry alertBoxTitle args} {
# xf ignore me 6
  global alertBox

  set tmpButtonOpt ""
  set tmpFrameOpt ""
  set tmpMessageOpt ""
  if {"$alertBox(activeBackground)" != ""} {
    append tmpButtonOpt "-activebackground \"$alertBox(activeBackground)\" "
  }
  if {"$alertBox(activeForeground)" != ""} {
    append tmpButtonOpt "-activeforeground \"$alertBox(activeForeground)\" "
  }
  if {"$alertBox(background)" != ""} {
    append tmpButtonOpt "-background \"$alertBox(background)\" "
    append tmpFrameOpt "-background \"$alertBox(background)\" "
    append tmpMessageOpt "-background \"$alertBox(background)\" "
  }
  if {"$alertBox(font)" != ""} {
    append tmpButtonOpt "-font \"$alertBox(font)\" "
    append tmpMessageOpt "-font \"$alertBox(font)\" "
  }
  if {"$alertBox(foreground)" != ""} {
    append tmpButtonOpt "-foreground \"$alertBox(foreground)\" "
    append tmpMessageOpt "-foreground \"$alertBox(foreground)\" "
  }

  # start build of toplevel
  if {"[info commands XFDestroy]" != ""} {
    catch {XFDestroy $alertBox(toplevelName)}
  } {
    catch {destroy $alertBox(toplevelName)}
  }
  toplevel $alertBox(toplevelName)  -borderwidth 0
  catch "$alertBox(toplevelName) config $tmpFrameOpt"
  if {[catch "wm geometry $alertBox(toplevelName) $alertBoxGeometry"]} {
    wm geometry $alertBox(toplevelName) 350x150
  }
  wm title $alertBox(toplevelName) $alertBoxTitle
  wm maxsize $alertBox(toplevelName) 1000 1000
  wm minsize $alertBox(toplevelName) 100 100
  # end build of toplevel

  message $alertBox(toplevelName).message1  -anchor "$alertBox(anchor)"  -justify "$alertBox(justify)"  -relief raised  -text "$alertBoxMessage"
  catch "$alertBox(toplevelName).message1 config $tmpMessageOpt"

  set xfTmpWidth  [string range $alertBoxGeometry 0 [expr [string first x $alertBoxGeometry]-1]]
  if {"$xfTmpWidth" != ""} {
    # set message size
    catch "$alertBox(toplevelName).message1 configure  -width [expr $xfTmpWidth-10]"
  } {
    $alertBox(toplevelName).message1 configure  -aspect 1500
  }

  frame $alertBox(toplevelName).frame1  -borderwidth 0  -relief raised
  catch "$alertBox(toplevelName).frame1 config $tmpFrameOpt"

  set alertBoxCounter 0
  set buttonNum [llength $args]
  if {$buttonNum > 0} {
    while {$alertBoxCounter < $buttonNum} {
      button $alertBox(toplevelName).frame1.button$alertBoxCounter  -text "[lindex $args $alertBoxCounter]"  -command "
          global alertBox
          set alertBox(button) $alertBoxCounter
          if {\"\[info commands XFDestroy\]\" != \"\"} {
            catch {XFDestroy $alertBox(toplevelName)}
          } {
            catch {destroy $alertBox(toplevelName)}
          }"
      catch "$alertBox(toplevelName).frame1.button$alertBoxCounter config $tmpButtonOpt"

      pack append $alertBox(toplevelName).frame1  $alertBox(toplevelName).frame1.button$alertBoxCounter {left fillx expand}

      incr alertBoxCounter
    }
  } {
    button $alertBox(toplevelName).frame1.button0  -text "OK"  -command "
        global alertBox
        set alertBox(button) 0
        if {\"\[info commands XFDestroy\]\" != \"\"} {
          catch {XFDestroy $alertBox(toplevelName)}
        } {
          catch {destroy $alertBox(toplevelName)}
        }
        $alertBoxCommand"
    catch "$alertBox(toplevelName).frame1.button0 config $tmpButtonOpt"

    pack append $alertBox(toplevelName).frame1  $alertBox(toplevelName).frame1.button0 {left fillx expand}
  }

  # packing
  pack append $alertBox(toplevelName)  $alertBox(toplevelName).frame1 {bottom fill}  $alertBox(toplevelName).message1 {top fill expand}

  if {$alertBox(after) != 0} {
    after [expr $alertBox(after)*1000]  "catch \"$alertBox(toplevelName).frame1.button0 invoke\""
  }
}


# Procedure: CSN
proc CSN { {xfName ""}} {
    CheckSymbolicName $xfName
}


# Procedure: CheckSymbolicName
proc CheckSymbolicName { {xfName ""}} {
  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
	return "1"
    } else {
	return "0"
    }
  }
  return "0"
}


# Procedure: ClearList
proc ClearList { listWidget} {
# xf ignore me 5
##########
# Procedure: ClearList
# Description: clear listbox widget
# Arguments: listWidget - the widget to clear
# Returns: none
# Sideeffects: the list widget is cleared
##########

  if {[$listWidget size] > 0} {
    $listWidget delete 0 end
   }
}


# Procedure: CloseFD
proc CloseFD { FDname {kill "0"}} {
    upvar \#0 $FDname fd
    global UserInfoString
    global starttime
    global CmdPipeFD

    #puts "FDname: $FDname, fd: $fd, CmdPipeFD: $CmdPipeFD\n"
    if {$fd != ""} {	
	catch {fileevent $fd readable {}}
	set UserInfoString  "Waiting for the tape drive to finish. Please have a little patience."
#	puts $UserInfoString\n
	ShowWindow[SN UserInfoTop]
	update
# This doesn't work. Unluckily.
#
#	if {[catch {clock seconds} starttime] == 0} {
#	    UpdateTime
#	}
	if {$kill && [catch { exec kill -KILL [pid $fd] }] != 0} {
	    puts stderr "Unable to kill ftformat process\n"
	}
	if {[catch { close $fd }] != 0} {
	    puts stderr "Unable to close ftformat pipe\n"
	}
	DestroyWindow[SN UserInfoTop]
	set fd ""
    }
}


# Procedure: ENDUpdate
proc ENDUpdate { index value} {

}


# Procedure: FdInList
proc FdInList { listWidget {fileInFile ""}} {
# xf ignore me 5
##########
# Procedure: FdInList
# Description: fill a list with the contents of a filedescriptor
# Arguments: listWidget - the widget
#            {fileInFile} - a filedescriptor to read. The descriptor
#                           is closed after reading
# Returns: none
# Sideeffects: the list widget is filled
# Notes: there exists also a function called:
#          FileInList - to open and read a file automatically
##########

  # check file existance
  if {"$fileInFile" == ""} {
    puts stderr "no filedescriptor specified"
    return
  }

  set listValue [read $fileInFile]
  close $fileInFile
  foreach fileLine [split $listValue "\n"] {
    $listWidget insert end $fileLine
  }
}


# Procedure: FileInList
proc FileInList { listWidget {fileName ""}} {
# xf ignore me 5
##########
# Procedure: FileInList
# Description: fill a list with the contents of the file
# Arguments: listWidget - the widget
#            {fileName} - filename to read
# Returns: none
# Sideeffects: the list widget is filled
# Notes: there exists also a function called:
#          FdInList - to read from an already opened filedescriptor
##########

  # check file existance
  if {"$fileName" == ""} {
    puts stderr "no filename specified"
    return
  }
  if {[catch "open $fileName r" fileInFile]} {
    puts stderr "$fileInFile"
    return
  }

  set listValue [read $fileInFile]
  close $fileInFile
  foreach fileLine [split $listValue "\n"] {
    $listWidget insert end $fileLine
  }
}


# Procedure: InitGnuGettext
proc InitGnuGettext {} {
    global PACKAGE
    global VERSION
    global LOCALEDIR
    global env

    if {[info exists env(TCL_GETTEXT)] &&
	[info exists PACKAGE] && [info exists LOCALEDIR] &&
	![catch {load $env(TCL_GETTEXT) Gettext}]} {	
	bindtextdomain $PACKAGE $LOCALEDIR
	textdomain $PACKAGE
	puts [GT "done.\n"]\n
    }
}


# Procedure: LoadImages
proc LoadImages { {path ""}} {

    set oldpwd [pwd]

    if {$path != ""} {
	cd $path
    }

    image create photo ftapetoolsmallLOGO  -file {ftape-tool-small.gif}  -gamma {1.0}  -height {0}  -width {0}

    image create photo ftapetooltinyflopLOGO  -file {ftape-tool-tiny-flop.gif}  -gamma {1.0}  -height {0}  -width {0}

    image create photo ftapeLOGO  -file {linux-ftape-med.gif}  -gamma {1.0}  -height {0}  -width {0}

    image create photo ftapetoolLOGO  -file {ftape-tool.gif}  -gamma {1.0}  -height {0}  -width {0}

    image create photo ftapetooltinyLOGO  -file "ftape-tool-tiny.gif"  -gamma {1.0}  -height {0}  -width {0}

    cd $oldpwd
}


# Procedure: MapFtapeNames
proc MapFtapeNames { inv opt {Parms "FmtOpt"}} {
    upvar $Parms Opts

#    puts stdout "$opt\n"
    switch $opt {
	"format-code" {
	    if ($inv) {
		switch $Opts($opt) {
		    "2" { return "normal" }
		    "3" { return "1100ft" }
		    "4" { return "variable" }
		    "5" { return "425ft" }
		    "6" { return "huge" }
		}
	    } else {
		switch $Opts($opt) {
		    "normal" { return "2" }
		    "1100ft" { return "3" }
		    "variable" { return "4" }
		    "425ft" { return "5" }
		    "huge" { return "6" }
		}
	    }
	}
	"qic-standard" {
	    if ($inv) {
		switch $Opts($opt) {
		    "0x01" { return "QIC-40" }
		    "0x02" { return "QIC-80" }
		    "0x03" { return "QIC-3020" }
		    "0x04" { return "QIC-3010" }
		    "0x82" { return "QIC-80/WIDE" }
		    "0x83" { return "QIC-3020/WIDE" }
		    "0x84" { return "QIC-3010/WIDE" }
		}
	    } else {
		switch $Opts($opt) {
		    "QIC-40" { return "0x01" }
		    "QIC-80" { return "0x02" }
		    "QIC-3020" { return "0x03" }
		    "QIC-3010" { return "0x04" }
		    "QIC-80/WIDE" - "TR-1" { return "0x82" }
		    "QIC-3020/WIDE" - "TR-3" { return "0x83" }
		    "QIC-3010/WIDE" { return "0x84" }

		}
	    }
	}
    }
    return "$Opts($opt)"
}


# Procedure: OptionButtonGet
proc OptionButtonGet { widget} {

  if {"[winfo class $widget.value]" == "Label"} {
    return [lindex [$widget.value config -text] 4]
  } {
    if {"[winfo class $widget.value]" == "Entry"} {
      return [$widget.value get]
    }
  }
}


# Procedure: OptionButtonSet
proc OptionButtonSet { widget} {

  if {"[winfo class $widget.value]" == "Label"} {
      $widget.value config -text [lindex [$widget.menubutton2.m entryconfig [$widget.menubutton2.m index active] -label] 4]
      if {[$widget.value config -textvariable] != ""} {
	  upvar \#0 [lindex [$widget.value config -textvariable] 4] foo
	  set foo [lindex [$widget.menubutton2.m entryconfig [$widget.menubutton2.m index active] -label] 4]
      }
  } {
    if {"[winfo class $widget.value]" == "Entry"} {
      $widget.value delete 0 end
      $widget.value insert 0 [lindex [$widget.menubutton2.m entryconfig [$widget.menubutton2.m index active] -label] 4]
    }
  }
}


# Procedure: ReadOptions
proc ReadOptions { {sFileName ""}} {
    global Options

    if { $sFileName == ""} {
	set sFileName "[file dirname ~]/[file tail ~]/.ftape-toolrc"
    }

    if [catch {open $sFileName {RDONLY}} hRCFile] {
	return
    }

    while {[gets $hRCFile sLine] >= 0} {
	if [regexp {^([^=]+)=(.+)$} $sLine sIgnored sIndex sValue] {
	    # ensures that sIndex is one of the accepted values
	    switch $sIndex {
		"NoRewindDevice" -
		"RewindDevice" -
		"RawNoRewindDevice" -
		"RawRewindDevice" {
		    set Options($sIndex) $sValue
		}
	    }
	}
    }

    close $hRCFile
    return
}


# Procedure: SaveOptions
proc SaveOptions { {sFileName ""}} {
    global Options

    if { $sFileName == ""} {
	set sFileName "[file dirname ~]/[file tail ~]/.ftape-toolrc"
    }

    if [catch {open $sFileName {RDWR TRUNC CREAT}} hRCFile] {
	tk_dialog .error "ftape-tool Error" "Error Opening File:\n$hRCFile" error 0 "OK"
	return
    }

    puts $hRCFile "\#Created by the ftape-tool. DO NOT EDIT BY HAND"

    foreach sIndex [array names Options] {
	# ensures that the proper fields get written to the proper file
	switch $sIndex {
	    "NoRewindDevice" -
	    "RewindDevice" -
	    "RawNoRewindDevice" -
	    "RawRewindDevice" {
		puts $hRCFile "$sIndex=$Options($sIndex)"
	    }
	}
    }

    close $hRCFile
    return
}


# Procedure: UpdateTapeButtons
proc UpdateTapeButtons { Button action} {

    foreach but {
	Status
	Contents
	Rewind
	Eject
	Retension
	Reset
	Erase
	Load
	SetPart
	Format } {
#	puts "$but\n$"
	if {$action == "start"} {
	    if {$but == $Button} {
		[SN ${but}Button] configure -state normal -text {Cancel}
	    } else {
		[SN ${but}Button] configure -state disabled
	    }
	} else {
	    [SN ${but}Button] configure -state normal -text "$but"
	}
    }
    foreach i {0 1 2 3 4 5 6 7} {
	if {$action == "start"} {
	    [SN TapeOptMenu] entryconfigure $i -state disabled
	} else {
	    [SN TapeOptMenu] entryconfigure $i -state normal
	}
    }
}


# Procedure: UpdateTime
proc UpdateTime {} {
    global TimeString
    global starttime
    
    if {[catch {clock seconds} nowtime] == 0} {
	set elapsed [expr $nowtime - $starttime]
	set TimeString [format "%02d:%02d:%02d" [expr ($elapsed/3600)%24] [expr ($elapsed/60)%60] [expr $elapsed%60]]
	update
	after 1000 UpdateTime
    }
}


# Procedure: _
proc _ { string} {
    if {[catch {gettext $string} trans]} {
	return $string
    } else {
	return $trans
    }
}


# Procedure: fileselect
proc fileselect { {cmd "fileselect.default.cmd"} {purpose "Open file:"} {w ".fileSelectWindow"}} {
# xf ignore me 5
##########
# Procedure: fileselect
# Author: Mario Jorge Silva (msilva@cs.Berkeley.EDU)
# Description: show file selection box
# Arguments: cmd - the default command to execute
#            purpose - the purpose of the selection box
#            w - the toplevel widget path
# Returns: None
# Notes: names starting with "fileselect" are reserved by this
#        module no other names used. The procedure passed as
#        the first parameter get the file name as parameter. This
#        procedure is evaluated when the OK button is pressed.
##########

    if {"[info commands XFDestroy]" != ""} {
        catch {XFDestroy $w}
    } {
        catch {destroy $w}
    }

    toplevel $w
    grab $w
    wm title $w "Select File"


    # path independent names for the widgets
    global fileselect_entry fileselect_list  fileselect_ok fileselect_cancel fileselect_dirlabel

    set fileselect_entry $w.file.eframe.entry
    set fileselect_list $w.file.sframe.list
    set fileselect_scroll $w.file.sframe.scroll
    set fileselect_ok $w.bframe.okframe.ok
    set fileselect_cancel $w.bframe.cancel
    set fileselect_dirlabel $w.file.dirlabel

    # widgets
    frame $w.file -bd 10 
    frame $w.bframe -bd 10
    pack append $w  $w.file {left filly}  $w.bframe {left expand frame n}

    frame $w.file.eframe
    frame $w.file.sframe
    label $w.file.dirlabel -anchor e -width 24 -text [pwd] 

    pack append $w.file  $w.file.eframe {top frame w}  $w.file.sframe {top fillx}  $w.file.dirlabel {top frame w}


    label $w.file.eframe.label -anchor w -width 24 -text $purpose
    entry $w.file.eframe.entry -relief sunken 

    pack append $w.file.eframe  $w.file.eframe.label {top expand frame w}  $w.file.eframe.entry {top fillx frame w}


    scrollbar $w.file.sframe.yscroll -relief sunken  -command "$w.file.sframe.list yview"
    listbox $w.file.sframe.list -relief sunken  -yscroll "$w.file.sframe.yscroll set" 

    pack append $w.file.sframe  $w.file.sframe.yscroll {right filly}  $w.file.sframe.list {left fill} 

    # buttons
    frame $w.bframe.okframe -borderwidth 2 -relief sunken
 
    button $w.bframe.okframe.ok -text OK -relief raised -padx 10  -command "fileselect.ok.cmd $w $cmd"

    button $w.bframe.cancel -text cancel -relief raised -padx 10  -command "fileselect.cancel.cmd $w"
    pack append $w.bframe.okframe $w.bframe.okframe.ok {padx 10 pady 10}

    pack append $w.bframe $w.bframe.okframe {expand padx 20 pady 20}  $w.bframe.cancel {top}

    # Fill the listbox with a list of all the files in the directory (run
    # the "ls" command to get that information).
 
    foreach i [Ls -a [pwd]] {
        if {[string compare $i "."] != 0} {
            $fileselect_list insert end $i
        }
    }

    # Set up bindings for the browser.
    bind $fileselect_entry <Return> {eval $fileselect_ok invoke}
    bind $fileselect_entry <Control-c> {eval $fileselect_cancel invoke}

    bind $w <Control-c> {eval $fileselect_cancel invoke}
    bind $w <Return> {eval $fileselect_ok invoke}

    bind $fileselect_list <ButtonRelease-1> {
        # puts stderr "button 1"
        %W select clear 0 end
        %W select set [%W nearest %y]
	eval $fileselect_entry delete 0 end
	eval $fileselect_entry insert 0 [%W get [%W nearest %y]]
    }

    bind $fileselect_list <Button-1> {
        # puts stderr "button 1 release"
        %W select clear 0 end
        %W select set [%W nearest %y]
	eval $fileselect_entry delete 0 end
	eval $fileselect_entry insert 0 [%W get [%W nearest %y]]
    }

    bind $fileselect_list <Key> {
        %W select clear 0 end
        %W select set [%W nearest %y]
        eval $fileselect_entry delete 0 end
	eval $fileselect_entry insert 0 [%W get [%W nearest %y]]
    }

    bind $fileselect_list <Double-ButtonPress-1> {
        # puts stderr "double button 1"
	eval $fileselect_ok invoke
    }

    bind $fileselect_list <Return> {
        %W select clear 0 end
        %W select set [%W nearest %y]
	eval $fileselect_entry delete 0 end
	eval $fileselect_entry insert 0 [%W get [%W nearest %y]]
	eval $fileselect_ok invoke
    }

    # set kbd focus to entry widget

    focus $fileselect_entry
}


# Procedure: fileselect.cancel.cmd
proc fileselect.cancel.cmd { w} {
# xf ignore me 6
    # puts stderr "Cancel"
    if {"[info commands XFDestroy]" != ""} {
        catch {XFDestroy $w}
    } {
        catch {destroy $w}
    }
}


# Procedure: fileselect.default.cmd
proc fileselect.default.cmd { f} {
# xf ignore me 5
  puts stderr "selected file $f"
}


# Procedure: fileselect.ok.cmd
proc fileselect.ok.cmd { w cmd} {
# xf ignore me 6
    global fileselect_entry fileselect_dirlabel fileselect_list 
    set selected [$fileselect_entry get]

    if {[file isdirectory $selected] != 0} {
	cd $selected
	set dir [pwd]
	eval $fileselect_dirlabel configure -text $dir
	eval $fileselect_entry delete 0 end
	eval $fileselect_list delete 0 end
	foreach i [Ls -a $dir] {
	    if {[string compare $i "."] != 0} {
		eval $fileselect_list insert end $i
	    }
	}
	return
    }

    if {"[info commands XFDestroy]" != ""} {
        catch {XFDestroy $w}
    } {
        catch {destroy $w}
    }
    eval $cmd \"$selected\"
}


# Internal procedures


# Procedure: Alias
if {"[info procs Alias]" == ""} {
proc Alias { args} {
# xf ignore me 7
##########
# Procedure: Alias
# Description: establish an alias for a procedure
# Arguments: args - no argument means that a list of all aliases
#                   is returned. Otherwise the first parameter is
#                   the alias name, and the second parameter is
#                   the procedure that is aliased.
# Returns: nothing, the command that is bound to the alias or a
#          list of all aliases - command pairs. 
# Sideeffects: internalAliasList is updated, and the alias
#              proc is inserted
##########
  global internalAliasList

  if {[llength $args] == 0} {
    return $internalAliasList
  } {
    if {[llength $args] == 1} {
      set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
      if {$xfTmpIndex != -1} {
        return [lindex [lindex $internalAliasList $xfTmpIndex] 1]
      }
    } {
      if {[llength $args] == 2} {
        eval "proc [lindex $args 0] {args} {#xf ignore me 4
return \[eval \"[lindex $args 1] \$args\"\]}"
        set xfTmpIndex [lsearch $internalAliasList "[lindex $args 0] *"]
        if {$xfTmpIndex != -1} {
          set internalAliasList [lreplace $internalAliasList $xfTmpIndex $xfTmpIndex "[lindex $args 0] [lindex $args 1]"]
        } {
          lappend internalAliasList "[lindex $args 0] [lindex $args 1]"
        }
      } {
        error "Alias: wrong number or args: $args"
      }
    }
  }
}
}


# Procedure: Cat
if {"[info procs Cat]" == ""} {
proc Cat { filename} {
# xf ignore me 7
##########
# Procedure: Cat
# Description: emulate UNIX cat for one file
# Arguments: filename
# Returns: file contents
# Sideeffects: none
##########
global tcl_platform
if {$tcl_platform(platform) == "unix"} {exec cat $filename} {
   set fileid [open $filename "r"]
   set data [read $fileid]
   close $fileid
   return $data
}
}
}


# Procedure: Chmod
if {"[info procs Chmod]" == ""} {
proc Chmod { mode file} {
# xf ignore me 7
##########
# Procedure: Chmod
# Description: ignore UNIX chmod under DOS
# Arguments: file1 file2/directory
# Returns: nothing
# Sideeffects: none
##########
global tcl_platform
if {$tcl_platform(platform) == "unix"} {eval exec chmod $mode $file} {
   regsub -all {/} $file1 {\\\\} file1
   regsub -all {/} $file2 {\\\\} file2
   eval exec command.com /c copy /y $file1 $file2 >@stderr
}
}
}


# Procedure: Cp
if {"[info procs Cp]" == ""} {
proc Cp { file1 file2} {
# xf ignore me 7
##########
# Procedure: Cp
# Description: emulate UNIX cp with DOS COPY
# Arguments: file1 file2/directory
# Returns: nothing
# Sideeffects: none
##########
global tcl_platform
if {$tcl_platform(platform) == "unix"} {eval exec cp $file1 $file2} {
   regsub -all {/} $file1 {\\\\} file1
   regsub -all {/} $file2 {\\\\} file2
   eval exec command.com /c copy /y $file1 $file2 >@stderr
}
}
}


# Procedure: GetSelection
if {"[info procs GetSelection]" == ""} {
proc GetSelection {} {
# xf ignore me 7
##########
# Procedure: GetSelection
# Description: get current selection
# Arguments: none
# Returns: none
# Sideeffects: none
##########

  # the save way
  set xfSelection ""
  catch "selection get" xfSelection
  if {"$xfSelection" == "selection doesn't exist or form \"STRING\" not defined"} {
    return ""
  } {
    return $xfSelection
  }
}
}


# Procedure: Ls
if {"[info procs Ls]" == ""} {
proc Ls { args} {
# xf ignore me 7
##########
# Procedure: Ls
# Description: emulate UNIX ls
# Arguments: like UNIX (switches authorized -F -a [-a is ignored])
# Returns: directory list
# Sideeffects: none
##########
global tcl_platform
if {$tcl_platform(platform) == "unix"} {eval exec ls $args} {
   set last [lindex $args end]
   if {[lsearch $last -* ] >= 0 || $last == "" } {set path "*"} {set path $last/*}
   set lst [glob $path]
   set lst1 ""
   if {[lsearch -exact $args "-F"] >= 0} then {set car "/"} else {set car ""}
   foreach f $lst {
      if {[file isdirectory $f]}  {set f [file tail $f]$car} {set f [file tail $f]}
      lappend lst1 $f
   }
   return [lsort $lst1]
}
}
}


# Procedure: NoFunction
if {"[info procs NoFunction]" == ""} {
proc NoFunction { args} {
# xf ignore me 7
##########
# Procedure: NoFunction
# Description: do nothing (especially with scales and scrollbars)
# Arguments: args - a number of ignored parameters
# Returns: none
# Sideeffects: none
##########
}
}


# Procedure: Rm
if {"[info procs Rm]" == ""} {
proc Rm { filename} {
# xf ignore me 7
##########
# Procedure: Rm
# Description: emulate UNIX rm with DOS DEL
# Arguments: filename(s)
# Returns: nothing
# Sideeffects: none
##########
global tcl_platform
if {$tcl_platform(platform) == "unix"} {exec rm -f $filename} {
   regsub -all {/} $filename {\\\\} filename
   eval exec command.com /c del $filename >@stderr
}
}
}


# Procedure: SN
if {"[info procs SN]" == ""} {
proc SN { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SN
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  SymbolicName $xfName
}
}


# Procedure: SymbolicName
if {"[info procs SymbolicName]" == ""} {
proc SymbolicName { {xfName ""}} {
# xf ignore me 7
##########
# Procedure: SymbolicName
# Description: map a symbolic name to the widget path
# Arguments: xfName
# Returns: the symbolic name
# Sideeffects: none
##########

  global symbolicName

  if {"$xfName" != ""} {
    set xfArrayName ""
    append xfArrayName symbolicName ( $xfName )
    if {![catch "set \"$xfArrayName\"" xfValue]} {
      return $xfValue
    } {
      if {"[info commands XFProcError]" != ""} {
        XFProcError "Unknown symbolic name:\n$xfName"
      } {
        puts stderr "XF error: unknown symbolic name:\n$xfName"
      }
    }
  }
  return ""
}
}


# Procedure: Unalias
if {"[info procs Unalias]" == ""} {
proc Unalias { aliasName} {
# xf ignore me 7
##########
# Procedure: Unalias
# Description: remove an alias for a procedure
# Arguments: aliasName - the alias name to remove
# Returns: none
# Sideeffects: internalAliasList is updated, and the alias
#              proc is removed
##########
  global internalAliasList

  set xfIndex [lsearch $internalAliasList "$aliasName *"]
  if {$xfIndex != -1} {
    rename $aliasName ""
    set internalAliasList [lreplace $internalAliasList $xfIndex $xfIndex]
  }
}
}



# module load procedure
proc XFLocalIncludeModule {{moduleName ""}} {
  global env
  global xfLoadInfo
  global xfLoadPath
  global xfStatus
  global xfMisc

  foreach p [split $xfLoadPath $xfMisc(separator)] {
    if {[file exists "$p/$moduleName"]} {
      if {![file readable "$p/$moduleName"]} {
        puts stderr "Cannot read $p/$moduleName (permission denied)"
        continue
      }
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName..."
      }
      source "$p/$moduleName"
      return 1
    }
    # first see if we have a load command
    if {[info exists env(XF_VERSION_SHOW)]} {
      set xfCommand $env(XF_VERSION_SHOW)
      regsub -all {\$xfFileName} $xfCommand $p/$moduleName xfCommand
      if {$xfLoadInfo} {
        puts stdout "Loading $p/$moduleName...($xfCommand)"
      }
      if {[catch "exec $xfCommand" contents]} {
        continue
      } {
        eval $contents
        return 1
      }
    }
  }
  puts stderr "Cannot load module $moduleName -- check your xf load path"
  puts stderr "Specify a xf load path with the environment variable:"
  puts stderr "  XF_LOAD_PATH (e.g \"export XF_LOAD_PATH=.\")"
  catch "destroy ."
  catch "exit 0"
}

# application parsing procedure
proc XFLocalParseAppDefs {xfAppDefFile} {
  global xfAppDefaults tcl_platform

  # basically from: Michael Moore
  if {[file exists $xfAppDefFile] &&
      [file readable $xfAppDefFile] &&
      "[file type $xfAppDefFile]" == "link"} {
    catch "file type $xfAppDefFile" xfType
    while {"$xfType" == "link"} {
      if {[catch "file readlink $xfAppDefFile" xfAppDefFile]} {
        return
      }
      catch "file type $xfAppDefFile" xfType
    }
  }
  if {!("$xfAppDefFile" != "" &&
        [file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        "[file type $xfAppDefFile]" == "file")} {
    return
  }
  if {![catch "open $xfAppDefFile r" xfResult]} {
    set xfAppFileContents [read $xfResult]
    close $xfResult
    foreach line [split $xfAppFileContents "\n"] {
      # backup indicates how far to backup.  It applies to the
      # situation where a resource name ends in . and when it
      # ends in *.  In the second case you want to keep the *
      # in the widget name for pattern matching, but you want
      # to get rid of the . if it is the end of the name. 
      set backup -2  
      set line [string trim $line]
      if {[string index $line 0] == "#" || "$line" == ""} {
        # skip comments and empty lines
        continue
      }
      if {![string compare "windows" $tcl_platform(platform)]} {
        set list [split $line ";"]
      } {
        set list [split $line ":"]
      }
      set resource [string trim [lindex $list 0]]
      set i [string last "." $resource]
      set j [string last "*" $resource]
      if {$j > $i} { 
        set i $j
        set backup -1
      }
      incr i
      set name [string range $resource $i end]
      incr i $backup
      set widname [string range $resource 0 $i]
      set value [string trim [lindex $list 1]]
      if {"$widname" != "" && "$widname" != "*"} {
        # insert the widget and resourcename to the application
        # defaults list.
        if {![info exists xfAppDefaults]} {
          set xfAppDefaults ""
        }
        lappend xfAppDefaults [list $widname [string tolower $name] $value]
      }
    }
  }
}

# application loading procedure
proc XFLocalLoadAppDefs {{xfClasses ""} {xfPriority "startupFile"} {xfAppDefFile ""}} {
  global env tcl_platform

  if {![string compare "windows" $tcl_platform(platform)]} {
    set separator ";"
  } {
    set separator ":"
  }
  if {"$xfAppDefFile" == ""} {
    set xfFileList ""
    if {[info exists env(XUSERFILESEARCHPATH)]} {
      eval lappend xfFileList [split $env(XUSERFILESEARCHPATH) $separator]
    }
    if {[info exists env(XAPPLRESDIR)]} {
      eval lappend xfFileList [split $env(XAPPLRESDIR) $separator]
    }
    if {[info exists env(XFILESEARCHPATH)]} {
      eval lappend xfFileList [split $env(XFILESEARCHPATH) $separator]
    }
    append xfFileList " /usr/lib/X11/app-defaults"
    append xfFileList " /usr/X11/lib/X11/app-defaults"

    foreach xfCounter1 $xfClasses {
      foreach xfCounter2 $xfFileList {
        set xfPathName $xfCounter2
        if {[regsub -all "%N" "$xfPathName" "$xfCounter1" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%T" "$xfPathName" "app-defaults" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%S" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[regsub -all "%C" "$xfPathName" "" xfResult]} {
          set xfPathName $xfResult
        }
        if {[file exists $xfPathName] &&
            [file readable $xfPathName] &&
            ("[file type $xfPathName]" == "file" ||
             "[file type $xfPathName]" == "link")} {
          catch "option readfile $xfPathName $xfPriority"
          if {"[info commands XFParseAppDefs]" != ""} {
            XFParseAppDefs $xfPathName
          } {
            if {"[info commands XFLocalParseAppDefs]" != ""} {
              XFLocalParseAppDefs $xfPathName
            }
          }
        } {
          if {[file exists $xfCounter2/$xfCounter1] &&
              [file readable $xfCounter2/$xfCounter1] &&
              ("[file type $xfCounter2/$xfCounter1]" == "file" ||
               "[file type $xfCounter2/$xfCounter1]" == "link")} {
            catch "option readfile $xfCounter2/$xfCounter1 $xfPriority"
            if {"[info commands XFParseAppDefs]" != ""} {
              XFParseAppDefs $xfCounter2/$xfCounter1
            } {
              if {"[info commands XFLocalParseAppDefs]" != ""} {
                XFLocalParseAppDefs $xfCounter2/$xfCounter1
              }
            }
          }
        }
      }
    }
  } {
    # load a specific application defaults file
    if {[file exists $xfAppDefFile] &&
        [file readable $xfAppDefFile] &&
        ("[file type $xfAppDefFile]" == "file" ||
         "[file type $xfAppDefFile]" == "link")} {
      catch "option readfile $xfAppDefFile $xfPriority"
      if {"[info commands XFParseAppDefs]" != ""} {
        XFParseAppDefs $xfAppDefFile
      } {
        if {"[info commands XFLocalParseAppDefs]" != ""} {
          XFLocalParseAppDefs $xfAppDefFile
        }
      }
    }
  }
}

# application setting procedure
proc XFLocalSetAppDefs {{xfWidgetPath "."}} {
  global xfAppDefaults

  if {![info exists xfAppDefaults]} {
    return
  }
  foreach xfCounter $xfAppDefaults {
    if {"$xfCounter" == ""} {
      break
    }
    set widname [lindex $xfCounter 0]
    if {[string match $widname ${xfWidgetPath}] ||
        [string match "${xfWidgetPath}*" $widname]} {
      set name [string tolower [lindex $xfCounter 1]]
      set value [lindex $xfCounter 2]
      # Now lets see how many tcl commands match the name
      # pattern specified.
      set widlist [info command $widname]
      if {"$widlist" != ""} {
        foreach widget $widlist {
          # make sure this command is a widget.
          if {![catch "winfo id $widget"] &&
              [string match "${xfWidgetPath}*" $widget]} {
            catch "$widget configure -$name $value" 
          }
        }
      }
    }
  }
}

# initialize bindings for all widgets
proc XFInitAllBindings {} {
  # bindings
  bind all <Alt-Key> {
    tkTraverseToMenu %W %A
}
  bind all <Key-F10> {
    tkFirstMenu %W
}
  bind all <Key-Tab> {focus [tk_focusNext %W]}
  bind all <Shift-Key-Tab> {focus [tk_focusPrev %W]}
}


# startup source
proc StartupSrc {args} {
    LoadImages [FtapeToolDir]
    source [FtapeToolDir]/version.tcl
}

if {"[info procs XFShowHelp]" != ""} {
  XFLocalIncludeModule about.tcl
}
if {"[info procs XFShowHelp]" != ""} {
  XFLocalIncludeModule big-logo.tcl
}
if {"[info procs XFShowHelp]" != ""} {
  XFLocalIncludeModule ftape-command.tcl
}
if {"[info procs XFShowHelp]" != ""} {
  XFLocalIncludeModule ftape-contents.tcl
}
if {"[info procs XFShowHelp]" != ""} {
  XFLocalIncludeModule ftape-format.tcl
}


# prepare auto loading
global auto_path
global tk_library
global xfLoadPath
foreach xfElement [eval list [split $xfLoadPath :] $auto_path] {
  if {[file exists $xfElement/tclIndex]} {
    lappend auto_path $xfElement
  }
}

# startup source
StartupSrc

# initialize global variables
proc InitGlobals {} {
  global {CmdPipeFD}
  set {CmdPipeFD} {}
  global {ContentsWidgetsStatus}
  set {ContentsWidgetsStatus} {0}
  global {DATEVar}
  set {DATEVar} {00:00:00 01/01/70}
  global {DESCRIPTIONVar}
  set {DESCRIPTIONVar} {zftape volume 000}
  global {ENDVar}
  set {ENDVar} {692}
  global {FmtOpt}
  set {FmtOpt(discardheader)} {0}
  set {FmtOpt(fixed)} {QIC-80/425ft}
  set {FmtOpt(fixed-formats)} {QIC-80/307ft}
  set {FmtOpt(floppy-head-max)} {6}
  set {FmtOpt(floppy-track-max)} {149}
  set {FmtOpt(format-code)} {normal}
  set {FmtOpt(gap3)} {233}
  set {FmtOpt(mode)} {probe}
  set {FmtOpt(noref)} {0}
  set {FmtOpt(omiterase)} {0}
  set {FmtOpt(qic-standard)} {QIC-3020/WIDE}
  set {FmtOpt(segments-per-track)} {150}
  set {FmtOpt(tracks-per-tape)} {28}
  set {FmtOpt(verifyonly)} {0}
  global {FmtOptState}
  set {FmtOptState(floppy-track-max)} {0}
  set {FmtOptState(format-code)} {0}
  set {FmtOptState(gap3)} {0}
  set {FmtOptState(qic-standard)} {0}
  global {FmtOptStatus}
  set {FmtOptStatus(fixed-formats)} {0}
  set {FmtOptStatus(floppy-head-max)} {0}
  set {FmtOptStatus(floppy-track-max)} {0}
  set {FmtOptStatus(format-code)} {0}
  set {FmtOptStatus(gap3)} {0}
  set {FmtOptStatus(qic-standard)} {0}
  set {FmtOptStatus(segments-per-track)} {0}
  set {FmtOptStatus(tracks-per-tape)} {0}
  global {FmtOpts}
  set {FmtOpts(format-code)} {2}
  global {FormatStatusLabel}
  set {FormatStatusLabel} {Format Status}
  global {Options}
  set {Options(NoRewindDevice)} {/dev/nqft0}
  set {Options(RawNoRewindDevice)} {/dev/nrawft0}
  set {Options(RawRewindDevice)} {/dev/rawft0}
  set {Options(RewindDevice)} {/dev/qft0}
  global {SIGNATUREVar}
  set {SIGNATUREVar} {VTBL}
  global {STARTVar}
  set {STARTVar} {3}
  global {TimeString}
  set {TimeString} {00:00:00}
  global {UserInfoString}
  set {UserInfoString} {Waiting for the tape drive to finish. Please have a little patience.}
  global {PartitionNumber}
  set {PartitionNumber} {1}
  global {VOLNOVar}
  set {VOLNOVar} {0}
  global {VolumeCount}
  set {VolumeCount} {0}
  global {VolumeDate}
  set {VolumeDate} {Tomorrow}
  global {VolumeLabel}
  set {VolumeLabel} {Funny V..olume Entry   }
  global {VolumeNumber}
  set {VolumeNumber} {0}
  global {VolumeSignature}
  set {VolumeSignature} {VTBL}
  global {Volumes}
  set {Volumes(-1,END)} {2}
  set {Volumes(-1,START)} {-1}
  set {Volumes(0,DATE)} {0}
  set {Volumes(0,DESCRIPTION)} {0}
  set {Volumes(0,END)} {0}
  set {Volumes(0,SIGNATURE)} {0}
  set {Volumes(0,START)} {0}
  set {Volumes(0,VOLNO)} {0}
  global {alertBox}
  set {alertBox(activeBackground)} {}
  set {alertBox(activeForeground)} {}
  set {alertBox(after)} {0}
  set {alertBox(anchor)} {nw}
  set {alertBox(background)} {}
  set {alertBox(button)} {0}
  set {alertBox(font)} {}
  set {alertBox(foreground)} {}
  set {alertBox(justify)} {center}
  set {alertBox(toplevelName)} {.alertBox}
  global {checkbutton0}
  set {checkbutton0} {0}
  global {checkbutton1}
  set {checkbutton1} {0}
  global {checkbutton2}
  set {checkbutton2} {0}
  global {checkbutton24}
  set {checkbutton24} {0}
  global {checkbutton25}
  set {checkbutton25} {0}
  global {checkbutton3}
  set {checkbutton3} {0}
  global {checkbutton32}
  set {checkbutton32} {0}
  global {checkbutton33}
  set {checkbutton33} {0}
  global {checkbutton34}
  set {checkbutton34} {0}
  global {checkbutton35}
  set {checkbutton35} {0}
  global {checkbutton37}
  set {checkbutton37} {0}
  global {checkbutton4}
  set {checkbutton4} {0}
  global {checkbutton5}
  set {checkbutton5} {0}
  global {checkbutton6}
  set {checkbutton6} {0}
  global {cmdstatus}
  set {cmdstatus} {ready}
  global {fileselect_cancel}
  set {fileselect_cancel} {.fileSelectWindow.bframe.cancel}
  global {fileselect_dirlabel}
  set {fileselect_dirlabel} {.fileSelectWindow.file.dirlabel}
  global {fileselect_entry}
  set {fileselect_entry} {.fileSelectWindow.file.eframe.entry}
  global {fileselect_list}
  set {fileselect_list} {.fileSelectWindow.file.sframe.list}
  global {fileselect_ok}
  set {fileselect_ok} {.fileSelectWindow.bframe.okframe.ok}
  global {fixedformats}
  set {fixedformats} {0}
  global {foo}
  set {foo} {16}
  global {formatcmd}
  set {formatcmd} {ftformat -f /dev/nrawft1 --mode=probe}
  global {maxfloppyhead}
  set {maxfloppyhead} {0}
  global {newrawdev}
  set {newrawdev} {/dev/nrawft0}
  global {newrrawdev}
  set {newrrawdev} {/dev/rawft2}
  global {newrtapedev}
  set {newrtapedev} {/dev/qft2}
  global {newtapedev}
  set {newtapedev} {/dev/nqft0}
  global {numvols}
  set {numvols} {23}
  global {omiterase}
  set {omiterase} {0}
  global {ouputframe}
  set {ouputframe} {.frame6}
  global {outputframe}
  set {outputframe} {.frame2}
  global {squeeze}
  set {squeeze(.squeezer.checkbutton8)} {0}
  global {starttime}
  set {starttime} {900896613}

  # please don't modify the following
  # variables. They are needed by xf.
  global {autoLoadList}
  set {autoLoadList(about.tcl)} {1}
  set {autoLoadList(big-logo.tcl)} {1}
  set {autoLoadList(ftape-command.tcl)} {1}
  set {autoLoadList(ftape-contents.tcl)} {1}
  set {autoLoadList(ftape-format.tcl)} {1}
  set {autoLoadList(ftape-tool.tcl)} {0}
  global {internalAliasList}
  set {internalAliasList} {}
  global {moduleList}
  set {moduleList(about.tcl)} { .top0 .top4 FtapeToolVersion}
  set {moduleList(big-logo.tcl)} { VFrame.frame2}
  set {moduleList(ftape-command.tcl)} { VFrame.frame5 TapeCmd ListCmdHandler CmdInList}
  set {moduleList(ftape-contents.tcl)} { VFrame.frame8 AddVolume AcceptVolume CloseContentsFrame ContentsButtonsState ContentsWidgetsUpdate ContentsSelection ContentsCmdHandler DeleteVolume MakeContentsFrame RunContentsCmd SetContentsView SetContentsWidgetsStatus TapeContents UpdateVolumeLists VolnoCallback VolumeUpdate WriteContents}
  set {moduleList(ftape-format.tcl)} { VFrame.frame6 .top8 UpdateFmtOptWidgets UpdateEraseTime UpdateProgress RunFormatCmd ParseFormatParms MakeFormatFrame FormatCmdHandler ComposeFormatCmd StopFormatCmd}
  set {moduleList(ftape-tool.tcl)} {}
  global {preloadList}
  set {preloadList(xfInternal)} {}
  global {symbolicName}
  set {symbolicName(AcceptVolumeButton)} {.frame8.frame6.frame1.frame5.frame0.button1}
  set {symbolicName(AddVolumeButton)} {.frame8.frame6.frame1.frame5.frame1.button0}
  set {symbolicName(COPYING)} {.top4}
  set {symbolicName(ContentsButton)} {.frame1.button5}
  set {symbolicName(ContentsCloseButton)} {.frame8.frame0.button1}
  set {symbolicName(ContentsEditFrame)} {.frame8.frame6.frame1.frame14}
  set {symbolicName(ContentsErrorList)} {.frame8.squeezer.frame4.listbox5}
  set {symbolicName(ContentsReadButton)} {.frame8.frame0.button3}
  set {symbolicName(ContentsWriteButton)} {.frame8.frame0.button2}
  set {symbolicName(DATEEntry)} {.frame8.frame6.frame1.frame14.frame0.value}
  set {symbolicName(DATEList)} {.frame8.frame.listbox4}
  set {symbolicName(DATEMenu)} {.frame8.frame6.frame1.frame14.frame0.menubutton2}
  set {symbolicName(DATEScrollbar)} {.frame8.frame6.frame1.frame14.frame0.scrollbar8}
  set {symbolicName(DESCRIPTIONEntry)} {.frame8.frame6.frame1.frame14.frame9.entry40}
  set {symbolicName(DESCRIPTIONFrame)} {.frame8.frame6.frame1.frame14.frame9}
  set {symbolicName(DESCRIPTIONList)} {.frame8.frame.listbox3}
  set {symbolicName(DESCRIPTIONScrollbar)} {.frame8.frame6.frame1.frame14.frame9.scrollbar11}
  set {symbolicName(DateFrame)} {.frame8.frame6.frame1.frame14.frame0}
  set {symbolicName(DeleteVolumeButton)} {.frame8.frame6.frame1.frame5.frame1.button3}
  set {symbolicName(ENDList)} {.frame8.frame.listbox6}
  set {symbolicName(ENDScale)} {.frame8.frame6.frame1.frame14.scale18}
  set {symbolicName(EjectButton)} {.frame1.button9}
  set {symbolicName(EraseBar)} {.frame6.frame41.frame1}
  set {symbolicName(EraseButton)} {.frame1.button4}
  set {symbolicName(FormatBar)} {.frame6.frame41.frame2}
  set {symbolicName(FormatButton)} {.frame1.button6}
  set {symbolicName(FormatErrorOutput)} {.frame6.squeezer.frame4.listbox5}
  set {symbolicName(FormatStatusLabel)} {.frame6.frame41.label42}
  set {symbolicName(QuitButton)} {.frame1.button7}
  set {symbolicName(QuitDialog)} {.top1}
  set {symbolicName(ResetButton)} {.frame1.button1}
  set {symbolicName(RetensionButton)} {.frame1.button2}
  set {symbolicName(RewindButton)} {.frame1.button0}
  set {symbolicName(LoadButton)} {.frame1.button8}
  set {symbolicName(SetPartButton)} {.frame1.button10}
  set {symbolicName(SIGNATUREEntry)} {.frame8.frame6.frame1.frame14.frame44.value}
  set {symbolicName(SIGNATUREList)} {.frame8.frame.listbox2}
  set {symbolicName(SIGNATUREMenu)} {.frame8.frame6.frame1.frame14.frame44.menubutton2}
  set {symbolicName(STARTList)} {.frame8.frame.listbox5}
  set {symbolicName(STARTScale)} {.frame8.frame6.frame1.frame14.scale17}
  set {symbolicName(SetPartDialog)} {.top5}
  set {symbolicName(SetPartScale)} {.top5.frame7.scale6}
  set {symbolicName(SignatureFrame)} {.frame8.frame6.frame1.frame14.frame44}
  set {symbolicName(StartFormatButton)} {.frame6.frame15.frame9.button10}
  set {symbolicName(StatusButton)} {.frame1.button3}
  set {symbolicName(TapeContentsFrame)} {.frame8}
  set {symbolicName(TapeOptMenu)} {.frame0.menubutton13.m}
  set {symbolicName(TimeMessage)} {.frame6.squeezer.frame7.message8}
  set {symbolicName(UndoVolumeButton)} {.frame8.frame6.frame1.frame5.frame0.button2}
  set {symbolicName(UserInfoTop)} {.top2}
  set {symbolicName(VOLNOList)} {.frame8.frame.listbox1}
  set {symbolicName(VOLNOScale)} {.frame8.frame6.frame1.frame14.scale19}
  set {symbolicName(VerifyBar)} {.frame6.frame41.frame3}
  set {symbolicName(aboutmenu)} {.frame0.menubutton0.m}
  set {symbolicName(cmdframe)} {.frame5}
  set {symbolicName(file)} {.frame0.menubutton5}
  set {symbolicName(fixed-formatsentry)} {.top8.frame11.frame21.value}
  set {symbolicName(fixed-formatsmenu)} {.top8.frame11.frame21.menubutton2}
  set {symbolicName(floppy-head-maxentry)} {.top8.frame11.frame17.value}
  set {symbolicName(floppy-track-maxentry)} {.top8.frame11.frame18.value}
  set {symbolicName(format-codeentry)} {.top8.frame11.frame15.value}
  set {symbolicName(format-codemenu)} {.top8.frame11.frame15.menubutton2}
  set {symbolicName(formatframe)} {.frame6}
  set {symbolicName(formattop)} {.top8}
  set {symbolicName(gap3entry)} {.top8.frame11.frame16.value}
  set {symbolicName(gap3menu)} {.top8.frame11.frame16.menubutton2}
  set {symbolicName(logoframe)} {.frame2}
  set {symbolicName(outputframe)} {.frame5}
  set {symbolicName(qic-standardentry)} {.top8.frame11.frame0.value}
  set {symbolicName(qic-standardmenu)} {.top8.frame11.frame0.menubutton2}
  set {symbolicName(quit)} {.frame0.menubutton5.m}
  set {symbolicName(root)} {.}
  set {symbolicName(segments-per-trackentry)} {.top8.frame11.frame19.value}
  set {symbolicName(tapeops)} {.frame0.menubutton13}
  set {symbolicName(tracks-per-tapeentry)} {.top8.frame11.frame20.value}
  global {xfWmSetPosition}
  set {xfWmSetPosition} {}
  global {xfWmSetSize}
  set {xfWmSetSize} {.top0 .top1}
  global {xfAppDefToplevels}
  set {xfAppDefToplevels} {}
}

# initialize global variables
InitGlobals

# display/remove toplevel windows.
ShowWindow.

global xfShowWindow.top0
set xfShowWindow.top0 0

global xfShowWindow.top1
set xfShowWindow.top1 0

global xfShowWindow.top2
set xfShowWindow.top2 0

global xfShowWindow.top3
set xfShowWindow.top3 0

global xfShowWindow.top4
set xfShowWindow.top4 0

global xfShowWindow.top8
set xfShowWindow.top8 0

# load default bindings.
if {[info exists env(XF_BIND_FILE)] &&
    "[info procs XFShowHelp]" == ""} {
  source $env(XF_BIND_FILE)
}

# initialize bindings for all widgets.
XFInitAllBindings


# parse and apply application defaults.
XFLocalLoadAppDefs Ftape-tool
XFLocalSetAppDefs

# eof
#

