#    Copyright 2014 Mirantis, Inc.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

module Astute
  class PostPatchingHa < PostDeployAction

    def process(deployment_info, context)
      return if deployment_info.first['openstack_version_prev'].nil? ||
                deployment_info.first['deployment_mode'] !~ /ha/i

      controller_nodes = deployment_info.select{ |n| n['role'] =~ /controller/i }.map{ |n| n['uid'] }
      return if controller_nodes.empty?

      Astute.logger.info "Starting unmigration of pacemaker services from " \
        "nodes\n#{controller_nodes.pretty_inspect}"

      Astute::Pacemaker.commands(action='start', deployment_info).each do |pcmk_unban_cmd|
        response = run_shell_command(context, controller_nodes, pcmk_unban_cmd)

        if response[:data][:exit_code] != 0
          Astute.logger.warn "#{context.task_id}: Failed to unban service, "\
                             "check the debugging output for details"
        end
      end

      Astute.logger.info "#{context.task_id}: Finished post-patching-ha hook"
    end #process
  end #class
end
