/*
 *
 * Copyright (c) 2003 The Regents of the University of California.  All 
 * rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Neither the name of the University nor the names of its
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
 

/*

  rwtest.c

  tests open, read, write, close calls

 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>

#include "fusd.h"

#define EOK 0

char *teststrs[5] = 
{"hello",
 "world",
 "this is",
 "fusd",
 NULL};
int counter = 0;


int _open(struct fusd_file_info *file)
{
  return EOK;
}

int _close(struct fusd_file_info *file)
{
  return EOK;
}

ssize_t _read(struct fusd_file_info *file, char *buffer, size_t length,
	      loff_t *offset)
{
  if (teststrs[counter]) {
    int len = strlen(teststrs[counter])+1;
    if (len > length) len=length;
    memmove(buffer, teststrs[counter], len);
    counter++;
    return len;
  }
  return 0;
}

ssize_t _write(struct fusd_file_info *file, const char *buffer, size_t length,
	       loff_t *offset)
{
  if (length > 0) {
    printf("rwtest server: write called with '%s', %d bytes\n", buffer, length);
  }
  else 
    printf("rwtest server: zero-length write: %d\n", length);

  return length;
}



int main(int argc, char *argv[])
{
  int f;

  if (argc != 4) {
    fprintf(stderr, "usage: %s <device-to-create> <class> <devicename>\n", argv[0]);
    exit(0);
  }

  /* fork into client and server */
  f = fork();
  if (f<0) {
    perror("Fork failed");
    exit(1);
  }

  /* server */
  if (f) {
    // init function table
    fusd_file_operations_t
      fops = {_open, 
	      _close,
	      _read,
	      _write,
	      NULL,
	      NULL,
	      NULL};
    
    if (fusd_register(argv[1], argv[2], argv[3], 0666, 0, &fops) < 0) {
      perror("Register failed");
    } else {
      fusd_run();
    }
  }

  /* client */
  else {
    int fd;
    char devname[20];
    int error = 0;
    int j;
    char buffer[50];
    int stat2;
    int count;

    sleep(1);

    sprintf(devname, "/dev/%s", argv[1]);

    /* open */
    fd = open(devname, O_RDWR);
    
    fprintf(stderr, "rwtest client: Open call return fd = %d, should be positive.\n", fd);
    if (fd < 0) error = 1;
    
    stat2 = 1;
    count = 0;
    while (stat2) {
      int status;
      char *p;

      status = read(fd, buffer, 50);
      printf("rwtest client: read %d bytes, got '%s'\n", status, buffer);

      // check
      if (strcmp(buffer, teststrs[count])) error = 1;
      count++;

      for (p=buffer; *p; p++) *p = toupper(*p);
      printf("iclient: about to write %s\n",buffer);
     
      stat2 = write(fd, buffer, status);
      printf("rwtest client: write %d bytes\n", stat2);
    }

    /* close */
    j = close(fd);
    fprintf(stderr, "Close call returned %d, should be 0.\n", j);
    if (j != 0) error = 1;

    if (error)
      exit(1);
  }

  exit(0);
}


