from random import randint

class Operation:
    def __init__(self, offset, size):
        self.offset = offset
        self.size = size

    def overlaps(self, operation):
        """
        True if `operation` overlaps the operation.
        """
        low = self.offset
        high = low + self.size - 1
        if low <= operation.offset <= high:
            return True
        if low <= (operation.offset+operation.size-1) <= high:
            return True
        return False

    def __call__(self, data):
        raise NotImplementedError()

    def __str__(self):
        raise NotImplementedError()

class InverseBit(Operation):
    def __init__(self, datalen):
        offset = randint(0, datalen*8 - 1)
        Operation.__init__(self, offset, 1)

    def __call__(self, data):
        mask = 1 << (self.offset & 7)
        offset = self.offset >> 3
        if data[offset] & mask:
            data[offset] &= (~mask & 0xFF)
        else:
            data[offset] |= mask

    def __str__(self):
        return "InverseBit(%s.%s)" % (self.offset // 8, self.offset % 8)

class ReplaceByte(Operation):
    def __init__(self, datalen):
        offset = randint(0, datalen-1)
        byte = randint(0, 255)
        Operation.__init__(self, offset*8, 8)
        self.byte = byte

    def __call__(self, data):
        data[self.offset // 8] = self.byte

    def __str__(self):
        return "ReplaceByte(%s, 0x%02x)" % (self.offset//8, self.byte)

OPERATIONS = (InverseBit, ReplaceByte)

