
#include "config.h"

#include "fwbuilder/AddressRange.hh"

#include "AddressRangeDialog.hh"
#include "IPAddressWidget.hh"
#include "MessageDialog.hh"

#include "helpers.hh"


using namespace libfwbuilder;


void AddressRangeDialog::on_changed()
{   
    data_changed_flag(true);
}


AddressRangeDialog::AddressRangeDialog(libfwbuilder::AddressRange *obj)
{
    object=obj;

    obj_start_addr=manage(new IPAddressWidget());
    obj_start_addr->showAllZeroes(true);
    table68->attach(*obj_start_addr, 1, 2, 1, 2, GTK_FILL, 0, 0, 0);
    obj_start_addr->changed.connect(SigC::slot(this,&AddressRangeDialog::on_changed));

    obj_end_addr=manage(new IPAddressWidget());
    obj_end_addr->showAllZeroes(true);
    table68->attach(*obj_end_addr, 1, 2, 2, 3, GTK_FILL, 0, 0, 0);
    obj_end_addr->changed.connect(SigC::slot(this,&AddressRangeDialog::on_changed));
}

AddressRange *AddressRangeDialog::getAddressRange()
{
    return static_cast<AddressRange*>(object); 
}

void AddressRangeDialog::wrk2dlg()
{
    obj_name->set_text(object->getName());

    obj_start_addr->setAddress(getAddressRange()->getRangeStart());
    obj_end_addr->setAddress(getAddressRange()->getRangeEnd());
    
    comment->set_point(0);
    comment->forward_delete( comment->get_length() );
    comment->insert(object->getComment());

    obj_name->grab_focus();
}

bool AddressRangeDialog::dlg2wrk()
{
    try
    {
        checkIPaddress( obj_start_addr->getAsString() );
        checkIPaddress( obj_end_addr->getAsString() );
    } catch(FWException &ex)
    {
        MessageDialog::Error(ex.toString(),find_my_toplevel_window(this));
        return true;
    }

    object->setName( obj_name->get_text() );
    object->setComment( comment->get_chars(0,comment->get_length()) );
    
    try
    {
        getAddressRange()->setRangeStart( obj_start_addr->getAsIPAddress() );
        getAddressRange()->setRangeEnd( obj_end_addr->getAsIPAddress() );
    } catch(const FWException &ex)
    {
        return false;
    }

    return true;
}
