/* 

                          Firewall Builder

                 Copyright (C) 2002 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: CertDruidP30Dialog.hh,v 1.5 2002/08/29 00:34:47 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _CERTDRUIDP30DIALOG_HH
#  include "CertDruidP30Dialog_glade.hh"
#  define _CERTDRUIDP30DIALOG_HH
#include "glademm_support.hh"

#include <fwbuilder/crypto.hh>

#include <time.h>
#include <vector>

class CertDruidP30Dialog : public CertDruidP30Dialog_glade
{   
        
    friend class CertDruidP30Dialog_glade;

    time_t convertToTime(const string &date,const string& time);

    public:

    CertDruidP30Dialog();

    void getEntries(std::vector<libfwbuilder::X509_entry> &v);
    time_t getNotValidBefore();
    time_t getNotValidAfter();
    string getDescription();

    private:

    void addEntry(std::vector<libfwbuilder::X509_entry> &v, int nid, const std::string &str);

};
#endif
