/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Zaliva lord@crocodile.org

  $Id: DialogFactory.cc,v 1.20 2003/01/26 05:33:22 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "DialogFactory.hh"

#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/FWObject.hh"
#include "fwbuilder/CustomService.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/Group.hh"
#include "fwbuilder/ObjectGroup.hh"
#include "fwbuilder/ServiceGroup.hh"
#include "fwbuilder/IntervalGroup.hh"
#include "fwbuilder/Host.hh"
#include "fwbuilder/ICMPService.hh"
#include "fwbuilder/InterfacePolicy.hh"
#include "fwbuilder/Interval.hh"
#include "fwbuilder/IPService.hh"
#include "fwbuilder/NAT.hh"
#include "fwbuilder/Network.hh"
#include "fwbuilder/AddressRange.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/RuleSet.hh"
#include "fwbuilder/TCPService.hh"
#include "fwbuilder/UDPService.hh"
#include "fwbuilder/IPv4.hh"
#include "fwbuilder/physAddress.hh"
#include "fwbuilder/Resources.hh"

#include "CustomServiceDialog.hh"
#include "FirewallDialog.hh"
#include "GroupDialog.hh"
#include "HostDialog.hh"
#include "ICMPServiceDialog.hh"
#include "PolicyDialog.hh"
#include "InterfacePolicyDialog.hh"
#include "TimeDialog.hh"
#include "IPServiceDialog.hh"
#include "NATDialog.hh"
#include "NetworkDialog.hh"
#include "AddressRangeDialog.hh"
#include "TCPServiceDialog.hh"
#include "UDPServiceDialog.hh"
#include "FWObjectDialog.hh"
#include "InterfaceDialog.hh"
#include "IPv4Dialog.hh"
#include "physAddressDialog.hh"

#include "MessageDialog.hh"
#include "main_window.hh"

#include "TargetDialog_unknown.hh"

#include <dlfcn.h>

#include "iostream"

using namespace libfwbuilder;

extern "C" {
    typedef DialogPlugin* (*create_dialog_fun)(FWObject *o);
}


class DefaultDialogFactory: public DialogFactory
{
    public:

    bool haveDialog(FWObject *o)
    {
        return (CustomService::isA(o) ||
                Firewall::isA(o) ||
                Group::isA(o) || 
                ObjectGroup::isA(o) || 
                ServiceGroup::isA(o) || 
                IntervalGroup::isA(o) ||
                FWObjectDatabase::isA(o) ||
                Host::isA(o) ||
                Interface::isA(o) ||
                IPv4::isA(o) ||
                physAddress::isA(o) ||
                ICMPService::isA(o) ||
                Interval::isA(o) ||
                IPService::isA(o) ||
                NAT::isA(o) ||
                Network::isA(o) ||
                AddressRange::isA(o) ||
                InterfacePolicy::isA(o) ||
                Policy::isA(o) ||
                RuleSet::isA(o) ||
                TCPService::isA(o) ||
                UDPService::isA(o) ||
                FWObject::isA(o));
    }

    bool haveDialog(const string &target)
    {
        return (target=="freebsd" ||
                target=="linux24" ||
                target=="openbsd" ||
                target=="solaris" ||
                target=="ipf"     ||
                target=="iptables"||
                target=="pf"
        );
    }

    virtual DialogPlugin* create(FWObject *o)
    {
        if(CustomService::isA(o))
        {
            return( new CustomServiceDialog(o) );
        } else if(Firewall::isA(o))
        {
            return( new FirewallDialog(o) );
        } else if(Group::isA(o) || 
                  ObjectGroup::isA(o) || 
                  ServiceGroup::isA(o) || 
                  IntervalGroup::isA(o) ||
                  FWObjectDatabase::isA(o)   )
        {
            return( new GroupDialog(o) );
        } else if(Host::isA(o))
        {
            return( new HostDialog(o) );
        } else if(Interface::isA(o))
        {
            return( new InterfaceDialog(o) );
        } else if(IPv4::isA(o))
        {
            return( new IPv4Dialog(o) );
        } else if(physAddress::isA(o))
        {
            return( new physAddressDialog(o) );
        } else if(ICMPService::isA(o))
        {
            return( new ICMPServiceDialog(o) );
        } else if(InterfacePolicy::isA(o))
        {
            return( new InterfacePolicyDialog(o) );
        } else if(Interval::isA(o))
        {
            return( new TimeDialog(o) );
        } else if(IPService::isA(o))
        {
            return( new IPServiceDialog(o) );
        } else if(NAT::isA(o))
        {
            return( new NATDialog(o) );
        } else if(Network::isA(o))
        {
            return(new NetworkDialog(Network::cast(o)));
        } else if(AddressRange::isA(o))
        {
            return(new AddressRangeDialog(AddressRange::cast(o)));
        } else if(Policy::isA(o))
        {
            return( new PolicyDialog(o) );
        } else if(RuleSet::isA(o))
        {
            return( new PolicyDialog(o) );
        } else if(TCPService::isA(o))
        {
            return( new TCPServiceDialog(o) );
        } else if(UDPService::isA(o))
        {
            return( new UDPServiceDialog(o) );
        } else if(FWObject::isA(o))
        {
            return ( new FWObjectDialog(o) );
        } else 
            return NULL;
    }

    virtual DialogPlugin* create(libfwbuilder::FWObject *o,
                                 const string &target)
    {

        if (target=="" || target=="unknown" || target=="unknown_os")
        {
            return( new TargetDialog_unknown(o) );
        } else 
        {
            string mod_path=TEMPLATE_DIR "/modules/gui/lib_" + 
		target + "_dlg." DYNAMIC_MODULE_EXT;

            void *handle;

            create_dialog_fun  cdf;
            void *ptr;
            const char *error;

            if ((handle=dl_handles[mod_path])==NULL)
            {
                handle=dlopen(mod_path.c_str(),DLOPEN_MODE);
                if (handle==NULL) {
                    string s="Could not load external module "+
                      mod_path+"\nError: "+dlerror();
                    MessageDialog::Error(s, main_window::windows.back() );
                    return( new TargetDialog_unknown(o) );
                }
                dl_handles[mod_path]=handle;
            }

            string fname=EXTERNAL_FUNC_NAME_PREFIX "create_dialog_" + target;
            ptr=dlsym(handle,fname.c_str());
            if (ptr==NULL)
	    {
		error = dlerror();
                MessageDialog::Error( error , main_window::windows.back() );
                return( new TargetDialog_unknown(o) );
            }

            cdf=create_dialog_fun(ptr);
            return (*cdf)(o);
        }

        map<string,string> pl=Resources::global_res->getPlatforms();
        MessageDialog::Error("Support for "+pl[target]+" is not installed", main_window::windows.back() );
        return( new TargetDialog_unknown(o) );
    }
    
};


DialogFactory *DialogFactory::instance=new DefaultDialogFactory();


