/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP30Dialog.cc,v 1.25 2003/01/20 07:25:56 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "DiscoveryDruidP30Dialog.hh"
#include "fwbuilder/dns.hh"
#include "MessageDialog.hh"
#include "fwbuilder/FWException.hh"

using namespace libfwbuilder;


DiscoveryDruidP30Dialog::DiscoveryDruidP30Dialog()
{

//    p30_txt_1->set_line_wrap(true);
//    p30_txt_2->set_line_wrap(true);
//    p30_txt_3->set_line_wrap(true);

    p30_txt_1->set_justify(GTK_JUSTIFY_LEFT);
    p30_txt_2->set_justify(GTK_JUSTIFY_LEFT);
    p30_txt_3->set_justify(GTK_JUSTIFY_LEFT);


//    viewport4->set_shadow_type(GTK_SHADOW_ETCHED_IN);

    show_all();

}

DiscoveryDruidP30Dialog::~DiscoveryDruidP30Dialog()
{
    glademm_set_Widget("rb_scrolledwindow", NULL);
}

/*
void DiscoveryDruidP30Dialog::on_destroy_event()
{
    clearRButtons();
}
*/
void DiscoveryDruidP30Dialog::clearRButtons()
{
    vector<Gtk::RadioButton*>::iterator j;
    IPAddress  *na;

    while (true) {
	j=rbuttons.begin();
	if ( j==rbuttons.end() ) break;

	na=(IPAddress*)( (*j)->get_user_data() );
	if (na) delete na;
	(*j)->set_user_data(NULL);
	rbuttons.erase(j);

    }
}

void DiscoveryDruidP30Dialog::on_name_server_changed()
{
    other_ns->set_active(true);
}

void DiscoveryDruidP30Dialog::on_name_server_activate()
{
    other_ns->set_active(true);
}

gint DiscoveryDruidP30Dialog::on_name_server_focus_in_event(GdkEventFocus *ev)
{
    other_ns->set_active(true);
    return 0;
}

void DiscoveryDruidP30Dialog::runDNSQuery(const string& domain_name)  
    throw (FWException)
{
    class Gtk::VBox *rb_vbox;
    class Gtk::Viewport *viewport4;
    class Gtk::ScrolledWindow *rb_sw;

    Gtk::RadioButton::Group    _RadioBGroup_name_servers;

    DNS_getNS_query *dns=new DNS_getNS_query(domain_name);
    int              n;


//    ns_frame->set_label(_("Name servers for domain '") + domain_name + _("':"));



    clearRButtons();

    Gtk::Widget *w=glademm_get_Widget("rb_scrolledwindow");
    if (w!=NULL)
	table35->remove(*w);


    rb_vbox    = manage(new class Gtk::VBox(false, 4));
    viewport4  = manage(new class Gtk::Viewport());
    rb_sw      = manage(new class Gtk::ScrolledWindow());

    viewport4->add(*rb_vbox);
    rb_sw->set_policy(GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
//    rb_sw->set_usize(-1,300);
    rb_sw->add(*viewport4);

    table35->attach(*rb_sw, 0, 1, 2, 3, 
		    GTK_EXPAND|GTK_FILL, GTK_EXPAND|GTK_FILL, 0, 0);

    rb_vbox->show();
    viewport4->show();
    rb_sw->show();

    glademm_set_Widget("rb_scrolledwindow", rb_sw);


    try {
        NullLogger nl;
        SyncFlag   stop_program(false);
	ns_records=dns->getNS(domain_name, &nl, &stop_program);
    } catch (FWException &ex) {
	MessageDialog::Error(
	    string(_("Could not find name servers for the domain: '"))+
	    domain_name+"'  ", ex.toString(), this);

	delete dns;

	throw  ;
	return ;
    }

    multimap<string,IPAddress>::iterator i;
    Gtk::RadioButton *rb;

    for (n=0,i=ns_records.begin(); i!=ns_records.end(); ++n,++i) {

	string s = (*i).first + "  (" + ((*i).second).toString() + ")";

	rb=manage( new Gtk::RadioButton(_RadioBGroup_name_servers,s));
	((Gtk::Label*)( rb->get_child()))->set_alignment(0.0,0.5);

	rb_vbox->pack_start( *rb, false, false, 0);

	IPAddress *na=new IPAddress( (*i).second );
	rb->set_user_data( (gpointer)na );
	rb->show();

	rbuttons.push_back(rb);
    }

    if (rbuttons.size())
	    rbuttons.front()->set_active(true);

    other_ns->set_group( _RadioBGroup_name_servers );
}

IPAddress DiscoveryDruidP30Dialog::getNS()  throw (FWException)
{
    vector<Gtk::RadioButton*>::iterator j;
    string     ns;
    IPAddress *na=NULL;

    if (other_ns->get_active()) {
	ns=name_server->get_text();  

	try {
	    return IPAddress(ns);
	} catch (FWException &ex) {
/* perhaps not address but host name */

	    vector<IPAddress> addr;
	    try {
		addr=DNS::getHostByName(ns);
	    } catch (FWException &ex) {
		throw;
	    }

	    return addr.front();
	}
    }

    for (j=rbuttons.begin(); j!=rbuttons.end(); ++j) {

	if ( (*j)->get_active() ) {
	    na=(IPAddress*)( (*j)->get_user_data() );
	    break;
	}
    }

    if (na==NULL) return IPAddress();
    else          return *na;
}

