/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ExecBgr.cc,v 1.27 2003/01/20 07:25:56 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <fcntl.h>

#include <gtk--.h>

#include "ExecBgr.hh"

#include "fwbuilder/Tools.hh"

using namespace libfwbuilder;


ExecBgr::ExecBgr(const string &c, const string &a) : BackgroundOp()
{
    command = c;
    args    = a;

    pgm_pid    = 0;
    pgm_status = 0            ;
    error      = NULL         ;
}

/*
 * Executed from background thread.
 * it is safe to use logger here.
 */
void ExecBgr::run_impl(Logger *logger,SyncFlag *stop_program)   throw(FWException)
{
    char    str[2048];
    FILE    *fd;
    const char *argv[64];

    string::size_type b,e;
    unsigned          i;

    i=0;
    b=e=0;

    argv[i++]=cxx_strdup( command.c_str() );

    do 
    {
	b=args.find_first_not_of(" ",b);
	if ( b==string::npos ) break;

	if (args[b]=='"') {
	    b++;
	    e=args.find('"',b);
	    if (e!=string::npos) {
		argv[i++]=cxx_strdup( args.substr(b,e-b).c_str() );
	    } else {
		throw FWException(_("Unmatched '\"' in arguments"));
	    }
	} else {
	    e=args.find(' ',b);
	    if (e!=string::npos) {
		argv[i++]=cxx_strdup( args.substr(b,e-b).c_str() );
	    } else {
		argv[i++]=cxx_strdup( args.substr(b).c_str() );
	    }
	}

	b=e+1;
    } while ( b!=string::npos && e!=string::npos && i<(sizeof(argv)/sizeof(char*))  );
    argv[i]=NULL;


  /* Side effect: our popen stores child's PID in pgm_pid */

//    if(access(command.c_str() , R_OK )!=0) {
//	set_pgm_status(-1);

//	throw FWException(_("Could not execute '")+command+_("'"));


//    }
#ifndef __MINGW32__
    if ( (fd=popen(command.c_str(),argv,"r"))==NULL ) 
    {
	pgm_status=-1;
	throw FWException(_("Could not execute '")+command+"'");
    }

    setRunning();

    while(!ferror(fd) && fgets(str, sizeof(str)-1 , fd )!=NULL) 
    {
        *logger << str;
    }
    pgm_status=pclose(fd);
#else
	
    HANDLE fHandle;
    if ( (fHandle=popen(command.c_str(),argv,"r"))==NULL ) 
    {
	pgm_status=-1;
	throw FWException(_("Could not execute '")+command+"'");
    }

    setRunning();
    DWORD nReadBytes = 0;
    do
    {
	if (!ReadFile(fHandle,str,sizeof(str)-1,&nReadBytes,NULL))
	   break; //Pipe has disconnected, so just break.

	str[nReadBytes]='\0';
        *logger << str;
	Sleep(1);

    }while(nReadBytes > 0);
    pgm_status = pclose(fHandle);
#endif

    pgm_pid=0;

    for (i=0; argv[i]!=NULL; i++)
	delete argv[i];
}



Logger* ExecBgr::start_operation()   throw(FWException)
{
    Logger *logger=BackgroundOp::start_operation();

/* logger is protected member of class BackgroundOp */

    *logger << _("Executing '") << command << " " << args << "'\n";

    return logger;
}

void ExecBgr::stop_operation()
{
    if (pgm_pid!=0) 
    {

//        *logger << _("Killing child program pid=") << pgm_pid << _("\n");


#ifndef __MINGW32__
        kill(pgm_pid,SIGKILL);
#else
        TerminateProcess((HANDLE)pgm_pid,1);
#endif

        pgm_pid=0;
    }
    BackgroundOp::stop_operation();
}

