/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ExecBgr.hh,v 1.22 2003/01/20 07:25:56 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _EXECBGR_HH_
#define _EXECBGR_HH_

#include <stdio.h>

#include "config.h"

#include "fwbuilder/BackgroundOp.hh"
#include "fwbuilder/Logger.hh"

/**
 * This is simple implementation of the background execution class
 * using framework provided by BackroundOp class. This class runs
 * external program in the background using popen and sends all its output
 * to pipe_write method of BakgroundOp
 *
 * This class uses flags provided by the base class to signal execution 
 * state of the child, return child status and stop execution if user 
 * closed BackgroundOp window prematurely
 * 
 * Functions popen and pclose are reimplemented using examples from Steven's
 * book  Advanced Programming in the Unix Environment because we need to know
 * child's PID but library functions do not provide any way of knowing it.
 *
 * Custom implementations of popen and pclose are in the separate 
 * file ExecBgr-2 to illustrate how little of the cusotm code does it take
 * to implement useful background operation using base class BackgroundOp
 */
class ExecBgr : public libfwbuilder::BackgroundOp 
{
#ifndef __MINGW32__
    FILE*    popen(const char *cmd, const char* argv[], const char *type)  throw(libfwbuilder::FWException);
    int      pclose(FILE *fp);
#else
    HANDLE pIn;
    HANDLE pOut;

    HANDLE   popen(const char *cmd, const char* argv[], const char *type)  throw(libfwbuilder::FWException);
    int      pclose(HANDLE fHandle);
#endif
    int      open_max(void);
    int      pgm_pid;
    int      pgm_status;
    
protected:

    virtual void  run_impl(libfwbuilder::Logger *,libfwbuilder::SyncFlag *stop_program)   throw(libfwbuilder::FWException);
    string   command;
    string   args;

public:

    ExecBgr(const std::string &c, const std::string &a);

    virtual libfwbuilder::Logger* start_operation()  throw(libfwbuilder::FWException);
    virtual void                  stop_operation();

    int      get_pgm_status() { return pgm_status; }
};


#endif
