/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWObjectBook.cc,v 1.28 2003/03/22 09:03:43 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "glademm_support.hh"

#include "FWObjectBook.hh"
#include "ObjectTree.hh"
#include "FWObjectDatabaseGUI.hh"
#include "fwbuilder/Group.hh"
#include "main_window.hh"

#include <assert.h>

using namespace libfwbuilder;

FWObjectBook::FWObjectBook(main_window *mw)
{

    main_w=mw;

    set_name("FWObjectBook");
    glademm_set_Widget("FWObjectBook", this);

    mode="Split";

    nb=NULL;

/*
    nb=manage(new Gtk::Notebook());

    nb->set_show_tabs(true);
    nb->set_tab_border(0);
    
    nb->show();
    add(*nb);

    nb->switch_page.connect(SigC::slot(this, 
				       &FWObjectBook::on_switch_page));

*/
}

void FWObjectBook::setMode( const string &_mode )
{
    if (_mode!=mode) {
	mode=_mode;
	if (nb!=NULL) {
	    clearSelection();
	    main_w->ClearRightPane(true);
	    build();
	}
    }
}

void FWObjectBook::showPage(unsigned page_num)
{
    nb->set_page( page_num );
}

void FWObjectBook::addPage(const string& lib_name,const string& tab_name)
{
    Gtk::ScrolledWindow *sw=manage(new Gtk::ScrolledWindow());
    ObjectTree *ot = manage(new ObjectTree(main_w,lib_name));
    Gtk::Label *lb = manage(new class Gtk::Label(tab_name));

    sw->add(*ot);

    nb->pages().push_back(Gtk::Notebook_Helpers::TabElem(*sw, *lb));

    ot->show();

    ot->scheduleRebuild();

    int page=nb->pages().size()-1;  // notebook page numbers start from 0
    trees[page]=ot;
    libraries[page]=lib_name;
}

void FWObjectBook::scanObjectDatabase(FWObject *obj)
{
    string lib;
    for(list<FWObject*>::iterator m=obj->begin(); m!=obj->end(); ++m) 
    {
        if ((*m)!=NULL) {
            lib=(*m)->getLibrary();

            bool present=false;
            for (unsigned i=0; i<nb->pages().size(); ++i)
                if (libraries[i]==lib) { present=true; break; }

            if (!present)  //new library
                addPage(lib,lib);

            scanObjectDatabase( (*m) );
        }
    }

}

void   FWObjectBook::rebuild()
{
    string current=getCurrentSelection();
    build();
    showObject(current);
}

void   FWObjectBook::build()
{
/* remove old notebook widget and create new one */
    if (nb!=NULL) nb->hide();
    remove();

    trees.clear();
    libraries.clear();

    nb=manage(new Gtk::Notebook());

    nb->set_tab_border(0);
    
    nb->show();
    add(*nb);


    if (mode=="Split") {
/*
 *  first page: objects, created by user. Library==""
 */
	nb->set_show_tabs(true);
	addPage("",_("User"));

	scanObjectDatabase( FWObjectDatabaseGUI::db );
    }
    if (mode=="Combined") {
	addPage("All","");
	nb->set_show_tabs(false);
    }

    show_all();

    nb->switch_page.connect(SigC::slot(this, 
				       &FWObjectBook::on_switch_page));

//    main_w->setCurrentLibrary("");
    main_w->schedule_open_object(FWObjectDatabaseGUI::db->getId() , "" );
}


void FWObjectBook::on_switch_page(Gtk::Notebook_Helpers::Page* p0,guint p1)
{
    assert(main_w!=NULL);

    if(!is_visible()) 
        return;

    BuiltinDialog *w=main_w->getRightPaneDialog();
    if (w==NULL) return;  // BuiltinDialog has not been created yet

    string dlg_lib=w->getObject()->getLibrary();

/* p1 is the new page number */
    ObjectTree *ot=trees[p1];
    if (ot && libraries[p1]!=dlg_lib )
	ot->clearSelection();
}

void   FWObjectBook::insertObject( const string &id )
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->insertObject(id);
}

void   FWObjectBook::insertObject( FWObject *o)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->insertObject(o);
}

void   FWObjectBook::removeObject( const string &id )
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->removeObject(id);
}

void   FWObjectBook::removeObject( FWObject *o)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->removeObject(o);
}

void   FWObjectBook::sortSubtree(const string &id,int col)
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    ot->sortSubtree(id,col);
}

void   FWObjectBook::changeTreeLabel(const string &id)
{
//    ObjectTree *ot = trees[ nb->get_current_page_num() ];

    FWObject *o=FWObjectDatabaseGUI::db->getById(id,true);
    if(o==NULL) return;

    ObjectTree *ot = trees[ getPage( o , o->getLibrary() ) ];
    assert (ot!=NULL);

    ot->changeTreeLabel(id);
}

string FWObjectBook::getCurrentSelection()
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);

    return ot->getCurrentSelection();
}

string FWObjectBook::getCurrentLibrary()
{
    unsigned page=nb->get_current_page_num();
    if ( libraries.count(page)!=0 ) return libraries[page];
    return string(_("All"));

}

int FWObjectBook::getPage(FWObject *o,const std::string &lib)
{
    ObjectTree *ot=NULL;
    ot = trees[0];

    if (mode=="Split")    {
	for (unsigned i=0; i<nb->pages().size(); ++i)
	    if (libraries[i]==lib) {
		ot = trees[i];
                return i;
	    }
    }

    return 0;
}


ObjectTree* FWObjectBook::openPage(FWObject *o,const std::string &lib)
{
    int tn= getPage(o,lib);
    showPage( tn );
    return trees[tn];
}

void   FWObjectBook::showObject(FWObject *o,const string &lib)
{
    ObjectTree *ot=openPage(o,lib);
    if (ot!=NULL) 
    { 
        ot->showObject(o->getId());
//        ot->selectObject(o->getId());
    }
}

void   FWObjectBook::showObject(const string &id, const string &lib)
{
    FWObject *o=FWObjectDatabaseGUI::db->getById(id,true);
    if(o==NULL) return;

    showObject(o,lib);
}

void   FWObjectBook::showObject(FWObject *o)
{
    showObject(o,o->getLibrary());
}

void   FWObjectBook::showObject(const string &id)
{
    FWObject *o=FWObjectDatabaseGUI::db->getById(id,true);
    if(o==NULL) return;

    showObject(o,o->getLibrary());
}

void   FWObjectBook::selectObject(const string &id)
{
    FWObject *o=FWObjectDatabaseGUI::db->getById(id,true);
    if(o==NULL) return;

    ObjectTree *ot=openPage(o,o->getLibrary());
    if (ot!=NULL) { 
        ot->selectObject(o->getId());
    }
}

void   FWObjectBook::clearSelection()
{
    ObjectTree *ot=NULL;

    if (mode=="Split")    ot = trees[ nb->get_current_page_num() ];
    if (mode=="Combined") ot = trees[0];

    assert (ot!=NULL);
    ot->clearSelection();
}

void     FWObjectBook::clearSelectionOnAllPages(ObjectTree *tree)
{
    map<unsigned,class ObjectTree*>::iterator m;
    for (m=trees.begin(); m!=trees.end(); ++m) {
	if ( (*m).second == tree ) continue;
	(*m).second->clearSelection();
    }
}

string   FWObjectBook::getNextId()
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);
    return ot->getNextId();
}

string   FWObjectBook::getPrevId()
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);
    return ot->getPrevId();
}

string   FWObjectBook::getParentId()
{
    ObjectTree *ot = trees[ nb->get_current_page_num() ];
    assert (ot!=NULL);
    return ot->getParentId();
}
