/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FileSel.cc,v 1.10 2003/04/26 07:39:36 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <string>

#include "FileSel.hh"
#include "Preferences.hh"
#include "helpers.hh"

using namespace libfwbuilder;


FileSel::FileSel(const string &title,const string &dir,const string &filext) : 
    Gtk::FileSelection(title)
{
    hide_fileop_buttons();

    string  cmpl;

    if (dir!="")   cmpl=dir+"/"+filext;
    else           cmpl=filext;

    complete(cmpl);

//  set_filename("fwbuilder.xml");

    get_ok_button()->clicked.connect(slot(this, &FileSel::file_ok_sel));
    get_cancel_button()->clicked.connect(hide.slot());
    hide.connect(Gtk::Main::quit.slot());
    show();
#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",this);
#endif
}

string& FileSel::run()
{
  Gtk::Main::grab_add(*this);
  Gtk::Main::run();
  Gtk::Main::grab_remove(*this);
  return(file_choice);
}

void FileSel::file_ok_sel() 
{
  file_choice=get_filename();
  Gtk::Main::quit();
}
