/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org
           Vadim Zaliva      lord@crocodile.org

  $Id: GenericBackgroundOpDialog.cc,v 1.5 2003/04/06 01:49:04 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "GenericBackgroundOpDialog.hh"
#include "helpers.hh"

#include "StockButton.hh"

using namespace libfwbuilder;
using namespace SigC;

GenericBackgroundOpDialog::GenericBackgroundOpDialog( BackgroundOp *b )
{
    init( new BackgroundOpWidget(b) );
}

GenericBackgroundOpDialog::GenericBackgroundOpDialog( BackgroundOpWidget *_bow )
{
    init(_bow);
}

void GenericBackgroundOpDialog::init( BackgroundOpWidget *w )
{
    bow=manage(w);

    get_vbox()->remove(*placeholder);
    get_vbox()->pack_start(*bow);

    set_usize(600,250);
    set_position(GTK_WIN_POS_CENTER);
    set_policy(true, true, false);

    btn=manage(new StockButton(StockButton::STOP));

    btn->set_name("background_op_dialog_button");
    btn->set_usize(90,30);
    get_action_area()->pack_start(*btn,false,false);

    btn->show();
    btn->grab_focus();

    btn->clicked.connect(SigC::slot(this, 
                                    &GenericBackgroundOpDialog::on_stop_button_clicked));

    delete_event.connect(  SigC::slot(this,&GenericBackgroundOpDialog::on_delete_event));
    bow->completed.connect(SigC::slot(this,&GenericBackgroundOpDialog::on_op_completed));

    show_all();
#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",this);
#endif
}

GenericBackgroundOpDialog::~GenericBackgroundOpDialog() 
{
    bow->disconnect();
}

gint GenericBackgroundOpDialog::on_delete_event(GdkEventAny* ev)
{
    bow->stop();
    return 0;
}

void    GenericBackgroundOpDialog::disconnect()
{
    bow->disconnect();
}

int GenericBackgroundOpDialog::execute()
{
    try
    {

        bow->execute();

        Gtk::Main::grab_add(*this);
        Gtk::Main::run();
        Gtk::Main::grab_remove(*this);

        return 0;
    } catch(const FWException &ex)
    {
        return -1; //TODO: more meaningful number
    }
}

int GenericBackgroundOpDialog::on_op_completed(int arg)
{
    btn->hide();
    get_action_area()->remove(*btn);

    btn=manage(new StockButton(StockButton::OK));

    btn->set_name("background_op_dialog_button");
    btn->set_usize(90,30);
    get_action_area()->pack_start(*btn,false,false);

    btn->show();
    btn->grab_focus();

    btn->clicked.connect(SigC::slot(this, 
                          &GenericBackgroundOpDialog::on_ok_button_clicked));
    return 0;
}

void GenericBackgroundOpDialog::on_stop_button_clicked()
{
    bow->stop();
    bow->disconnect();
    on_op_completed(-1);
}

void GenericBackgroundOpDialog::on_ok_button_clicked()
{
    Gtk::Main::quit();
}

