/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: GroupDialog.cc,v 1.70 2003/04/07 01:04:40 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "fwbuilder/Tools.hh"
#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Group.hh"
#include "FWObjectDatabaseGUI.hh"
#include "GroupDialog.hh"
#include "MessageDialog.hh"
#include "helpers.hh"

#include "main_window.hh"

#include "gen_popup_menu.hh"

#include "glademm_support.hh"

#include <gtk--.h>

#include <assert.h>

using namespace libfwbuilder;


GroupDialog::GroupDialog(FWObject *obj)
{
    GroupIconList=NULL;
    object=obj;

    assert( obj!=NULL );

    GroupIconList=manage(new  ListOfIcons(80,60,true));
    assert( GroupIconList!=NULL );

    GroupIconList->set_border(8);
    GroupIconList->set_row_spacing(1);
    GroupIconList->set_col_spacing(8);


//  defer setting of gr_lib because main_w is not defined in constructor yet

    gr_lib="UNDEFINED";

    string ot=Preferences::global_prefs->getOptStr(
	"/FWBuilderPreferences/UI/ObjectTreeMode");

//    if (ot=="Split") {
//
//	FWObjectBook *book=main_w->getObjectBook();
//	assert (book!=NULL);
//    }

    sw=manage(new Gtk::ScrolledWindow());
    sw->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    group_internal_hbox->remove( *group_internal_hbox_label );
    group_internal_hbox->pack_start(*sw);
    sw->show();

    sw->add_with_viewport( *GroupIconList);
    GroupIconList->show();

    set_name("group_dialog");

  /*******************************************************************/

    /* Drag destination */
    GroupIconList->drag_dest_set ( GTK_DEST_DEFAULT_ALL,
				   target_table, n_targets,
				   static_cast < GdkDragAction > ( GDK_ACTION_COPY ) );

    GroupIconList->drag_data_received.connect( 
	slot ( this, &GroupDialog::obj_drag_data_received ) );

  /*******************************************************************/

  /*  When user presses Enter while one of the group items is selected,
   *    IconList sends signal open_item. 
   */

    GroupIconList->open_item.connect(SigC::slot(this,&GroupDialog::on_open_item));
    GroupIconList->popup_menu.connect(SigC::slot(this,&GroupDialog::on_popup_menu));

    group_name->changed.connect(SigC::slot(this,&GroupDialog::on_changed));
}

GroupDialog::~GroupDialog()
{
//    sw->remove();
//    if (GroupIconList!=NULL) delete GroupIconList;
}

void GroupDialog::on_open_item(void *arg)
{
    string   *id = (string*)arg;
    if (id!=NULL && main_w->safe_to_close_right_pane() )
    {
	FWObject *o  = FWObjectDatabaseGUI::db->getById(*id,true);        
	main_w->schedule_open_object(*id, o->getLibrary() );
    }
}


void GroupDialog::on_popup_menu(void *arg)
{
    Gtk::Widget *itm;

    char **menu_items0;
    gen_popup_menu *gpm;

    menu_items0=new char*[6];
    menu_items0[0]=_("Open");
    menu_items0[1]="";
    menu_items0[2]=_("Copy");
    menu_items0[3]=_("Cut");
    menu_items0[4]=_("Paste");

    menu_items0[5]=NULL;
    gpm=new gen_popup_menu( (const char**)menu_items0 );

      

//    FWObject *o=(FWObject*)arg;
    string *id=(string*)arg;

    FWObject *org  = NULL;

    if (id==NULL) {
	itm=find_widget("Open",gpm);   if (itm) itm->set_sensitive(false);
	itm=find_widget("Copy",gpm);   if (itm) itm->set_sensitive(false);
	itm=find_widget("Cut",gpm);    if (itm) itm->set_sensitive(false);
	itm=find_widget("Paste",gpm);  if (itm) itm->set_sensitive(true );
    } else {
	org  = FWObjectDatabaseGUI::db->getById(*id,true);        

	itm=find_widget("Copy",gpm); if(itm)itm->set_sensitive(!Resources::isSystem(org));
	itm=find_widget("Cut",gpm);  if(itm)itm->set_sensitive(!Resources::isSystem(org));
	itm=find_widget("Paste",gpm);if(itm)itm->set_sensitive(!Resources::isSystem(org));
    }

    if ( Resources::isSystem(object) ) {
	itm=find_widget("Paste",gpm);if(itm)itm->set_sensitive(false);
    }

    gpm->popup(0,0);
    gint menu_choice=gpm->run();
    delete gpm;

    delete menu_items0;
    
    switch (menu_choice) {
    case 0:    // open
	if ( main_w->safe_to_close_right_pane() ) 
        {
            FWObject *o  = FWObjectDatabaseGUI::db->getById(*id,true);        
	    main_w->schedule_open_object(*id, o->getLibrary());
        }
	break;
    case 2:    // copy
	if (org) FWObjectClipboard::obj_clipboard->putObject(org);
	break;
    case 3:    // cut
	if (org) {
	    if ( ! Resources::isSystem(object) ||  main_w->confirm_remove_object(*id) ) {

		FWObjectClipboard::obj_clipboard->putObject(org);
		GroupIconList->removeObject(*id);
		data_changed_flag(true);
	    }
	}
	break;
    case 4:    // paste
    {
	FWObject *obj=FWObjectClipboard::obj_clipboard->getObject();
	if ( obj!=NULL ) 
            addObject(obj);
	break;
    }
    }
  
}


void GroupDialog::on_viewport1_check_resize() {  }
void GroupDialog::on_viewport1_size_allocate(GtkAllocation *all)  { }

bool GroupDialog::showObjectInDialogPredicate(libfwbuilder::FWObject *obj)
{
    bool  show_hidden= Preferences::global_prefs->getOptBool(
	"/FWBuilderPreferences/UI/ShowHidden");
    bool  hidden_obj = Resources::global_res->getObjResourceBool(obj,"hidden");

    return 
	(show_hidden || ! hidden_obj)
	&&
	( ! Resources::isSystem(object) ||
	  getLibrary()=="All" || obj->getLibrary()==getLibrary() || 
	  Resources::isSystem(obj) )  ;
}

void GroupDialog::wrk2dlg()
{
    bool       show_hidden;
    FWObject  *obj;
   
    assert( object!=NULL );

    show_hidden= (Preferences::global_prefs->getOptBool(
	"/FWBuilderPreferences/UI/ShowHidden"));

    if (Resources::isSystem(object)) {

	if ( object->getId()== FWObjectDatabaseGUI::getRootId() ) {
	    string title("");
	    if (getLibrary()=="") title=title+_("User defined objects");
	    else                  title=title+getLibrary();
	    group_name_lbl->set_text(title);
	}
	else {
	    group_name_lbl->set_text( object->getName() );
	}
	group_name_frm->show();
	if (group_name!=NULL) {
	    group_name->hide();
	    packer129->remove( *group_name );
	    group_name=NULL;
	}
    } else {
	group_name->show();
	group_name->set_text( object->getName() );
	group_name->set_editable(true);
	if (group_name_frm!=NULL) {
	    group_name_frm->hide();
	    packer129->remove( *group_name_frm );
	    group_name_frm=NULL;
	    group_name_lbl=NULL;
	}
    }

    GroupIconList->clear();

    bool ref=!Resources::isSystem(object);

    for(list<FWObject*>::iterator m=object->begin(); m!=object->end(); ++m) 
    {
	if ( (obj=(*m))!=NULL ) {
	    if ( FWReference::cast(obj)!=NULL) {
		obj=( FWReference::cast(obj) )->getPointer();
	    }
	    if (showObjectInDialogPredicate(obj)) {
		GroupIconList->addObject(obj, ref);
	    }
	}
    }

    GroupIconList->arrangeIcons();
    GroupIconList->select_icon(0);
}

void GroupDialog::on_changed()
{
    data_changed_flag(true);
}

string GroupDialog::getLibrary()
{
    if (gr_lib=="UNDEFINED") {
        gr_lib="All";
        string ot=Preferences::global_prefs->getOptStr(
            "/FWBuilderPreferences/UI/ObjectTreeMode");

        if (ot=="Split") {
            gr_lib=main_w->getObjectBook()->getCurrentLibrary();
        }
    }
    return gr_lib;
}

void GroupDialog::setLibrary(const string &_lib)
{
    gr_lib=_lib;
}

bool GroupDialog::dlg2wrk()
{
    assert( object!=NULL );

    object->setName( group_name->get_text() );

    FWObjectBook *book=main_w->getObjectBook();
    assert(book);

 loop0:
    for (FWObject::iterator m=object->begin(); m!=object->end(); ++m) 
    {
	FWObject *obj;
	if ( (obj=(*m))!=NULL ) {
	    
	    bool is_ref=(FWReference::cast(obj)!=NULL);
	    if (is_ref) obj=( FWReference::cast(obj) )->getPointer();

	    if ( showObjectInDialogPredicate(obj)) 
            {
		string id1=obj->getId();
		if ( GroupIconList->checkObjectId(id1) ) continue;

		if (!is_ref) {  // removing object itself, not a reference

		    book->removeObject(obj);
/*
 * dialog works with a copy in tmp, so obj points at the object
 * there
 *
		    FWObjectDatabaseGUI::tmp->removeAllInstances(obj);
 */
		    obj=FWObjectDatabaseGUI::db->getById( id1 , true);
		    FWObjectDatabaseGUI::db->removeAllInstances(obj);
		} else {
		    object->remove( *m );
		}
		goto loop0;
	    }
	}
    }


    if ( !Resources::isSystem(object)  ) 
    {
	for (int i=0; i<GroupIconList->getCount(); ++i) 
        {
	    string id2=GroupIconList->getObjectId(i);

            bool present=false;
            list<FWObject*>::iterator j;
            for(j=object->begin(); j!=object->end(); ++j)     
            {
                FWObject *o=*j;
                string oid=o->getId();
                if(id2==oid) { present=true; break; }

                FWReference *ref;
                if( (ref=FWReference::cast(o))!=NULL &&
                    id2==ref->getPointerId()) { present=true; break; }
            }
            if (present) continue;

//	    if ( object->getById(id2,false,true)!=NULL ) continue;
	    FWObject *o=FWObjectDatabaseGUI::db->getById(id2,true);
	    object->addRef( o );
	}
    }
    return true;
}

void GroupDialog::Update()
{
    wrk2dlg();
}

void GroupDialog::addObject(FWObject *obj)
{
/*
 * Sometimes object to be added to the group comes from the clipboard.
 * Clipboard holds a copy of the original object, which may be
 * detached from the tree. Check for a special case when user did
 * "cut" and thus an object in the clipboard is not attached to the
 * tree anymore. We can't add reference to such object to a group.
 */
    FWObject *oo=FWObjectDatabaseGUI::db->getById( obj->getId() , true);
    if (oo!=NULL) {
/*
 * if this is system group or it is not writable, do not accept object
 */
        if (Resources::isSystem(object))  return;

        Group     *gr=Group::cast(object);
/*
 *  check if object is appropriate for this group
 */
        string id=oo->getId();

        if (gr->validateChild( oo ) && ! GroupIconList->checkObjectId(id) ) 
        {
            GroupIconList->addObject( oo , true );
            GroupIconList->arrangeIcons();
            data_changed_flag(true);
        }
    }
}

void GroupDialog::conditionalRefresh(FWObject *obj)
{
    if (isPartOfDialog(obj) )
    {
        wrk2dlg();
        data_changed_flag(false);
    }
}

bool GroupDialog::isPartOfDialog(FWObject *obj)
{
    if (obj==NULL || 
        object->getId()==obj->getId() || 
        object->getById( obj->getId() , false)!=NULL) return true;

    std::set<FWReference*> res=object->findAllReferences(obj);
    return ( ! res.empty() );
}




void GroupDialog::obj_drag_data_received ( GdkDragContext     *context,
					   gint                x,
					   gint                y,
					   GtkSelectionData   *data,
					   guint               info,
					   guint32             time)
{
    char           obj_id[64];

    assert( object!=NULL );

    Gdk_DragContext gdc ( context );
    if ( ( data -> length >= 0 ) && ( data -> format == 8 ) ) {

	Gtk::Widget::drag_finish ( gdc, true, false, time );
    
	FWObject *obj;

	memcpy(obj_id,(char*)data->data,data->length);
	obj=FWObjectDatabaseGUI::db->getById( obj_id , true );

	addObject(obj);
	return;
    }
    Gtk::Widget::drag_finish ( gdc , false, false, time );
}


/*
 * Disable menu items which make sence only for specific objects
 */
void GroupDialog::updateMainMenu()
{
    DialogPlugin::updateMainMenu();

    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    itm=find_widget("paste",main_menubar);

    if (itm) itm->set_sensitive( ! Resources::isSystem(object) );
}





