/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: HostDialog.cc,v 1.53 2003/09/29 05:17:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"

#include "main_window.hh"
#include "FWObjectDatabaseGUI.hh"
#include "HostDialog.hh"
#include "fwbuilder/Host.hh"
#include "fwbuilder/Interface.hh"
#include "fwbuilder/Management.hh"

#include "GenericBackgroundOpDialog.hh"
#include "MessageDialog.hh"
#include "helpers.hh"
#include "fwbuilder/dns.hh"
#include "IPAddressWidget.hh"
#include "main_window.hh"
#include "InterfaceData.hh"

#include "fwbuilder/snmp.hh"

#include <assert.h>


using namespace libfwbuilder;

int HostDialog::current_page=0;


HostDialog::HostDialog(FWObject *obj) 
{
    object=obj; 

    object_parameters.push_back( DialogOption( obj_name  , "name"     ) );
    object_parameters.push_back( DialogOption( comment   , "comment"  ) );

    common_options.push_back(    DialogOption( use_mac_addr     , "use_mac_addr_filter"         ) );

    common_options.push_back(    DialogOption( snmp_description , "snmp_description"     ) );
    common_options.push_back(    DialogOption( snmp_location    , "snmp_location"        ) );
    common_options.push_back(    DialogOption( snmp_contact     , "snmp_contact"         ) );

    notebook1->switch_page.connect(SigC::slot(this, 
                                              &HostDialog::on_switch_page));

    notebook1->set_page(current_page);
}

HostDialog::~HostDialog() 
{
}

void HostDialog::on_switch_page(Gtk::Notebook_Helpers::Page* p0,guint p1)
{
    // do nothing if dialog is not visible
    // it turns out, "switch_page" signal gets invoked 
    // when notebook pages are destroyed
    if(!is_visible()) 
        return;

    updateMainMenu();
    current_page=p1;
}

void HostDialog::wrk2dlg()
{
    options=(Host::cast(object))->getOptionsObject();
    assert(options!=NULL);

    Management *mgmt=(Host::cast(object))->getManagementObject();
    assert(mgmt!=NULL);


    loadPageOptions(object,  object_parameters );
    loadPageOptions(options, common_options );

    snmp_r_community->set_text(mgmt->getSNMPManagement()->getReadCommunity());
    snmp_w_community->set_text(mgmt->getSNMPManagement()->getWriteCommunity());

    obj_name->grab_focus();
}

bool HostDialog::dlg2wrk()
{

    Management *mgmt=(Host::cast(object))->getManagementObject();
    assert(mgmt!=NULL);

    savePageOptions(object,  object_parameters );
    savePageOptions(options, common_options );

    mgmt->setAddress( (Host::cast(object))->getAddress() );
    mgmt->getSNMPManagement()->setReadCommunity( snmp_r_community->get_text() );
    mgmt->getSNMPManagement()->setWriteCommunity( snmp_w_community->get_text() );

    return(true);
}

void HostDialog::on_changed()
{
    data_changed_flag(true);
}


void HostDialog::on_snmp_get_descr_released()
{
#ifdef HAVE_LIBSNMP

    string addr;
    string rcomm=snmp_r_community->get_text();

    addr=Address::cast(object)->getAddress().toString();

    if(rcomm.empty()) 
    {
	MessageDialog::Error(_("missing SNMP community string"),main_w);
	return;
    }

    if(addr=="" || addr=="0.0.0.0") 
    {
        vector<IPAddress> addrs;
        try {
            addrs=DNS::getHostByName( obj_name->get_text() );
        } catch (FWException &e)
        {
            MessageDialog::Error( e.toString(), this );
            return;
        }
        addr=addrs.front().toString();
    }

    int t=Preferences::global_prefs->getOptInt("/FWBuilderPreferences/Network/SNMPTimeout", -1);

    SNMP_sysdesc_query *q=new SNMP_sysdesc_query();
    q->init(addr , rcomm,
	    Preferences::global_prefs->getOptInt("/FWBuilderPreferences/Network/SNMPRetries",  SNMP_DEFAULT_RETRIES),
	    t==-1?SNMP_DEFAULT_TIMEOUT:(1000000L*t)
    );


    GenericBackgroundOpDialog bdisp(q);
    
    try
    {
        bdisp.execute();
        snmp_description->set_point(0);
        snmp_description->forward_delete( snmp_description->get_length() );
        snmp_description->insert( XMLTools::cleanForNVTASCII( q->getDescr()) );
        snmp_location->set_text( XMLTools::cleanForNVTASCII( q->getLocation() ));
        snmp_contact->set_text( XMLTools::cleanForNVTASCII( q->getContact()) );

        data_changed_flag(true);
    } catch(const FWException &ex)
    {
        //do nothing
    }

    bdisp.disconnect();
    delete q;

#endif
}

/**
 *  enable and disable menu items which make sence only for this object
 */
void HostDialog::updateMainMenu()
{
    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    DialogPlugin::updateMainMenu();

    itm=find_widget("insert_interface",main_menubar);
    if (itm) itm->set_sensitive(true);

#ifdef HAVE_LIBSNMP
    itm=find_widget("insert_interface_via_snmp",main_menubar);
    if (itm) itm->set_sensitive(true);
#endif
}



