/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfacePolicyDialog.cc,v 1.6 2002/11/15 07:20:17 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/Management.hh"


#include "InterfacePolicyDialog.hh"
#include "helpers.hh"
#include "PolicyList.hh"
#include "main_window.hh"
#include "FWObjectDatabaseGUI.hh"

#include <assert.h>

using namespace libfwbuilder;


InterfacePolicyDialog::InterfacePolicyDialog(FWObject *obj)
{
    InterfacePolicy  *pol;
    
    object=obj;
    dialog_buttons=true;

    FWObject *p =object;
    do {  p=p->getParent(); } while ( p!=NULL && Firewall::cast(p)==NULL );
    assert(p!=NULL);   // fw is a pointer to the firewall object
    fw=Firewall::cast(p);

    tmp_copy=InterfacePolicy::cast( FWObjectDatabaseGUI::db->create(obj->getTypeName(),true) );
    tmpgrp=new TMPGroupObject();

    bool f=fw->isDirty(true);
    fw->add(tmpgrp,false);  // turn off validation
    tmpgrp->add(tmp_copy);
    if (!f) fw->setDirty(false,true);

    policylist_ptr=NULL;

    assert( RuleSet::cast(obj)!=NULL );

    pol=InterfacePolicy::cast(tmp_copy);

    policylist_ptr = new InterfacePolicyList(pol);

  /*******************************************************************/


    remove();
/*
    sw= new Gtk::ScrolledWindow();
    sw->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    sw->set_name("PolicyListSW");
    add(*sw);
    sw->show();    
    sw->add_with_viewport(*policylist_ptr);
*/
    add( *policylist_ptr );
    policylist_ptr->show();

    set_name("policy_dialog");
}

InterfacePolicyDialog::~InterfacePolicyDialog()
{
    bool f=fw->isDirty(true);
    tmpgrp->clearChildren(true);
    fw->remove(tmpgrp,true);
    if (!f) fw->setDirty(false,true);
    
//    sw->hide();
    policylist_ptr->hide();

    delete policylist_ptr;
//    delete sw;
}


void InterfacePolicyDialog::on_policy_line_add()
{
    data_changed_flag(true);
}

void InterfacePolicyDialog::on_policy_line_remove()
{
    data_changed_flag(true);
}

void InterfacePolicyDialog::wrk2dlg()
{
    InterfacePolicy *pol=InterfacePolicy::cast(object);
    bool f=pol->isDirty(true);
    *tmp_copy = *pol;
    tmp_copy->setDirty(f,true);
    if (policylist_ptr!=NULL)  policylist_ptr->build();
}

bool InterfacePolicyDialog::dlg2wrk()
{
    InterfacePolicy *pol=InterfacePolicy::cast(object);
    if (tmp_copy->isDirty(true))
        *pol = *tmp_copy;
    return(true);
}

/**
 *  enable and disable menu items which make sence only for this object
 */
void InterfacePolicyDialog::updateMainMenu()
{
    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    DialogPlugin::updateMainMenu();

    itm=find_widget("policy",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("insert_top",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("append_bottom",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("add_after",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("remove_current",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("move_up",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("move_down",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("rules_druid",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("compile_policy",main_menubar);
    if (itm) itm->set_sensitive(true);

    FWObject *f=object;
    while (Firewall::cast(f)==NULL)
	f=f->getParent();

    Management *mgmt=(Firewall::cast(f))->getManagementObject();
    assert(mgmt!=NULL);
    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    itm=find_widget("install_policy",main_menubar);
    if (itm) itm->set_sensitive( pis->isEnabled() );
}

void InterfacePolicyDialog::conditionalRefresh(FWObject *obj)
{
    if (obj==NULL || object->getId()==obj->getId()) {
        wrk2dlg();
//        policylist_ptr->schedule_rebuild(0);
        data_changed_flag(false);
    }
}

bool InterfacePolicyDialog::isPartOfDialog(libfwbuilder::FWObject *obj)
{
    if (object->getId()==obj->getId()) return true;
    std::set<FWReference*> res=object->findAllReferences(obj);
    return ( ! res.empty() );
}


