/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ListOfIcons.cc,v 1.34 2003/06/24 06:36:03 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "config.h"

#include "glademm_support.hh"

#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/FWReference.hh"
#include "BuiltinDialog.hh"
#include "ListOfIcons.hh"
#include "helpers.hh"

#include <assert.h>

using namespace libfwbuilder;

/*
 *   this class uses my own widget IconList and adds support for some
 *   additional events to it (vk)
 */
ListOfIcons::ListOfIcons(gint icon_width ,
			 gint icon_height,
			 bool allow_popup_menu,int max_no_of_icons )
{
    max_count=max_no_of_icons;

    set_icon_width( icon_width );
    set_icon_height( icon_height );

    popup=allow_popup_menu;
    show();
}

ListOfIcons::~ListOfIcons()
{
//    IconList::clear();
}


void ListOfIcons::set_data_changed_flag(bool flag)
{
    Gtk::Widget *p=this;
    do { p=p->get_parent(); } while (p!=NULL && p->get_name()!="BuiltinDialog");
    BuiltinDialog *b=dynamic_cast<BuiltinDialog*>(p);
    assert (b!=NULL);
    b->data_changed_flag(flag);
}

gint ListOfIcons::button_press_event_impl(GdkEventButton* ev)
{
    IconList::button_press_event_impl(ev);

    if ( ev->type==GDK_2BUTTON_PRESS && ev->button==1 && get_selected()>=0) 
	open_item( get_icon_data( get_selected() ) );    // this is signal

    return(true);
}


gint ListOfIcons::button_release_event_impl(GdkEventButton* ev)
{
    IconList::button_release_event_impl(ev);

    string   *id=NULL;
    
    if (get_selected()!=-1) 
	id=(string*)(get_icon_data( get_selected() ));

    if ( ev->type == GDK_BUTTON_RELEASE  && ev->button==3 ) {
	if (! popup ) return(true);   // popup menu disabled
    	popup_menu(id);
    }
    return(true);
}

gint ListOfIcons::key_press_event_impl(GdkEventKey* ev)
{
    IconList::key_press_event_impl(ev);

    string   *id=NULL;
    
    if (get_selected()!=-1) 
	id=(string*)(get_icon_data( get_selected() ));

    if ( ev->keyval==GDK_space)
    {
	if (! popup ) return(true);   // popup menu disabled
	popup_menu(id);    // this is signal
    }

    if (id!=NULL && ev->keyval==GDK_Return)
	open_item(id);    // this is signal

    return false;
}

void ListOfIcons::clear()
{
    IconList::clear();
}


gint ListOfIcons::getCount()
{
    return( IconList::get_size() );
}

void ListOfIcons::addObject(FWObject *obj,bool ref)
{
    int            icn;

    if (obj==NULL) return;

    if ( ! checkObjectId( obj->getId() ) ) {

	if (max_count!=0 && getCount()>=max_count) {
/*
 * if number of icons reached max_count, then remove the first one
 */
	    removeObject( getObjectId(0) ); 
	}

        string icon=(ref)?Resources::getRefIconFileName(obj):Resources::getIconFileName(obj);
	icn=append( icon , obj->getName() );

	// We return pointer to actuall string residing
	// within other object holding it's ID.
	// If this object is deleted, this string
	// becomes invalid.
	// We assume here that this would not happen, while
	// this dialogue is running.
	// (lord)
	set_icon_data(icn, (void*)&obj->getId());

    }
}

int  ListOfIcons::findIcon(const string& id)
{
    string id2;
    for (int i=0; i<getCount(); ++i) {
	id2=getObjectId(i);
	if (id==id2) return i;
    }
    return -1;
}

void ListOfIcons::removeObject(const string& id)
{
    int s=findIcon(id);
    assert(s!=-1);

    remove(s);
    select_icon(s-1);
}

bool     ListOfIcons::checkObjectId(const string& id)
{
    string id2;
    for (int i=0; i<getCount(); ++i) {
	id2=getObjectId(i);
	if (id==id2) return true;
    }
    return false;
}

string   ListOfIcons::getObjectId(int no)
{
    string     *id=(string*)(get_icon_data(no));
    if (id==NULL) return "";
    return (*id);
}


