/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: MessageDialog.cc,v 1.37 2002/08/29 00:34:49 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "fwbuilder/libfwbuilder-config.h"

#include <gtk--/main.h>

#include "main_window.hh"
#include "MessageDialog.hh"
#include "helpers.hh"
#include "PixmapButton.hh"
#include "SimplePixmap.hh"




using namespace libfwbuilder;


MessageDialog::MessageDialog(const string& msg,DlgType t)
{
    string     icn;


    hide();

    running=false;

    result=CANCEL;

    dialog_message->set_text(msg);
    dialog_message->set_justify(GTK_JUSTIFY_LEFT);


/*
 *  button1 : Yes
 *  button2 : No
 *  button3 : OK
 *  button4 : Cancel
 */

    button1->hide();
    button2->hide();
    button3->hide();
    button4->hide();


    PixmapButton::addPixmapAndText( *button1 , "Yes"    , _("Yes")    );
    PixmapButton::addPixmapAndText( *button2 , "No"     , _("No")     );
    PixmapButton::addPixmapAndText( *button3 , "Ok"     , _("OK")     );
    PixmapButton::addPixmapAndText( *button4 , "Cancel" , _("Cancel") );



    switch (t) {
    case QuestionDlg:
	icn = Resources::global_res->getIconPath("Question");
	button1->show();
	button2->show();
	button4->show();

        button1->grab_focus();
	break;

    case YesNoDlg:
	icn = Resources::global_res->getIconPath("Question");
	button1->show();
	button2->show();

        button1->grab_focus();
	break;

    case ErrorDlg:
	icn = Resources::global_res->getIconPath("Error");
	button3->show();

        button3->grab_focus();
	break;

    case LongTextErrorDlg:
    case LongTextInfoDlg:
    {
	packer3->remove(*dialog_message);

	Gtk::ScrolledWindow *sw   = manage(new class Gtk::ScrolledWindow());
	Gtk::Text           *text = manage(new class Gtk::Text());

	text->set_editable(false);
	text->set_word_wrap(false);
	text->set_line_wrap(true);

	text->set_point(0);
	text->insert(msg);

	sw->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	sw->add(*text);
	sw->set_usize(650,300);

	packer3->add(*sw, GTK_SIDE_RIGHT, GTK_ANCHOR_CENTER, GTK_EXPAND|GTK_FILL_X|GTK_FILL_Y, 0, 0, 0, 0, 0);

	text->show();
	sw->show();
	
	if (t==LongTextErrorDlg)
	    icn = Resources::global_res->getIconPath("Error");
	if (t==LongTextInfoDlg)
	    icn = Resources::global_res->getIconPath("Info");

	button3->show();

        button3->grab_focus();
	break;
    }
    case WarningDlg:
	icn = Resources::global_res->getIconPath("Warning");
	button3->show();

        button3->grab_focus();
	break;
    }

//    packer3->remove(*pixmap);
    pixmap=manage( new SimplePixmap(icn) );
    pixmap->set_alignment(0.5, 0.5);
    pixmap->set_padding(0, 0);
    packer3->add(*pixmap, GTK_SIDE_LEFT, GTK_ANCHOR_CENTER, 0);
    pixmap->show();


    delete_event.connect( SigC::slot(this, &MessageDialog::on_delete) );

    show();
#ifdef __MINGW32__
    __fwb_win32_loadIcon("FWBuilderWin32Ico",this);
#endif
}

MessageDialog::DlgReturnValue MessageDialog::run()
{
    running=true;
    set_modal(true);
    Gtk::Main::run();
    set_modal(false);
    running=false;

    return result;
}

gint MessageDialog::on_delete(GdkEventAny* ev)
{
    Gtk::Main::quit();
    return true;  // ignore this event, but break main loop
}


/*
 *  button1 : Yes
 *  button2 : No
 *  button3 : OK
 *  button4 : Cancel
 */
void MessageDialog::on_button1_clicked()
{   
    result=OK_YES;
    Gtk::Main::quit();
}

void MessageDialog::on_button2_clicked()
{   
    result=NO;
    Gtk::Main::quit();
}

void MessageDialog::on_button3_clicked()
{   
    result=OK_YES;
    Gtk::Main::quit();
}

void MessageDialog::on_button4_clicked()
{   
    result=CANCEL;
    Gtk::Main::quit();
}

void MessageDialog::set_transient(Gtk::Widget *w)
{
    if (w!=NULL)
    {
        Gtk::Widget *p=w;
        while (p!=NULL && dynamic_cast<Gtk::Window*>(p)==NULL) 
            p=p->get_parent();
        if (p!=NULL) set_transient_for( *(dynamic_cast<Gtk::Window*>(p)) );
    }
}


void MessageDialog::Error(const string& msg,Gtk::Widget *wnd)
{
    MessageDialog md(msg,ErrorDlg);
    md.set_transient(wnd);
    md.run();
}

void MessageDialog::Error(const string& msg, const string& errcode,Gtk::Widget *wnd)
{
    MessageDialog md( msg + "\n" + errcode , ErrorDlg);
    md.set_transient(wnd);
    md.run();
}

void MessageDialog::LongTextError(const string& msg,Gtk::Widget *wnd)
{
    MessageDialog md(msg,LongTextErrorDlg);
    md.set_transient(wnd);
    md.run();
}

void MessageDialog::LongTextError(const string& msg, const string& errcode,Gtk::Widget *wnd)
{
    MessageDialog md( msg + "\n" + errcode  , LongTextErrorDlg);
    md.set_transient(wnd);
    md.run();
}

void MessageDialog::LongTextInfo(const string& msg,Gtk::Widget *wnd)
{
    MessageDialog md(msg,LongTextInfoDlg);
    md.set_transient(wnd);
    md.run();
}

void MessageDialog::Warning(const string& msg,Gtk::Widget *wnd)
{
    MessageDialog md(msg,WarningDlg);
    md.set_transient(wnd);
    md.run();
}

MessageDialog::DlgReturnValue  MessageDialog::Question(const string& msg,Gtk::Widget *wnd)
{
    DlgReturnValue r;
    MessageDialog md(msg,QuestionDlg);
    md.set_transient(wnd);
    r=md.run();
    return r;
}


MessageDialog::DlgReturnValue  MessageDialog::YesNo(const string& msg,Gtk::Widget *wnd)
{
    DlgReturnValue r;
    MessageDialog md(msg,YesNoDlg);
    md.set_transient(wnd);
    r=md.run();
    return r;
}

