/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NATDialog.cc,v 1.22 2002/11/15 07:20:18 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "fwbuilder/FWObjectDatabase.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/FWOptions.hh"
#include "fwbuilder/NAT.hh"
#include "fwbuilder/Management.hh"

#include "FWObjectDatabaseGUI.hh"
#include "NATDialog.hh"
#include "helpers.hh"

#include "PolicyList.hh"
#include "main_window.hh"


#include <assert.h>

using namespace libfwbuilder;


NATDialog::NATDialog(FWObject *obj)
{
    NAT *pol;

    object=obj;
    dialog_buttons=true;

    FWObject *p =object;
    do {  p=p->getParent(); } while ( p!=NULL && Firewall::cast(p)==NULL );
    assert(p!=NULL);   // fw is a pointer to the firewall object
    fw=Firewall::cast(p);

    tmp_copy=NAT::cast( FWObjectDatabaseGUI::db->create(obj->getTypeName(),true) );
    tmpgrp=new TMPGroupObject();

    bool f=fw->isDirty(true);
    fw->add(tmpgrp,false);   // do not validate 
    tmpgrp->add(tmp_copy);
    if (!f) fw->setDirty(false,true);
    
    natlist_ptr=NULL;

    pol=NAT::cast(tmp_copy);

    natlist_ptr = new NATList(pol);

    /*******************************************************************/


    remove();
/*
    sw= new Gtk::ScrolledWindow();
    sw->set_policy(GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
    add(*sw);
    sw->show();
    sw->add_with_viewport(*natlist_ptr);
*/
    add( *natlist_ptr );
    natlist_ptr->show();

    set_name("nat_dialog");
}

NATDialog::~NATDialog()
{
    bool f=fw->isDirty(true);
    tmpgrp->clearChildren(true);
    fw->remove(tmpgrp,true);
    if (!f) fw->setDirty(false,true);
    
//    sw->hide();
    natlist_ptr->hide();

    delete natlist_ptr;
//    delete sw;
}


void NATDialog::on_policy_line_add()
{
    data_changed_flag(true);
}

void NATDialog::on_policy_line_remove()
{
    data_changed_flag(true);
}

void NATDialog::wrk2dlg()
{
    NAT *pol=NAT::cast(object);
    bool f=pol->isDirty(true);
    *tmp_copy = *pol;
    tmp_copy->setDirty(f,true);
    if (natlist_ptr!=NULL)     natlist_ptr->build();
}

bool NATDialog::dlg2wrk()
{
    NAT *pol=NAT::cast(object);
    if (tmp_copy->isDirty(true))
        *pol = *tmp_copy;
    return(true);
}

/**
 *  enable and disable menu items which make sence only for this object
 */
void NATDialog::updateMainMenu()
{
    Gtk::MenuBar *main_menubar=main_w->getMainMenuBar();
    Gtk::Widget *itm;

    DialogPlugin::updateMainMenu();

    itm=find_widget("policy",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("insert_top",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("append_bottom",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("add_after",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("remove_current",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("move_up",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("move_down",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("rules_druid",main_menubar);
    if (itm) itm->set_sensitive(true);

    itm=find_widget("compile_policy",main_menubar);
    if (itm) itm->set_sensitive(true);

    FWObject *f=object;
    while (Firewall::cast(f)==NULL)
	f=f->getParent();

    Management *mgmt=(Firewall::cast(f))->getManagementObject();
    assert(mgmt!=NULL);
    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    itm=find_widget("install_policy",main_menubar);
    if (itm) itm->set_sensitive( pis->isEnabled() );
}

void NATDialog::conditionalRefresh(FWObject *obj)
{
    if (obj==NULL || object->getId()==obj->getId()) {
        wrk2dlg();
//        natlist_ptr->schedule_rebuild(0);
        data_changed_flag(false);
    }
}

bool NATDialog::isPartOfDialog(libfwbuilder::FWObject *obj)
{
    if (object->getId()==obj->getId()) return true;
    std::set<FWReference*> res=object->findAllReferences(obj);
    return ( ! res.empty() );
}
