/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NewHostDruid.cc,v 1.14 2003/05/02 06:10:55 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "fwbuilder/Interface.hh"
#include "fwbuilder/IPv4.hh"

#include "main_window.hh"

#include "NewHostDruid.hh"
#include "MessageDialog.hh"

#include "NewHostDruidP10Dialog.hh"
#include "NewHostDruidP20Dialog.hh"

#include "FWObjectBook.hh"
#include "FWObjectDatabaseGUI.hh"

#include <gtk--.h>

#include "glademm_support.hh"

#include <iostream>


using namespace libfwbuilder;


enum {
    PAGE_10,
    PAGE_20,
    PAGE_F,
} NewHostDruidPages;


NewHostDruid::NewHostDruid(main_window *mw,
                           const string &t,
                           const string& l): Druid(t,l)
{
    main_w=mw;

    set_default_size(500,450);
    set_position(GTK_WIN_POS_CENTER);

/************************************************************************
 *    Page #10
 */
    p10=manage(new NewHostDruidP10Dialog());
    createStandardPage(PAGE_10,p10);

/************************************************************************
 *    Page #20
 */
    p20=manage(new NewHostDruidP20Dialog());
    createStandardPage(PAGE_20,p20);


/************************************************************************
 *    Final Page 
 */
    createFinishPage(PAGE_F,
 _("Click 'Finish' to create and file new object, click 'Cancel' to discard."));

    glademm_set_Widget("NewHostDruid", this);

    setPage(PAGE_10);
}


void NewHostDruid::on_prepare()
{
    int current_page=get_current_page_id();

    switch (current_page) {
    case -1:
    case PAGE_10:	p10->prepare();	break;
    case PAGE_20:	p20->prepare();	break;
    }
}

gboolean NewHostDruid::on_next()
{
    int current_page=get_current_page_id();

    switch (current_page) {

    case -1:
    case PAGE_10:
        if (p10->obj_name->get_text()=="") return true;
        if (p10->quick_create->get_active())
        {
            try
            {
                checkIPaddress( p10->host_addr->getAsString() );
            } catch(FWException &ex)
            {
                MessageDialog::Error(ex.toString(),this);
                return true;
            }
            setPage(PAGE_F);
        }  else
            setPage(PAGE_20);
	return true;

    case PAGE_20:
        for (int i=0; i<p20->iface_list->getSize(); ++i) 
        {
            InterfaceData idata=p20->iface_list->getInterface(i);
            if ( ! idata.isDyn && ! idata.isUnnumbered)
            {
                try
                {
                    checkIPaddress( idata.address );
                    checkNetmask( idata.netmask );
                } catch(FWException &ex)
                {
                    MessageDialog::Error(ex.toString(),this);
                    return true;
                }
            }
        }
	setPage(PAGE_F);
	return true;
    }

    return true;
}

gboolean NewHostDruid::on_back()
{
    int current_page=get_current_page_id();

    switch (current_page) {

    case PAGE_20:
	setPage(PAGE_10);
	return true;

    case PAGE_F:
        if (p10->quick_create->get_active())  setPage(PAGE_10);
	else setPage(PAGE_20);
	return true;

    }
    return  true;
}

gboolean NewHostDruid::on_cancel()
{
    destroy();
    return true;
}


void NewHostDruid::on_finish()
{
    Host *host=Host::cast( FWObjectDatabaseGUI::newHost() );

    host->setName( p10->obj_name->get_text() );

    if (p10->quick_create->get_active())
    {
        Interface *iface= Interface::cast(FWObjectDatabaseGUI::newInterface(host->getId()));
        iface->setName( "interface1" );

        IPv4 *addr=IPv4::cast( FWObjectDatabaseGUI::newIPv4(iface->getId()) );
        IPAddress address=p10->host_addr->getAsIPAddress();
        iface->setDyn(false);
        iface->setUnnumbered(false);
        addr->setAddress( address );
        addr->setNetmask( "255.255.255.255" );

        if (p10->host_mac->get_text()!="")
        {
            physAddress *pa=physAddress::cast( FWObjectDatabaseGUI::newPhysAddress(iface->getId()) );
            pa->setPhysAddress( p10->host_mac->get_text() );
        }
    } else
    {
        for (int i=0; i<p20->iface_list->getSize(); ++i) 
        {
            InterfaceData idata=p20->iface_list->getInterface(i);

            Interface *iface= Interface::cast(FWObjectDatabaseGUI::newInterface(host->getId()));
            iface->setName( idata.name );
            iface->setDyn(idata.isDyn);
            iface->setUnnumbered(idata.isUnnumbered);

            if ( ! idata.isDyn && ! idata.isUnnumbered)
            {
                IPv4 *addr=IPv4::cast( FWObjectDatabaseGUI::newIPv4(iface->getId()) );
                addr->setAddress( idata.address );
                addr->setNetmask( idata.netmask );

                if (p10->host_mac->get_text()!="")
                {
                    physAddress *pa=physAddress::cast( FWObjectDatabaseGUI::newPhysAddress(iface->getId()) );
                    pa->setPhysAddress( p10->host_mac->get_text() );
                }
            }
        }
    }

    try
    {
        main_window::insertInAllObjectBooks(host);

//        main_window::changeLabelInAllObjectBooks(host->getId());
        FWObjectBook *w=main_w->getObjectBook();
        if (w!=NULL)  w->showObject( host->getId() );
        main_window::conditionalRefreshAllDialogs(host);
    } catch (FWException &ex)
    {
        cerr << ex.toString();
    }

    destroy();
}

