/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: NewHostDruidP20Dialog.cc,v 1.6 2003/09/22 05:12:40 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"

#include "NewHostDruidP20Dialog.hh"
#include "FWObjectDatabaseGUI.hh"
#include "InterfaceListWidget.hh"
#include "InterfaceData.hh"

using namespace libfwbuilder;

NewHostDruidP20Dialog::NewHostDruidP20Dialog() 
{
    iface_list->select_row.connect(SigC::slot(this, 
                 &NewHostDruidP20Dialog::on_iface_list_select_row));

    iface_list->set_show_label(false);
    iface_list->set_show_ext(false);

//    iface_addr->setAssociatedNetmaskWidget(iface_netmask);
}

void NewHostDruidP20Dialog::prepare()
{
    iface_name->grab_focus();
}

void NewHostDruidP20Dialog::fillData(InterfaceData &idata)
{
    idata.name=iface_name->get_text();
    idata.isUnnumbered=iface_unnum->get_active();
    idata.isDyn=iface_dyn->get_active();

    if (!idata.isUnnumbered && !idata.isDyn)
    {
        idata.address=iface_addr->getAsString();
        idata.netmask=iface_netmask->getAsString();
    }
    idata.physicalAddress=iface_physaddr->get_text();
}

void NewHostDruidP20Dialog::on_add_clicked()
{  
    if (iface_name->get_text()=="") return;

    InterfaceData idata;
    idata.id   =FWObjectDatabaseGUI::db->generateUniqueId();
    fillData(idata);
    iface_list->addInterface(idata);
}

void NewHostDruidP20Dialog::on_update_clicked()
{  
    string id=iface_list->getSelectedInterfaceId();
    int    row=iface_list->getRowById(id);
    InterfaceData idata;
    fillData(idata);
    iface_list->updateInterface(row,idata);
}

void NewHostDruidP20Dialog::on_delete_clicked()
{  
    iface_list->removeInterface( iface_list->getSelectedInterfaceId() );
}

void NewHostDruidP20Dialog::on_iface_dyn_toggled()
{  
    if (iface_dyn->get_active())
    {
        iface_addr->clear();
        iface_netmask->clear();
        iface_addr->set_sensitive(false);
        iface_netmask->set_sensitive(false);
    } else
    {
        iface_addr->set_sensitive(true);
        iface_netmask->set_sensitive(true);
    } 
}

void NewHostDruidP20Dialog::on_iface_unnum_toggled()
{  
    if (iface_unnum->get_active())
    {
        iface_dyn->set_active(false);
        iface_addr->clear();
        iface_netmask->clear();
        iface_dyn->set_sensitive(false);
        iface_addr->set_sensitive(false);
        iface_netmask->set_sensitive(false);
    } else
    {
        iface_dyn->set_sensitive(true);
        iface_addr->set_sensitive(true);
        iface_netmask->set_sensitive(true);
    } 
}

void NewHostDruidP20Dialog::on_iface_list_select_row(gint row, 
                                           gint column, 
                                           GdkEvent *event)
{   
    InterfaceData idata=iface_list->getInterface(row);

    if (idata.name!="")
    {
        iface_name->set_text(idata.name);
        iface_unnum->set_active(idata.isUnnumbered);
        iface_dyn->set_active(idata.isDyn);
        if (!idata.isUnnumbered && !idata.isDyn)
        {
            iface_addr->setAddress(idata.address);
            iface_netmask->setAddress(idata.netmask);
        }
        iface_physaddr->set_text( idata.physicalAddress );
    }
}
