/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ObjectQuickView.hh,v 1.11 2003/11/13 06:20:34 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _OBJECTQUICKVIEW_HH
#define _OBJECTQUICKVIEW_HH

#include "config.h"

#include <gtk--.h>
#include <list>

#include "fwbuilder/FWObject.hh"

class main_window;

class ObjectQuickView : public Gtk::Window
{   

    main_window *main_w;

    struct singleLine {
	string name;
	string val;
    } ;

    void fillObjectQuickViewText( libfwbuilder::FWObject *o);

    list<ObjectQuickView::singleLine> strings;
    string                            onestring;

    int     border;
    int     spacing;
    int     x,y,width,height, sw1, sw2, sh;
    bool    active;
    Gtk::Widget     *widget;

    Gtk::Connection  quick_view_timer_conn;
    bool             quick_view_timer_connected;
    bool             quick_view_shown_in_status_bar;

    gint timer_callback();

    virtual void draw_impl (GdkRectangle* p0);
    virtual gint expose_event_impl(GdkEventExpose* p0);

    virtual void paint(GdkRectangle* p0);

    void on_size_request(GtkRequisition*);
    void on_size_allocate(GtkAllocation* ga);

    string getSinglelineToolTip(libfwbuilder::FWObject *o);


    public:

    ObjectQuickView(main_window *mw);
    ~ObjectQuickView();

    void   setObject(libfwbuilder::FWObject *obj);
    void   setObjectById(const string &id);
    void   setText(const string &txt);

    string getTextAsString();

    void   attachTo(Gtk::Widget *w);
    void   activate();
    void   deactivate();


    static ObjectQuickView *instance;
    static ObjectQuickView* getInstance(main_window *mw);

};
#endif








