/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: ObjectTree.hh,v 1.35 2002/12/01 00:03:44 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _ObjectTree_HH
#  define _ObjectTree_HH

#include <gtk--.h>

#include "fwbuilder/FWObject.hh"
#include "helpers.hh"

class main_window;
class FWObjectBook;

class ObjectData
{
    public:

    string     id;
    string     name;
    string     type_name;
    GdkPixmap *pm;
    GdkBitmap *bm;

    ObjectData(libfwbuilder::FWObject *obj)
    {
        id=obj->getId();
        name=obj->getName();
        type_name=obj->getTypeName();
        pm=NULL;
        bm=NULL;
    }

    ObjectData(const string &_id,
               const string &_name,
               const string &_type_name,
               GdkPixmap *_pm,
               GdkBitmap *_bm   )
    {
        id=_id;
        name=_name;
        type_name=_type_name;
        pm=_pm;
        bm=_bm;
    }
};

class ObjectTree : public Gtk::CTree
{   

    friend class main_window;
    friend class FWObjectBook;

    main_window *main_w;

/* ignore showInTree flag */
    bool show_all;
    bool rebuild_scheduled;
    bool show_properties;

// all these store ID
    string           selected_object;    
    string           last_clicked_object;
    string           drag_object;
    string           show_object;

//name of the library
    string           lib;

    gint on_button_press_event(GdkEventButton *ev);
    gint on_button_release_event(GdkEventButton *ev);

    void source_drag_begin( GdkDragContext     *context);
    void source_drag_data_get  ( GdkDragContext     *context,
				 GtkSelectionData   *selection_data,
				 guint               info,
				 guint32             time );
    void source_drag_data_delete ( GdkDragContext     *context );

    gint on_key_press_event(GdkEventKey *ev);

    bool processing_selection; // to avoid unwanted recursion
    void selection_made(Gtk::CTree::Row r,gint row);

    gint rebuild_when_idle();
    gint rebuild_and_show_when_idle();
    
    Gtk::CTree_Helpers::RowList::iterator _insert_row(
	Gtk::CTree_Helpers::RowList          &rl,
	Gtk::CTree_Helpers::RowList::iterator i,
	const string &lbl,
	const string &id,
        const string &type_name,
	const string &internals,
        const string &icn_filename);


    void selectRow(gint row_n);
    void TreePopupMenu();

    void insertSubtree(Gtk::CTree_Helpers::RowList::iterator &j, 
		       libfwbuilder::FWObject *o);

    void rebuildTree();
    void rebuildTreeAndShow(const string &id);
    void selectObject(const string &id);
    void selectObject(libfwbuilder::FWObject *obj);

    void constructor();

    Gtk::CTree_Helpers::Row expand_to_row(const string &id);

public:

    ObjectTree(main_window *mw,const string &lib);

    void   scheduleRebuild();

    string getCurrentSelection();
    string getCurrentLibrary();

    void   insertObject( const string &id );
    void   insertObject( libfwbuilder::FWObject *o );

    void   removeObject( const string &id );
    void   removeObject( libfwbuilder::FWObject *o );

    void   changeTreeLabel(const string &id);

    static string get_tree_label(const libfwbuilder::FWObject *o);
    static string get_properties(const libfwbuilder::FWObject *o);

/**
 *  This method shows object with given ID in the tree. Do not confuse
 *  with method of class main_window which opens appropriate dialog to
 *  edit the object 
 */
    void   showObject(const string &id);
    void   showObject(libfwbuilder::FWObject *o);

    void   sortSubtree(const string &id, int col=0);
    void   sortSubtree(libfwbuilder::FWObject *o, int col=0);


    void   clearSelection();

    string   getNextId();
    string   getPrevId();
    string   getParentId();
};

#endif
