/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: OptionsDlg.hh,v 1.13 2002/09/04 22:10:46 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _OPTIONSDLG_HH
#  include "OptionsDlg_glade.hh"
#  define _OPTIONSDLG_HH

#include "config.h"

#include "glademm_support.hh"

/*
 *  workaround for the bug in glademm
 */
#define GTK_FILLX GTK_FILL_X
#define GTK_FILLY GTK_FILL_Y



class OptionsDlg : public OptionsDlg_glade
{   
        
    friend class OptionsDlg_glade;
    void on_ok_clicked();
    void on_cancel_clicked();
    void on_ctree_select_row(gint row, gint column, GdkEvent *event);
    void on_path_browse_clicked();

    void on_generate_cert_clicked();
    void on_import_cert_clicked();
    void on_export_cert_clicked();
    void on_remove_cert_clicked();

    void on_export_public_key_clicked();

    gint on_delete_event(GdkEventAny* ev);

    bool  commit_changes;

/* maps row labels in the tree to the notebook pages */
    map<string,unsigned>   notebook_pages;

    Gtk::CTree_Helpers::RowList::iterator  addTreeRow(Gtk::CTree_Helpers::RowList &r,const string &lbl);
    Gtk::CTree_Helpers::RowList::iterator  addTreeRow(Gtk::CTree_Helpers::RowList &r,const string &lbl, unsigned notebook_page_number);

    void fillListOfCertificates();

public:
    OptionsDlg();
    virtual ~OptionsDlg();
    bool run();

};
#endif





