/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: SimpleProgressDialog.hh,v 1.5 2003/03/04 05:40:05 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _SIMPLEPROGRESSDIALOG_HH
#  include "SimpleProgressDialog_glade.hh"
#  define _SIMPLEPROGRESSDIALOG_HH
#include "glademm_support.hh"

#include "config.h"

class SimpleProgressDialog : public SimpleProgressDialog_glade
{   
        
    friend class SimpleProgressDialog_glade;

    public:

    SimpleProgressDialog();

    void setStyle(GtkProgressBarStyle style) { progressbar->set_bar_style(style); }
    void setDiscreteBlocks(int blocks)       { progressbar->set_discrete_blocks(blocks); }

    void setActivityMode(bool mode)          { progressbar->set_activity_mode(mode); }
    void setActivityStep(int step)           { progressbar->set_activity_step(step); }
    void setActivityBlocks(int blocks)       { progressbar->set_activity_blocks(blocks); }

    void setTitle(const string &t);
    void setText(const string &t);

    void setProgressBarRange(gfloat min,gfloat max);
    void setProgressBarValue(gfloat val);

};
#endif
