/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: StandardRulesDruid.cc,v 1.48 2003/03/21 07:07:13 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"

#include "glademm_support.hh"

#include "StandardRulesDruid.hh"
#include "FWObjectDatabaseGUI.hh"
#include "BuiltinDialog.hh"
#include "PolicyList.hh"
#include "SimplePixmap.hh"

#include "fwbuilder/Interface.hh"
#include "fwbuilder/Host.hh"
#include "fwbuilder/Firewall.hh"
#include "fwbuilder/Policy.hh"
#include "fwbuilder/InterfacePolicy.hh"
#include "fwbuilder/NAT.hh"
#include "fwbuilder/Rule.hh"
#include "fwbuilder/RuleElement.hh"

#include "main_window.hh"
#include "helpers.hh"

using namespace libfwbuilder;

enum {
    PAGE_S,
    PAGE_05,
    PAGE_10,
    PAGE_11,
    PAGE_12,
    PAGE_20,
    PAGE_30,
    PAGE_40,
    PAGE_44,
    PAGE_47,
    PAGE_49,
    PAGE_F
} DruidPages;

/*
     The structure of Druid pages:


               30   ---------------------> 35 ----------+
            /(host rules)                 (objects       \
           /                           not implemented )  \
          /                                                \
 S --> 10 ---> 11   --------> 12  -------> 20  ------------>  F
          \  (interfaces)   (rules)       (objects)        /
           \                                              /
            \                                            /
               40   --------> 44  -------> 47  -----> 49
          (DMZ-NAT)         (interfaces)  (rules)    (objects)
 */

void StandardRulesDruid::_fillClistObjects(Gtk::CList &clist,
					   vector<FWObject*> &lst)
{
    int       row;
    vector<FWObject*>::iterator m;
    FWObject *o;
    const char *crow[]={ "" , NULL };

    for (row=0,m=lst.begin(); m!=lst.end(); ++m) 
    {
	if ((*m)!=NULL) 
        {
	    o=(FWObject*)(*m);

	    clist.append_row(crow);

	    Gtk::Pixmap *pixmap=manage( new SimplePixmap( Resources::getIconFileName(o) ));
	    Gdk_Pixmap pm;
	    Gdk_Bitmap bm;
	    pixmap->get(pm,bm);

	    clist.set_pixtext(row,0,o->getName(),0, pm,bm);
	    clist.set_row_data(row,(gpointer)(o));

	    row++;
	}
    }
    clist.show();
}


void StandardRulesDruid::_fillClistInterfaces(Gtk::CList &clist,
					      Firewall *fw_object,
					      int  only_ext)
{
    int       row=0;
    list<FWObject*>::iterator m;
    Interface *intf;
    string    s;
    const char *crow[]={ "" , NULL };

    clist.set_row_height(20);
    clist.set_column_justification(0,GTK_JUSTIFY_LEFT);

    for (row=0,m=fw_object->begin(); m!=fw_object->end(); ++m) 
    {

	if ( Interface::isA( (*m) ) ) {
	    intf=Interface::cast(*m);
	    if (! only_ext || intf->isExt()) {
		s= string(intf->getName())+" ("+intf->getAddress().toString()+") ";

		clist.append_row(crow);
		clist.set_text(row,0,s);
		clist.set_row_data(row, (gpointer)(intf) );

		row++;
	    }
	}
    }
    clist.show();
}


StandardRulesDruid::StandardRulesDruid(const string &obj_id,
				       const string &t,
				       const string& l) : Druid(t,l)
{    
    string          s;
    FWObject   **stptr;

    vector<FWObject*> obj_lst;
    FWObject  *o;
    FWObject  *tree;

    FWObject *subtrees[]={
//	FWObjectDatabase::db->getById( 
//	    FWObjectDatabaseGUI::getFirewallsId(), true),
	FWObjectDatabase::db->getById( 
	    FWObjectDatabaseGUI::getHostsId(),true),
	FWObjectDatabase::db->getById( 
	    FWObjectDatabaseGUI::getNetworksId(),true),
	FWObjectDatabase::db->getById( 
	    FWObjectDatabaseGUI::getObjectGroupsId(),true),
	NULL
    };

    for (stptr=subtrees; *stptr; stptr++) 
    {
	tree= *stptr;
	if (tree) 
        {
	    for(list<FWObject*>::iterator m=tree->begin(); m!=tree->end(); ++m) 
            {
		if ((*m)!=NULL) {
		    o=(FWObject*)(*m);
		    obj_lst.push_back(o);
		}
	    }
	}
    }

    

    set_position(GTK_WIN_POS_CENTER);


    fw_id=obj_id;
    fw_object=FWObjectDatabaseGUI::db->getById( fw_id , true );


    set_default_size(600,400);

/************************************************************************
 *    Start Page 
 */

    createStartPage(PAGE_S, "\n\
This druid will help you build basic policy for your firewall. \n\
It will walk you through the series of questions, collecting all \n\
information it needs to generate policy.\n\
\n\
In order to use this druid you should have created objects for your\n\
firewall and networks or hosts behind it.  If unsure, try to collect\n\
information about your network using tools available through menu\n\
'Tools' - 'Scan Network'. These tools will help you create objects for\n\
your subnets and hosts.\n\
\n\
Click 'Next' to start");

/************************************************************************
 *    Page #10
 */

    p10=new ASDruidP10Dialog();
    createStandardPage(PAGE_10,p10);

/************************************************************************
 *    Page #11
 */

    p11=new ASDruidP11Dialog();
    createStandardPage(PAGE_11,p11);

    p11->if_list->set_row_height(20);
    p11->if_list->set_column_justification(0,GTK_JUSTIFY_LEFT);

    _fillClistInterfaces( *(p11->if_list) , (Firewall*)fw_object , 1 );


/************************************************************************
 *    Page #12
 */

    p12=new ASDruidP12Dialog();
    createStandardPage(PAGE_12,p12);

/************************************************************************
 *    Page #20
 */

    p20=new ASDruidP20Dialog();
    createStandardPage(PAGE_20,p20);

    p20->internal_networks->set_row_height(28);
    p20->internal_networks->set_column_justification(0,GTK_JUSTIFY_LEFT);

    _fillClistObjects( *(p20->internal_networks) , obj_lst);


/************************************************************************
 *    Page #30
 */

    p30=new ASDruidP30Dialog();
    createStandardPage(PAGE_30,p30);


/************************************************************************
 *    Page #40
 */

    p40=new ASDruidP40Dialog();
    createStandardPage(PAGE_40,p40);


/************************************************************************
 *    Page #44
 */

    p44=new ASDruidP44Dialog();
    createStandardPage(PAGE_44,p44);

    _fillClistInterfaces( *(p44->external_if_list) , (Firewall*)fw_object , 1);
    _fillClistInterfaces( *(p44->dmz_if_list) , (Firewall*)fw_object , 0 );


/************************************************************************
 *    Page #47
 */

    p47=new ASDruidP47Dialog();
    createStandardPage(PAGE_47,p47);


/************************************************************************
 *    Page #49
 */

    p49=new ASDruidP49Dialog();
    createStandardPage(PAGE_49,p49);

    p49->internal_net->set_row_height(28);
    p49->internal_net->set_column_justification(0,GTK_JUSTIFY_LEFT);

    p49->dmz_net->set_row_height(28);
    p49->dmz_net->set_column_justification(0,GTK_JUSTIFY_LEFT);

    _fillClistObjects( *(p49->internal_net) , obj_lst);
    _fillClistObjects( *(p49->dmz_net) , obj_lst);




/************************************************************************
 *    Page #3
 */
 
    createFinishPage(PAGE_F,

		     _("Click 'Finish' to generate standard protection rules"));


}

gboolean StandardRulesDruid::on_next()
{
    int current_page=get_current_page_id();
    int next_page=PAGE_S;
    int	aspoof_in;
    int aspoof_out;
    int short_frags;
    int catch_all;
    int masquerading;

    if (current_page==PAGE_S)	{
	next_page=PAGE_10;
	setPage(next_page);
	return true;   // has to return true so Druid itself won't follow page list
    }


    if (p10->protect_host->get_active()) {   // protect HOST

	switch ( current_page ) {

	case PAGE_10:
	    next_page=PAGE_30;
	    break;

	case PAGE_30:
	    next_page=PAGE_F;
	    break;
	}

    }

    if (p10->protect_one_net->get_active()) {   // protect NET

	switch ( current_page ) {

	case PAGE_10:
	    next_page=PAGE_11;
	    break;

	case PAGE_11:
	    if ( p11->if_list->selection().empty() ) return true;
	    next_page=PAGE_12;
	    break;

	case PAGE_12:
	    aspoof_in =p12->anti_spoof_in->get_active();
	    aspoof_out=p12->anti_spoof_out->get_active();
	    short_frags=p12->short_fragments->get_active();
	    catch_all=p12->catch_all->get_active();
	    masquerading=p12->masquerading->get_active();

	    if (aspoof_in || aspoof_out || masquerading )
		next_page=PAGE_20;
	    else
		next_page=PAGE_F;
	    break;

	case PAGE_20:
	    if (_checkObjectsList(p20->internal_networks) )
		next_page=PAGE_F;
	    else
		next_page=PAGE_20;
	    break;
	}

    }

    if (p10->protect_net_and_dmz->get_active()) {   // protect NET and DMZ

	switch ( current_page ) {

	case PAGE_10:
	    next_page=PAGE_40;
	    break;

	case PAGE_40:
	    next_page=PAGE_44;
	    break;

	case PAGE_44:
	    if ( p44->external_if_list->selection().empty() ) return true;
	    if ( p44->dmz_if_list->selection().empty() )      return true;
	    next_page=PAGE_47;
	    break;

	case PAGE_47:
	    aspoof_in =p47->anti_spoof_in->get_active();
	    aspoof_out=p47->anti_spoof_out->get_active();
	    short_frags=p47->short_fragments->get_active();
	    catch_all=p47->catch_all->get_active();
	    masquerading=p47->masquerading->get_active();

	    if (aspoof_in || aspoof_out || masquerading )
		next_page=PAGE_49;
	    else
		next_page=PAGE_F;
	    break;

	case PAGE_49:
	    if (_checkObjectsList(p49->internal_net) && 
		_checkObjectsList(p49->dmz_net) )
		next_page=PAGE_F;
	    else
		next_page=PAGE_49;
	    break;
	    break;
	}


    }

    setPage(next_page);
    return true;   // has to return true so Druid itself won't follow page list
}

gboolean StandardRulesDruid::on_back()
{
    int current_page=get_current_page_id();
    int back_page=PAGE_S;

    if (current_page==PAGE_10)	{
	back_page=PAGE_S;
	setPage(back_page);
	return true;   // has to return true so Druid itself won't follow page list
    }

    if (p10->protect_host->get_active()) {   // protect HOST

	switch ( current_page ) {

	case PAGE_30:
	    back_page=PAGE_10;
	    break;

	case PAGE_F:
	    back_page=PAGE_30;
	    break;
	}
    }

    if (p10->protect_one_net->get_active()) {   // protect NET
 
	switch ( current_page ) {

	case PAGE_11:
	    back_page=PAGE_10;
	    break;

	case PAGE_12:
	    back_page=PAGE_11;
	    break;

	case PAGE_20:
	    back_page=PAGE_12;
	    break;

	case PAGE_F:
            back_page=PAGE_12;
	    break;
	}
    }

    if (p10->protect_net_and_dmz->get_active()) {   // protect NET and DMZ
 
	switch ( current_page ) {

	case PAGE_40:
	    back_page=PAGE_10;
	    break;

	case PAGE_44:
	    back_page=PAGE_40;
	    break;

	case PAGE_47:
	    back_page=PAGE_44;
	    break;

	case PAGE_49:
	    back_page=PAGE_47;
	    break;

	case PAGE_F:
            back_page=PAGE_47;
	    break;
	}
    }

    setPage(back_page);
    return true;   // has to return true so Druid itself won't follow page list
}

gboolean StandardRulesDruid::on_cancel()
{
    destroy();
    return true;
}


void StandardRulesDruid::on_finish()
{

    if (p10->protect_host->get_active())    // protect HOST
	generateRulesForHostProtection();

    if (p10->protect_one_net->get_active())    // protect NET
	generateRulesForNetProtection();

    if (p10->protect_net_and_dmz->get_active())    // protect NET and DMZ
	generateRulesForNetAndDMZProtection();

    main_window::refreshAllWindows();

    destroy();
}

