/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TableOfObjects.cc,v 1.12 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "TableOfObjects.hh"
#include "MessageDialog.hh"

#include <regex.h>


static char* titles[] = { _("Use"), _("Name"), _("Address"), NULL };





using namespace libfwbuilder;

// TableOfObjects::TableOfObjects(gint rows) :
//    Gtk::Table(nrows=(rows+1)*2, ncols=(sizeof(titles)/sizeof(char*)-1)*2 )

TableOfObjects::TableOfObjects(int rows) : Gtk::Table(nrows=(rows+1)*2,1)
{
    ncols=0;
    using_combo=false;

    for (int i=0; titles[i]!=NULL; i++)
	addColumn(titles[i]);
}

void TableOfObjects::on_changed()
{

    changed();   // calling my own signal here
}

int TableOfObjects::addColumn(const string& title)
{

    Gtk::Button *btn=new Gtk::Button( title );
    attach( *btn, ncols, ncols+1, 0, 1, GTK_FILL, 0,0,1);
    btn->show();

    Gtk::VSeparator *sep= new Gtk::VSeparator();
    attach( *sep , ncols+1 , ncols+2 , 0 , nrows , 0, GTK_FILL, 0, 0);

    ncols+=2;

    return ncols-2;
}

void TableOfObjects::clear()
{
    v_c.clear();
    v_e.clear();
    v_od.clear();
}

void TableOfObjects::addObject(int row , const string& obj_id, 
			       const string& name , 
			       const string& address,
			       const ObjectDescriptor *od)
{
    int  col=0;
    int  real_row = (row+1)*2;

    v_od[obj_id]=od;

    Gtk::CheckButton *chk=manage(new Gtk::CheckButton());
    attach( *chk, col, col+1, real_row, real_row+1, GTK_FILL, 0,0,1);
    v_c[obj_id]=chk;
    chk->show();
    chk->toggled.connect(SigC::slot(this, &TableOfObjects::on_changed));
    col+=2;

    using_combo=false;
    Gtk::Entry *ent=manage(new Gtk::Entry(80));
    ent->set_text(name);
    attach( *ent, col, col+1, real_row, real_row+1, GTK_FILL|GTK_EXPAND,0,2,1);
    v_e[obj_id]=ent;
    ent->show();
    col+=2;
	
    Gtk::Label *lbl=manage(new Gtk::Label(address,0.0));
    attach( *lbl, col, col+1, real_row, real_row+1, GTK_FILL|GTK_EXPAND,0,2,1);
    v_l[obj_id]=lbl;
    lbl->show();
    col+=2;

    Gtk::HSeparator *sep= new Gtk::HSeparator();
    attach( *sep , 0 , ncols , real_row+1 , real_row+2 ,GTK_FILL,GTK_FILL, 0, 0);
    v_s[obj_id]=sep;
    sep->show();
}


void TableOfObjects::addObject(int row , const string& obj_id, 
			       set<string> names , 
			       const string& address,
			       const ObjectDescriptor *od)
{
    int  col=0;
    int  real_row = (row+1)*2;

    v_od[obj_id]=od;

    Gtk::CheckButton *chk=manage(new Gtk::CheckButton());
    attach( *chk, col, col+1, real_row, real_row+1, GTK_FILL, 0,0,1);
    v_c[obj_id]=chk;
    chk->show();
    chk->toggled.connect(SigC::slot(this, &TableOfObjects::on_changed));
    col+=2;

    using_combo=true;
    Gtk::Combo *ent=manage(new Gtk::Combo());
    ent->set_popdown_strings(names);
    ent->get_entry()->set_position(0);
    attach( *ent, col, col+1, real_row, real_row+1, GTK_FILL|GTK_EXPAND,0,2,1);
    v_e[obj_id]=ent;
    ent->show();
    col+=2;
	
    Gtk::Label *lbl=manage(new Gtk::Label(address,0.0));
    attach( *lbl, col, col+1, real_row, real_row+1, GTK_FILL|GTK_EXPAND,0,2,1);
    v_l[obj_id]=lbl;
    lbl->show();
    col+=2;

    Gtk::HSeparator *sep= new Gtk::HSeparator();
    attach( *sep , 0 , ncols , real_row+1 , real_row+2 ,GTK_FILL,GTK_FILL, 0, 0);
    v_s[obj_id]=sep;
    sep->show();
}

void   TableOfObjects::filterByObjId(const string& obj_id,bool on)
{
    if (on) {
	v_c[obj_id]->show();
	v_e[obj_id]->show();
	v_l[obj_id]->show();
	v_s[obj_id]->show();
    } else {
	v_c[obj_id]->hide();
	v_e[obj_id]->hide();
	v_l[obj_id]->hide();
	v_s[obj_id]->hide();
    }
}

void   TableOfObjects::filter(const string& addr,const string& name)
{
    address_filter = addr;
    name_filter    = name;

    filter_active = ! addr.empty() || ! name.empty();

    try {
	map<string,Gtk::Label*>::iterator i;
	for (i=v_l.begin(); i!=v_l.end(); ++i) {
	    string      obj_id = (*i).first;
	    Gtk::Label *lbl    = (*i).second;
	    string      a      = lbl->get_text();

	    if ( ! filter_active ) {  /* remove filter, unhide all rows */
		filterByObjId(obj_id,true);
	    } else {
		string n=getObjectName(obj_id);

		bool b=
		    ( addr.empty() || applyAddressFilter(a,addr) ) &&
		    ( name.empty() || applyNameFilter(n,name));

		filterByObjId(obj_id , b );
		
	    }
	}
    } catch(const FWException &ex) 
    {
	MessageDialog::Error(ex.toString());
    }
}

/*
 *  applies address filter a_filter to string a1. Returns true if
 *  filter pattern has been found in a1, false otherwise
 */
bool TableOfObjects::applyAddressFilter(const string& a1,const string& a_filter) throw(FWException)
{
    return (a1.find(a_filter)==0);
}

bool TableOfObjects::applyNameFilter(const string& name,const string& n_filter) throw(FWException)
{
    regex_t preg;
    char    errstr[256];

    try {
	int     err;
	if ((err=regcomp(&preg, n_filter.c_str(), REG_ICASE|REG_NOSUB|REG_EXTENDED))!=0) 
	    throw(err);

	err=regexec(&preg, name.c_str(), 0, NULL, 0 );
	if (err!=0 && err!=REG_NOMATCH) throw(err);

	regfree(&preg);
	return (err==0);

    } catch (int err) {
	regerror(err,&preg,errstr,sizeof(errstr));
	regfree(&preg);

	throw( FWException(errstr) );
    }

    return false;
}

bool   TableOfObjects::isObjectChecked(const string& obj_id)
{
    Gtk::CheckButton *btn = v_c[obj_id];
    if (btn)
	return btn->get_active();
    else 
	return false;
}

string TableOfObjects::getObjectName(const string& obj_id)
{
    Gtk::Entry *ent;
    if (using_combo) {
	Gtk::Combo *cmb = (Gtk::Combo*)(v_e[obj_id]);
	if (cmb==NULL) return "";
	ent = cmb->get_entry();
    } else {
	ent = (Gtk::Entry*)(v_e[obj_id]);
	if (ent==NULL) return "";
    }

    return ent->get_text();
}

const ObjectDescriptor* TableOfObjects::getDescriptor(const string& obj_id)
{
    return v_od[obj_id];
}

void   TableOfObjects::selectAll()
{
    map<string,Gtk::CheckButton*>::iterator c;
    for (c=v_c.begin();  c!=v_c.end(); ++c) 
	(*c).second->set_active(true);
}

void   TableOfObjects::unselectAll()
{
    map<string,Gtk::CheckButton*>::iterator c;
    for (c=v_c.begin();  c!=v_c.end(); ++c) 
	(*c).second->set_active(false);
}

int    TableOfObjects::getNumOfSelected()
{
    int r=0;

    map<string,Gtk::CheckButton*>::iterator c;
    for (c=v_c.begin();  c!=v_c.end(); ++c) 
	if ( (*c).second->get_active() ) r++;

    return r;
}
