/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TableOfObjectsWithTypeChoice.cc,v 1.8 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "TableOfObjectsWithTypeChoice.hh"


using namespace libfwbuilder;

TableOfObjectsWithTypeChoice::TableOfObjectsWithTypeChoice(int rows) :
    TableOfObjects(rows)
{

    my_col=addColumn(_("Object Type"));


}


void TableOfObjectsWithTypeChoice::addTypeChoice(const string& _type)
{
    type_choices.push_back(_type);
}

void TableOfObjectsWithTypeChoice::addTypeChoices(vector<string> _types)
{
    type_choices=_types;
}

void TableOfObjectsWithTypeChoice::addObject(int row,
					     const string& obj_id,
					     set<string> name,
					     const string& address,
					     const ObjectDescriptor* od)
{
    int  real_row = (row+1)*2;

    TableOfObjects::addObject(row,obj_id,name,address,od);

    Gtk::OptionMenu *opt=_add_option_menu();
    attach( *opt, my_col, my_col+1, real_row, real_row+1, GTK_FILL, 0,0,1);
    v_g[obj_id]=opt;
    opt->show();

}

Gtk::OptionMenu* TableOfObjectsWithTypeChoice::_add_option_menu()
{
    Gtk::OptionMenu *optionmenu1 = manage(new class Gtk::OptionMenu());
    optionmenu1->set_border_width(2);

    Gtk::Menu *_m(manage(new Gtk::Menu()));
    Gtk::MenuItem *_mi;

    vector<string>::iterator  i;

    for (i=type_choices.begin(); i!=type_choices.end(); i++) {
	_mi = manage(new Gtk::MenuItem( (*i) ));
	_m->append(*_mi);
	_mi->show();
	_mi->set_user_data((gpointer)&(*i));
    }

    _m->set_active(0);

    optionmenu1->set_menu(*_m);

    return optionmenu1;
}

void  TableOfObjectsWithTypeChoice::filterByObjId(const string& obj_id,bool on)
{
    TableOfObjects::filterByObjId(obj_id,on);

    if (on) v_g[obj_id]->show();
    else    v_g[obj_id]->hide();
}

string TableOfObjectsWithTypeChoice::getTypeChoice(const string& obj_id)
{
    Gtk::Menu     *m;
    Gtk::MenuItem *mi;
    string        *type;

    m=v_g[obj_id]->get_menu();
    mi=m->get_active();
    type= (string*)mi->get_user_data();

    return *type;
}

