/* 

                          Firewall Builder

                 Copyright (C) 2001 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TableOfObjectsWithTypeChoice.hh,v 1.7 2002/08/29 00:34:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef TABLEOFOBJECTSWITHTYPE_HH
#define TABLEOFOBJECTSWITHTYPE_HH

#include "config.h"

#include "TableOfObjects.hh"

#include <string>
#include <vector>
#include <set>

class ObjectDescriptor;
class TableOfObjectsWithTypeChoice : public TableOfObjects {

    map<string,Gtk::OptionMenu*>   v_g;
    vector<string>                 type_choices;
    int                            my_col;

    Gtk::OptionMenu* _add_option_menu();

    protected:

    virtual  void   filterByObjId(const string& obj_id, bool on);

    public:

    TableOfObjectsWithTypeChoice(int rows);

    void addTypeChoice(const string& _type);
    void addTypeChoices(vector<string> _types);

    virtual void addObject(int row,const string& obj_id,
			   set<string> names, 
			   const string& address,
			   const ObjectDescriptor *od=NULL);

    string getTypeChoice(const string& obj_id);
};



#endif
