/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: TargetDialog_linux24.cc,v 1.10 2002/12/28 04:58:10 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "TargetDialog_linux24.hh"
#include "fwbuilder/Resources.hh"

#include "fwbuilder/Firewall.hh"

#include <assert.h>

using namespace libfwbuilder;

DialogPlugin* create_dialog_linux24(FWObject *o)
{
    return new TargetDialog_linux24(o);
}


TargetDialog_linux24::TargetDialog_linux24(FWObject *obj) 
{ 
    object=obj;

    fwoptions=(Firewall::cast(object))->getOptionsObject();
    assert(fwoptions!=NULL);

    network_tab_txt2->set_line_wrap(true);

    map<string,string>        on_off_menu;
    on_off_menu["1"]=_("On");
    on_off_menu["0"]=_("Off");
    on_off_menu[DialogPlugin::magic_empty_option]=_("No change");



    linux24_ip_forward->set_menu(on_off_menu);
    linux24_ip_forward->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_ip_forward->show_all();

    linux24_rp_filter->set_menu(on_off_menu);
    linux24_rp_filter->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_rp_filter->show_all();

    linux24_icmp_echo_ignore_broadcasts->set_menu(on_off_menu);
    linux24_icmp_echo_ignore_broadcasts->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_icmp_echo_ignore_broadcasts->show_all();

    linux24_accept_source_route->set_menu(on_off_menu);
    linux24_accept_source_route->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_accept_source_route->show_all();

    linux24_accept_redirects->set_menu(on_off_menu);
    linux24_accept_redirects->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_accept_redirects->show_all();

    linux24_icmp_ignore_bogus_error_responses->set_menu(on_off_menu);
    linux24_icmp_ignore_bogus_error_responses->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_icmp_ignore_bogus_error_responses->show_all();

    linux24_ip_dynaddr->set_menu(on_off_menu);
    linux24_ip_dynaddr->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_ip_dynaddr->show_all();

    linux24_log_martians->set_menu(on_off_menu);
    linux24_log_martians->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_log_martians->show_all();

    linux24_icmp_echo_ignore_all->set_menu(on_off_menu);
    linux24_icmp_echo_ignore_all->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_icmp_echo_ignore_all->show_all();
                                              
                                              
    linux24_tcp_window_scaling->set_menu(on_off_menu);
    linux24_tcp_window_scaling->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_tcp_window_scaling->show_all();

    linux24_tcp_sack->set_menu(on_off_menu);
    linux24_tcp_sack->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_tcp_sack->show_all();

    linux24_tcp_fack->set_menu(on_off_menu);
    linux24_tcp_fack->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_tcp_fack->show_all();

    linux24_tcp_syncookies->set_menu(on_off_menu);
    linux24_tcp_syncookies->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_tcp_syncookies->show_all();

    linux24_tcp_ecn->set_menu(on_off_menu);
    linux24_tcp_ecn->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_tcp_ecn->show_all();

    linux24_tcp_timestamps->set_menu(on_off_menu);
    linux24_tcp_timestamps->changed.connect(SigC::slot(this,&TargetDialog_linux24::on_changed));
    linux24_tcp_timestamps->show_all();

    options.push_back( DialogOption(  linux24_ip_forward                        , "linux24_ip_forward"));
    options.push_back( DialogOption(  linux24_rp_filter                         , "linux24_rp_filter"));
    options.push_back( DialogOption(  linux24_icmp_echo_ignore_broadcasts       , "linux24_icmp_echo_ignore_broadcasts"));
    options.push_back( DialogOption(  linux24_accept_source_route               , "linux24_accept_source_route"));
    options.push_back( DialogOption(  linux24_accept_redirects                  , "linux24_accept_redirects"));
    options.push_back( DialogOption(  linux24_icmp_ignore_bogus_error_responses , "linux24_icmp_ignore_bogus_error_responses"));
    options.push_back( DialogOption(  linux24_ip_dynaddr                        , "linux24_ip_dynaddr"));
    options.push_back( DialogOption(  linux24_log_martians                      , "linux24_log_martians"));
    options.push_back( DialogOption(  linux24_icmp_echo_ignore_all              , "linux24_icmp_echo_ignore_all"));
        			    
    options.push_back( DialogOption(  linux24_path_iptables   , "linux24_path_iptables" ));
    options.push_back( DialogOption(  linux24_path_ip         , "linux24_path_ip"       ));
    options.push_back( DialogOption(  linux24_path_logger     , "linux24_path_logger"   ));
    options.push_back( DialogOption(  linux24_path_modprobe   , "linux24_path_modprobe" ));
    options.push_back( DialogOption(  linux24_path_lsmod      , "linux24_path_lsmod"    ));
        			    
    options.push_back( DialogOption(  linux24_tcp_window_scaling                , "linux24_tcp_window_scaling"));
    options.push_back( DialogOption(  linux24_tcp_sack                          , "linux24_tcp_sack"));
    options.push_back( DialogOption(  linux24_tcp_fack                          , "linux24_tcp_fack"));
    options.push_back( DialogOption(  linux24_tcp_syncookies                    , "linux24_tcp_syncookies"));
    options.push_back( DialogOption(  linux24_tcp_ecn                           , "linux24_tcp_ecn"));
    options.push_back( DialogOption(  linux24_tcp_timestamps                    , "linux24_tcp_timestamps"));
    options.push_back( DialogOption(  linux24_tcp_fack                          , "linux24_tcp_fack"));
        			    
    options.push_back( DialogOption(  linux24_tcp_fin_timeout                    , "linux24_tcp_fin_timeout" ));
    options.push_back( DialogOption(  linux24_tcp_keepalive_interval             , "linux24_tcp_keepalive_interval"));


}

void TargetDialog_linux24::on_changed()
{   
    DialogPlugin::data_changed_flag(true);
}

void TargetDialog_linux24::readDefaults()
{
    linux24_ip_forward->set_active_item_by_label(
        Resources::os_res["linux24"]->getResourceStr(
            "/FWBuilderResources/Target/options/linux24_ip_forward"));
}

void TargetDialog_linux24::wrk2dlg()
{
    loadPageOptions(fwoptions,  options);
}

bool TargetDialog_linux24::dlg2wrk()
{
    savePageOptions(fwoptions,  options );
    return true;
}
