/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: IPServiceDialog.cpp,v 1.20 2004/06/17 06:37:00 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "IPServiceDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/IPService.h"
#include "fwbuilder/ServiceGroup.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>

#include <iostream>

using namespace libfwbuilder;
using namespace std;

void IPServiceDialog::loadFWObject(FWObject *o)
{
    obj=o;
    IPService *s = dynamic_cast<IPService*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    protocolNum->setValue( s->getProtocolNumber() );
    lsrr->setChecked( s->getBool("lsrr") );
    ssrr->setChecked( s->getBool("ssrr") );
    rr->setChecked( s->getBool("rr") );
    timestamp->setChecked( s->getBool("ts") );
    all_fragments->setChecked( s->getBool("fragm") );
    short_fragments->setChecked( s->getBool("short_fragm") );

    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    protocolNum->setEnabled(!o->isReadOnly());
    setDisabledPalette(protocolNum);

    lsrr->setEnabled(!o->isReadOnly());
    setDisabledPalette(lsrr);

    ssrr->setEnabled(!o->isReadOnly());
    setDisabledPalette(ssrr);

    rr->setEnabled(!o->isReadOnly());
    setDisabledPalette(rr);

    timestamp->setEnabled(!o->isReadOnly());
    setDisabledPalette(timestamp);

    all_fragments->setEnabled(!o->isReadOnly());
    setDisabledPalette(all_fragments);

    short_fragments->setEnabled(!o->isReadOnly());
    setDisabledPalette(short_fragments);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);


    init=false;
}
    
void IPServiceDialog::changed()
{
    apply->setEnabled( true );
}

void IPServiceDialog::validate(bool *res)
{
    *res=true;
}

void IPServiceDialog::isChanged(bool *res)
{
    *res=(!init && apply->isEnabled());
}

void IPServiceDialog::libChanged()
{
    changed();
}

void IPServiceDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;
    if (!validateName(this,obj,obj_name->text())) return;

    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );

    obj->setInt("protocol_num", protocolNum->value() );
    obj->setBool("lsrr", lsrr->isChecked() );
    obj->setBool("ssrr", ssrr->isChecked() );
    obj->setBool("rr", rr->isChecked() );
    obj->setBool("ts", timestamp->isChecked() );
    obj->setBool("fragm", all_fragments->isChecked() );
    obj->setBool("short_fragm", short_fragments->isChecked() );

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) && libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    apply->setEnabled( false );
}

void IPServiceDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void IPServiceDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

