
%define name    fwbuilder
%define version 2.1.19
%define release 1
%define BUILD_VERSION 21

%if "%_vendor" == "MandrakeSoft"
%define guigroup  System/Configuration/Networking
%define compgroup System/Configuration/Networking
%else
%define guigroup  Applications/System
%define compgroup Applications/System
%endif

Summary:        Firewall Builder
Name:           %{name}
Version:        %{version}
Release:        %{release}%{?dist}
License:        GPL2
Vendor:		NetCitadel LLC, http://sourceforge.net/project/showfiles.php?group_id=5314
Group:          %{guigroup}
Url:            http://www.fwbuilder.org/
Source:         http://prdownloads.sourceforge.net/fwbuilder/%{name}-%{version}.tar.gz
Packager:       Vadim Kurland <vadim@fwbuilder.org>

Buildroot:      %{_tmppath}/%{name}-%{version}-root

Requires:      libfwbuilder = 2.1.19
BuildRequires: libfwbuilder-devel = 2.1.19
BuildRequires: libxml2-devel, libxslt-devel, openssl-devel
%if "%_vendor" == "redhat"
BuildRequires: qt-devel
%else
BuildRequires: qt3-devel
%endif
Obsoletes:     fwbuilder-ipt, fwbuilder-pf, fwbuilder-ipf, fwbuilder-ipfw, fwbuilder-pix, fwbuilder-iosacl

Docdir:         /usr/share/doc

%description
Firewall Builder consists of a GUI and set of policy compilers for
various firewall platforms. It helps users maintain a database of
objects and allows policy editing using simple drag-and-drop
operations. GUI generates firewall description in the form of XML
file, which compilers then interpret and generate platform-specific
code. Several algorithms are provided for automated network objects
discovery and bulk import of data. The GUI and policy compilers are
completely independent, this provides for a consistent abstract model
and the same GUI for different firewall platforms. 

%prep

%setup 

%build
[ -n "$QTDIR" ] || {
  [ -f %{_sysconfdir}/profile.d/qt.sh ] && . %{_sysconfdir}/profile.d/qt.sh
  [ -f %{_sysconfdir}/profile.d/qtdir3.sh ] && . %{_sysconfdir}/profile.d/qtdir3.sh
  [ -f %{_sysconfdir}/SuSEconfig/profile ] && . %{_sysconfdir}/SuSEconfig/profile
}
%configure --prefix=/usr/
make all

%install
[ -n "$QTDIR" ] || {
  [ -f %{_sysconfdir}/profile.d/qt.sh ] && . %{_sysconfdir}/profile.d/qt.sh
  [ -f %{_sysconfdir}/profile.d/qtdir3.sh ] && . %{_sysconfdir}/profile.d/qtdir3.sh
  [ -f %{_sysconfdir}/SuSEconfig/profile ] && . %{_sysconfdir}/SuSEconfig/profile
}
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make DDIR="${RPM_BUILD_ROOT}/" install
rm -fr $RPM_BUILD_ROOT/usr/share/doc/%{name}-%{version}

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%dir /usr/share/fwbuilder%{BUILD_VERSION}
/usr/share/fwbuilder%{BUILD_VERSION}/locale/*
/usr/share/fwbuilder%{BUILD_VERSION}/platform/*
/usr/share/fwbuilder%{BUILD_VERSION}/os/*
/usr/share/fwbuilder%{BUILD_VERSION}/resources.xml
/usr/share/fwbuilder%{BUILD_VERSION}/objects_init.xml
/usr/share/fwbuilder%{BUILD_VERSION}/templates.xml
/usr/bin/fwbuilder
/usr/bin/fwblookup
/usr/bin/fwbedit
/usr/bin/fwb_iosacl
/usr/bin/fwb_ipf
/usr/bin/fwb_ipfw
/usr/bin/fwb_ipt
/usr/bin/fwb_pf
/usr/bin/fwb_pix
%doc doc/AUTHORS
%doc doc/COPYING
%doc doc/Credits
%doc doc/ChangeLog
%doc doc/PatchAcceptancePolicy.txt
%doc doc/README.floppyfw
%doc doc/README.iosacl
%doc doc/README.ipf
%doc doc/README.ipfw
%doc doc/README.ipt
%doc doc/README.pf
%doc doc/README.pix
%doc doc/README.routing
%doc doc/README.policy_import
%doc doc/FWBuilder-Routing-LICENSE.txt
%doc doc/ReleaseNotes_2.1.7.html
%doc doc/ReleaseNotes_2.1.7.txt
%doc doc/ReleaseNotes_2.1.8.html
%doc doc/ReleaseNotes_2.1.8.txt
%doc doc/ReleaseNotes_2.1.9.html
%doc doc/ReleaseNotes_2.1.9.txt
%doc doc/ReleaseNotes_2.1.10.html
%doc doc/ReleaseNotes_2.1.10.txt
%doc doc/ReleaseNotes_2.1.11.html
%doc doc/ReleaseNotes_2.1.11.txt
%doc doc/ReleaseNotes_2.1.12.html
%doc doc/ReleaseNotes_2.1.12.txt
%doc doc/ReleaseNotes_2.1.13.html
%doc doc/ReleaseNotes_2.1.13.txt
%doc doc/ReleaseNotes_2.1.14.html
%doc doc/ReleaseNotes_2.1.14.txt
%doc doc/ReleaseNotes_2.1.15.html
%doc doc/ReleaseNotes_2.1.15.txt
%doc doc/ReleaseNotes_2.1.16.html
%doc doc/ReleaseNotes_2.1.16.txt
%doc doc/ReleaseNotes_2.1.17.html
%doc doc/ReleaseNotes_2.1.17.txt
%doc doc/ReleaseNotes_2.1.18.html
%doc doc/ReleaseNotes_2.1.18.txt
%doc doc/ReleaseNotes_2.1.19.html
%doc doc/ReleaseNotes_2.1.19.txt
%{_mandir}/man1/fwbuilder.1*
%{_mandir}/man1/fwblookup.1*
%{_mandir}/man1/fwbedit.1*
%{_mandir}/man1/fwb_iosacl.1*
%{_mandir}/man1/fwb_ipf.1*
%{_mandir}/man1/fwb_ipfw.1*
%{_mandir}/man1/fwb_ipt.1*
%{_mandir}/man1/fwb_pf.1*
%{_mandir}/man1/fwb_pix.1*


