/* OpenSSLAdapter.hh
 * SSL adapter for TCP connection
 *
 * Copyright (C) 1999-2001 Dave Smith & Julian Missig
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contributor(s): Konrad Podloucky
 */

#ifndef INCL_OPENSSL_ADAPTER_HH
#define INCL_OPENSSL_ADAPTER_HH

#include <string>
#include <glib.h>
#include <openssl/ssl.h>
#include "SSLAdapter.hh"
namespace Gabber {

class OpenSSLAdapter: public SSLAdapter
{
public:
     OpenSSLAdapter();
  
     virtual void disconnect();
     virtual GIOStatus send(const gchar* data, const gsize len, gsize* written);
     virtual GIOStatus read(gchar* buffer, const gsize count, gsize* bytes_read);
     virtual bool registerSocket(const gint socket);

protected:
     virtual void freeResources();
     void seed_rng();

private:
     SSL*			_client_ssl;
     SSL_METHOD*		_ssl_method;
     SSL_CTX*			_ssl_client_context;
};

};

#endif /* INCL_OPENSSL_TRANSMITTER_HH */







