/* SSLAdapter.hh
 * SSL adapter for TCP connection
 *
 * Copyright (C) 1999-2001 Dave Smith & Julian Missig
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Contributor(s): Konrad Podloucky
 */

#ifndef INCL_SSL_ADAPTER_HH
#define INCL_SSL_ADAPTER_HH

#include <string>
#include <glib.h>

namespace Gabber {

class SSLAdapter
{
public:
     SSLAdapter();
     virtual ~SSLAdapter();
  
     virtual void disconnect() {};
     virtual GIOStatus send(const gchar* data, const gsize len, gsize* written) = 0;
     virtual GIOStatus read(gchar* buffer, const gsize count, gsize* bytes_read) = 0;
     virtual bool registerSocket(const gint socket) = 0;
     const std::string getError();
     static SSLAdapter *createAdapter();

protected:
     virtual void freeResources() {};
     std::string		_lastError;
     bool			_connected;
};

};

#endif /* INCL_SSL_TRANSMITTER_HH */
