/*
 * gAcc_prefs.c
 * Thomas Nemeth, le 08.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "gAcc_prefs.h"
#include "defines.h"
#include "structs.h" 
#include "cfgmgt.h"
#include "acclists.h"
#include "locale_formats.h"
#include "gAcc.h"
#include "gAcc_menus.h"

/*** Create the "Preferences" dialog box ****************************/

void set_prefs_to_config (MY_LIST *list) {
    char *currency, *date_separator;
    char *ps_cmd, *ps_opt, *asc_cmd, *asc_opt;
    int   currency_position    = CURRENCY_AFTER;
    int   date_format          = FRENCH_DATE;
    int   auto_save            = FAUX;
    int   advanced             = ADVANCED_BASIC;
    int   tear_off             = FAUX;
    int   use_last_acc         = FAUX;
    float euro_value           = DEFAULT_EURO_VALUE;
    GtkWidget *pref_cur        = (GtkWidget *) my_list_get_element (list,  1);
    GtkWidget *pref_date       = (GtkWidget *) my_list_get_element (list,  2);
    GtkWidget *pref_curpos_fr  = (GtkWidget *) my_list_get_element (list,  3);
    GtkWidget *pref_curpos_en  = (GtkWidget *) my_list_get_element (list,  4);
    GtkWidget *pref_date_fr    = (GtkWidget *) my_list_get_element (list,  5);
    GtkWidget *pref_date_en    = (GtkWidget *) my_list_get_element (list,  6);
    GtkWidget *pref_euro       = (GtkWidget *) my_list_get_element (list,  7);
    GtkWidget *pref_autosave   = (GtkWidget *) my_list_get_element (list,  8);
    GtkWidget *pref_tearoff    = (GtkWidget *) my_list_get_element (list,  9);
    GtkWidget *pref_uselastacc = (GtkWidget *) my_list_get_element (list, 10);
    GtkWidget *pref_advanced   = (GtkWidget *) my_list_get_element (list, 11);
    GtkWidget *pref_advanced_t = (GtkWidget *) my_list_get_element (list, 12);
    GtkWidget *pref_advanced_s = (GtkWidget *) my_list_get_element (list, 13);
    GtkWidget *pref_pscmd      = (GtkWidget *) my_list_get_element (list, 14);
    GtkWidget *pref_psopt      = (GtkWidget *) my_list_get_element (list, 15);
    GtkWidget *pref_ascmd      = (GtkWidget *) my_list_get_element (list, 16);
    GtkWidget *pref_asopt      = (GtkWidget *) my_list_get_element (list, 17);
/*    GtkWidget *pref_decimal    = (GtkWidget *) my_list_get_element (list, 18);*/

    currency       = gtk_entry_get_text (GTK_ENTRY (pref_cur) );
    date_separator = gtk_entry_get_text (GTK_ENTRY (pref_date) );
/*    decimal_point  = gtk_entry_get_text (GTK_ENTRY (pref_decimal) );*/
    ps_cmd         = gtk_entry_get_text (GTK_ENTRY (pref_pscmd) );
    ps_opt         = gtk_entry_get_text (GTK_ENTRY (pref_psopt) );
    asc_cmd        = gtk_entry_get_text (GTK_ENTRY (pref_ascmd) );
    asc_opt        = gtk_entry_get_text (GTK_ENTRY (pref_asopt) );
    euro_value     = atof (gtk_entry_get_text (GTK_ENTRY (pref_euro) ) );
    if (GTK_TOGGLE_BUTTON (pref_curpos_fr)->active)
        currency_position = CURRENCY_AFTER;
    else if (GTK_TOGGLE_BUTTON (pref_curpos_en)->active)
        currency_position = CURRENCY_BEFORE;
    if (GTK_TOGGLE_BUTTON (pref_date_fr)->active)
        date_format = FRENCH_DATE;
    else if (GTK_TOGGLE_BUTTON (pref_date_en)->active)
        date_format = ENGLISH_DATE;
    if (GTK_TOGGLE_BUTTON (pref_autosave)->active)
        auto_save = VRAI;
    if (GTK_TOGGLE_BUTTON (pref_tearoff)->active)
        tear_off = VRAI;
    if (GTK_TOGGLE_BUTTON (pref_uselastacc)->active)
        use_last_acc = VRAI;
    if (GTK_TOGGLE_BUTTON (pref_advanced)->active) {
        if (GTK_TOGGLE_BUTTON (pref_advanced_t)->active) {
            advanced = advanced | ADVANCED_TIERS;
            gtk_widget_set_sensitive (trs_menu_item, TRUE);
        } else
            gtk_widget_set_sensitive (trs_menu_item, FALSE);
        if (GTK_TOGGLE_BUTTON (pref_advanced_s)->active)
            advanced = advanced | ADVANCED_SPLITS;
    } else
        advanced = ADVANCED_BASIC;

    config_set_currency       (currency);
    config_set_date_separator (date_separator);
/*    config_set_decimal_point  (decimal_point);*/
    config_set_currency_pos   (currency_position);
    config_set_date_format    (date_format);
    config_set_auto_save      (auto_save);
    config_set_tear_off       (tear_off);
    config_set_use_last_acc   (use_last_acc);
    config_set_euro_value     (euro_value);
    config_set_advanced       (advanced);
    config_set_ps_prn_cmd     (ps_cmd);
    config_set_ps_prn_opt     (ps_opt);
    config_set_asc_prn_cmd    (asc_cmd);
    config_set_asc_prn_opt    (asc_opt);

    #ifdef DEBUG_GACC
        printf ("MODIFICATION DE LA CONFIGURATION : \n");
        printf ("currency        = %s\n", currency);
        printf ("date_separator  = %s\n", date_separator);
/*        printf ("decimal_point   = %s\n", decimal_point);*/
        printf ("currency_pos    = %s\n", currency_position == CURRENCY_BEFORE ?
                                         "CURRENCY_BEFORE" : "CURRENCY_AFTER");
        printf ("date_format     = %s\n", date_format == FRENCH_DATE ?
                                         "FRENCH_DATE" : "ENGLISH_DATE");
        printf ("auto_save       = %s\n", auto_save == VRAI ? "VRAI" : "FAUX");
        printf ("tear_off        = %s\n", tear_off == VRAI ? "VRAI" : "FAUX");
        printf ("use_last_acc    = %s\n", use_last_acc == VRAI ?
                                          "VRAI" : "FAUX");
        printf ("euro_value      = %f\n", euro_value);
        printf ("advanced        = %d\n", advanced);
        printf ("PS print cmd    = %s\n", config.ps_prn_cmd);
        printf ("PS print opt    = %s\n", config.ps_prn_opt);
        printf ("ASCII print cmd = %s\n", config.asc_prn_cmd);
        printf ("ASCII print opt = %s\n", config.asc_prn_opt);
    #endif
}

void prefs_ok_cb (GtkWidget *widget, void *data) {
    set_prefs_to_config ( (MY_LIST *) data);
    set_acc_list (acc_clist);
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

void prefs_save_cb (GtkWidget *widget, void *data) {
    set_prefs_to_config ( (MY_LIST *) data);
    write_config ();
    set_acc_list (acc_clist);
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

void prefs_cancel_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

void toggle_advanced_cb (GtkWidget *widget, void *data) {
    MY_LIST *list = (MY_LIST *) data;
    GtkWidget *pref_advanced_t = (GtkWidget *) my_list_get_element (list, 12);
    GtkWidget *pref_advanced_s = (GtkWidget *) my_list_get_element (list, 13);

    if (GTK_TOGGLE_BUTTON (widget) -> active) {
        gtk_widget_set_sensitive (pref_advanced_t, TRUE);
        gtk_widget_set_sensitive (pref_advanced_s, TRUE);
    } else {
        gtk_widget_set_sensitive (pref_advanced_t, FALSE);
        gtk_widget_set_sensitive (pref_advanced_s, FALSE);
/*
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_advanced_t),
                                      FALSE);
        gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_advanced_s),
                                      FALSE);
*/
    }
}

GtkWidget *create_prefs_dialog () {
    GtkWidget *Prefs_Dialog;
    GtkWidget *bouton;
    GtkWidget *notebook;
    GtkWidget *hbox;
    GtkWidget *main_vbox;
    GtkWidget *vbox;
    GtkWidget *label;
    GtkWidget *frame;
    GtkWidget *pref_cur;
    GtkWidget *pref_date;
/*    GtkWidget *pref_decimal;*/
    GtkWidget *pref_curpos_fr;
    GtkWidget *pref_curpos_en;
    GtkWidget *pref_date_fr;
    GtkWidget *pref_date_en;
    GtkWidget *pref_euro;
    GtkWidget *pref_autosave;
    GtkWidget *pref_tearoff;
    GtkWidget *pref_uselastacc;
    GtkWidget *pref_advanced;
    GtkWidget *pref_advanced_t;
    GtkWidget *pref_advanced_s;
    GtkWidget *pref_pscmd;
    GtkWidget *pref_psopt;
    GtkWidget *pref_ascmd;
    GtkWidget *pref_asopt;
    char      *eurovalue;
    char      *tmpstr;
    MY_LIST   *list = NULL;


    Prefs_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (Prefs_Dialog), _("Preferences") );
    list = my_list_add (list, Prefs_Dialog);
    gtk_signal_connect (GTK_OBJECT (Prefs_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (Prefs_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label ( _("OK") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (prefs_ok_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Prefs_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_grab_default (GTK_WIDGET (bouton) );
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Save") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (prefs_save_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Prefs_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Cancel") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (prefs_cancel_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Prefs_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    notebook = gtk_notebook_new ();

    /* Currency (1st) Notebook */
/*    main_vbox = gtk_vbox_new (FALSE, 0);*/
    main_vbox = gtk_vbox_new (TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 6);

    /* Currency */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Currency : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    pref_cur = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), pref_cur, TRUE, TRUE, 6);
    gtk_widget_show (pref_cur);

    gtk_box_pack_start (GTK_BOX (main_vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    /* Decimal point */
/*    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Decimal point : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    pref_decimal = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), pref_decimal, TRUE, TRUE, 6);
    gtk_widget_show (pref_decimal);

    gtk_box_pack_start (GTK_BOX (main_vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);*/
    /* - */

    /* Currency Position */
    frame = gtk_frame_new (_(" Currency position : ") );
    vbox  = gtk_vbox_new (TRUE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    pref_curpos_fr = gtk_radio_button_new_with_label (
                            NULL, 
                            _("After  : #.## F") );
    gtk_box_pack_start (GTK_BOX (vbox), pref_curpos_fr, TRUE, TRUE, 6);
    gtk_widget_show (pref_curpos_fr);

    pref_curpos_en = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (pref_curpos_fr) ),
                            _("Before : $ #.##") );
    gtk_box_pack_start (GTK_BOX (vbox), pref_curpos_en, TRUE, TRUE, 6);
    gtk_widget_show (pref_curpos_en);

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    label = gtk_label_new (_(" Currency ") );
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), main_vbox, label);
    gtk_widget_show (label);
    gtk_widget_show (main_vbox);
    /* ---+++===*===+++--- */

    /* Date (2nd) Notebook */
    main_vbox = gtk_vbox_new (TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 6);

    /* Date Separation */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Date separator : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    pref_date = gtk_entry_new_with_max_length (1);
    gtk_box_pack_start (GTK_BOX (hbox), pref_date, TRUE, TRUE, 6);
    gtk_widget_show (pref_date);

    gtk_box_pack_start (GTK_BOX (main_vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    /* Date Format */
    frame = gtk_frame_new (_(" Date format : ") );
    vbox  = gtk_vbox_new (TRUE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    pref_date_fr = gtk_radio_button_new_with_label (
                            NULL, 
                            _("dd.mm.yyyy") );
    gtk_box_pack_start (GTK_BOX (vbox), pref_date_fr, TRUE, TRUE, 6);
    gtk_widget_show (pref_date_fr);

    pref_date_en = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (pref_date_fr) ),
                            _("mm.dd.yyyy") );
    gtk_box_pack_start (GTK_BOX (vbox), pref_date_en, TRUE, TRUE, 6);
    gtk_widget_show (pref_date_en);

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    label = gtk_label_new (_(" Date ") );
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), main_vbox, label);
    gtk_widget_show (label);
    gtk_widget_show (main_vbox);
    /* ---+++===*===+++--- */

    /* Euro (3rd) Notebook */
    main_vbox = gtk_vbox_new (TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 6);

    /* Euro Value */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Euro value : 1 Euro = ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    pref_euro = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), pref_euro, TRUE, TRUE, 6);
    gtk_widget_show (pref_euro);

    gtk_box_pack_start (GTK_BOX (main_vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    label = gtk_label_new (_(" Euro ") );
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), main_vbox, label);
    gtk_widget_show (label);
    gtk_widget_show (main_vbox);
    /* ---+++===*===+++--- */

    /* Printer Config (4th) Notebook */
    main_vbox = gtk_vbox_new (TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 6);

    /* PostScript Printer */
    frame = gtk_frame_new (_(" PostScript printer : ") );
    vbox  = gtk_vbox_new (TRUE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    /* PS Print Command */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Print command : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    pref_pscmd = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), pref_pscmd, TRUE, TRUE, 6);
    gtk_widget_show (pref_pscmd);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    /* PS Print Option */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Print options : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    pref_psopt = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), pref_psopt, TRUE, TRUE, 6);
    gtk_widget_show (pref_psopt);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    /* ASCII Printer */
    frame = gtk_frame_new (_(" ASCII printer : ") );
    vbox  = gtk_vbox_new (TRUE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    /* ASCII Print Command */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Print command : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    pref_ascmd = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), pref_ascmd, TRUE, TRUE, 6);
    gtk_widget_show (pref_ascmd);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    /* ASCII Print Option */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Print options : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 6);
    gtk_widget_show (label);

    pref_asopt = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), pref_asopt, TRUE, TRUE, 6);
    gtk_widget_show (pref_asopt);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* - */

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    label = gtk_label_new (_(" Printer ") );
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), main_vbox, label);
    gtk_widget_show (label);
    gtk_widget_show (main_vbox);
    /* ---+++===*===+++--- */

    /* Misc (5th) Notebook */
    main_vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 6);

    /* AutoSave */
    pref_autosave = gtk_check_button_new_with_label (_("Auto save files") );

    gtk_box_pack_start (GTK_BOX (main_vbox), pref_autosave, TRUE, TRUE, 6);
    gtk_widget_show (pref_autosave);
    /* - */

    /* Tear Off Menus */
    pref_tearoff = gtk_check_button_new_with_label (_("Tear off menus") );

    gtk_box_pack_start (GTK_BOX (main_vbox), pref_tearoff, TRUE, TRUE, 6);
    gtk_widget_show (pref_tearoff);
    /* - */

    /* Use Last Opened Account */
    pref_uselastacc = gtk_check_button_new_with_label (
                                                _("Use last opened account") );

    gtk_box_pack_start (GTK_BOX (main_vbox), pref_uselastacc, TRUE, TRUE, 6);
    gtk_widget_show (pref_uselastacc);
    /* - */

    label = gtk_label_new (_(" Misc. ") );
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), main_vbox, label);
    gtk_widget_show (label);
    gtk_widget_show (main_vbox);
    /* ---+++===*===+++--- */

    /* Advanced (6th) Notebook */
    main_vbox = gtk_vbox_new (TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 6);

    /* Advanced */
    pref_advanced = gtk_check_button_new_with_label (
                    _("Enable advanced features") );

    gtk_box_pack_start (GTK_BOX (main_vbox), pref_advanced, FALSE, FALSE, 6);
    gtk_widget_show (pref_advanced);
    gtk_signal_connect (GTK_OBJECT (pref_advanced), "clicked",
                        GTK_SIGNAL_FUNC (toggle_advanced_cb),
                        list);
    /* - */

    /* Advanced Features */
    frame = gtk_frame_new (_(" Advanced features : ") );
    vbox  = gtk_vbox_new (TRUE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    pref_advanced_t = gtk_check_button_new_with_label (_("3rd party") );
    gtk_box_pack_start (GTK_BOX (vbox), pref_advanced_t, TRUE, TRUE, 6);
    gtk_widget_show (pref_advanced_t);

    pref_advanced_s = gtk_check_button_new_with_label (_("Splits") );
    gtk_box_pack_start (GTK_BOX (vbox), pref_advanced_s, TRUE, TRUE, 6);
    gtk_widget_show (pref_advanced_s);

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (main_vbox), frame, TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    label = gtk_label_new (_(" Advanced ") );
    gtk_notebook_append_page (GTK_NOTEBOOK (notebook), main_vbox, label);
    gtk_widget_show (label);
    gtk_widget_show (main_vbox);
    /* ---+++===*===+++--- */

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Prefs_Dialog)->vbox), notebook,
                        TRUE, TRUE, 6);
    gtk_widget_show (notebook);


    list = my_list_add (list, pref_cur);
    list = my_list_add (list, pref_date);
    list = my_list_add (list, pref_curpos_fr);
    list = my_list_add (list, pref_curpos_en);
    list = my_list_add (list, pref_date_fr);
    list = my_list_add (list, pref_date_en);
    list = my_list_add (list, pref_euro);
    list = my_list_add (list, pref_autosave);
    list = my_list_add (list, pref_tearoff);
    list = my_list_add (list, pref_uselastacc);
    list = my_list_add (list, pref_advanced);
    list = my_list_add (list, pref_advanced_t);
    list = my_list_add (list, pref_advanced_s);
    list = my_list_add (list, pref_pscmd);
    list = my_list_add (list, pref_psopt);
    list = my_list_add (list, pref_ascmd);
    list = my_list_add (list, pref_psopt);
/*    list = my_list_add (list, pref_decimal);*/

    #ifdef DEBUG_GACC
        printf ("AVANT LA CONFIGURATION : \n");
        printf ("currency        = %s\n", config.Currency);
        printf ("date_separator  = %c\n", config.DateSeparator);
/*        printf ("decimal_point   = %c\n", config.DecimalPoint);*/
        printf ("currency_pos    = %s\n", config.CurrencyPos == CURRENCY_BEFORE ?
                                          "CURRENCY_BEFORE" : "CURRENCY_AFTER");
        printf ("date_format     = %s\n", config.DateFormat == FRENCH_DATE ?
                                          "FRENCH_DATE" : "ENGLISH_DATE");
        printf ("auto_save       = %s\n", config.AutoSave == VRAI ?
                                          "VRAI" : "FAUX");
        printf ("tear_off        = %s\n", config.TearOff == VRAI ?
                                          "VRAI" : "FAUX");
        printf ("use_last_acc    = %s\n", config.UseLastAcc == VRAI ?
                                          "VRAI" : "FAUX");
        printf ("euro_value      = %f\n", config.EuroValue);
        printf ("advanced        = %d\n", config.Advanced);
        printf ("PS print cmd    = %s\n", config.ps_prn_cmd);
        printf ("PS print opt    = %s\n", config.ps_prn_opt);
        printf ("ASCII print cmd = %s\n", config.asc_prn_cmd);
        printf ("ASCII print opt = %s\n", config.asc_prn_opt);
    #endif
    gtk_entry_set_text (GTK_ENTRY (pref_cur),   config.Currency);
    MY_ALLOC (tmpstr, 2, char);
    tmpstr [0] = config.DateSeparator;
    tmpstr [1] = 0;
    gtk_entry_set_text (GTK_ENTRY (pref_date),  tmpstr);
/*    tmpstr [0] = config.DecimalPoint;
    tmpstr [1] = 0;
    gtk_entry_set_text (GTK_ENTRY (pref_decimal),  tmpstr);*/
    free (tmpstr);
    gtk_entry_set_text (GTK_ENTRY (pref_pscmd), config.ps_prn_cmd);
    gtk_entry_set_text (GTK_ENTRY (pref_psopt), config.ps_prn_opt);
    gtk_entry_set_text (GTK_ENTRY (pref_ascmd), config.asc_prn_cmd);
    gtk_entry_set_text (GTK_ENTRY (pref_asopt), config.asc_prn_opt);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_curpos_fr),
                                  (config.CurrencyPos == CURRENCY_AFTER) );
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_curpos_en),
                                  (config.CurrencyPos == CURRENCY_BEFORE) );
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_date_fr),
                                  (config.DateFormat == FRENCH_DATE) );
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_date_en),
                                  (config.DateFormat == ENGLISH_DATE) );
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_advanced),
                                  (config.Advanced > ADVANCED_BASIC) );
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_autosave),
                                  (config.AutoSave == VRAI) );
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_tearoff),
                                  (config.TearOff == VRAI) );
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_uselastacc),
                                  (config.UseLastAcc == VRAI) );
    if (config.EuroValue != 0.0)
        eurovalue = format_euro_value (config.EuroValue);
    else
        eurovalue = format_euro_value (DEFAULT_EURO_VALUE);
    gtk_entry_set_text (GTK_ENTRY (pref_euro), eurovalue);
    if (GTK_TOGGLE_BUTTON (pref_advanced) -> active) {
        gtk_widget_set_sensitive (pref_advanced_t, TRUE);
        gtk_widget_set_sensitive (pref_advanced_s, TRUE);
        if (advanced_contains (ADVANCED_TIERS) == VRAI)
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_advanced_t),
                                          TRUE);
        if (advanced_contains (ADVANCED_SPLITS) == VRAI)
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (pref_advanced_s),
                                          TRUE);
    } else {
        gtk_widget_set_sensitive (pref_advanced_t, FALSE);
        gtk_widget_set_sensitive (pref_advanced_s, FALSE);
    }

    return Prefs_Dialog;
}
