/*
 * gAcc_results.c
 * Thomas Nemeth, le 11.02.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "gAcc.h"
#include "defines.h"
#include "structs.h" 
#include "gAcc_results.h"
#include "usefull.h"
#include "locale_formats.h"
#include "acclists.h"
#include "operations.h"
#include "categories.h"
#include "gAcc_opelist.h"
#include "gAcc_print.h"
#include "gAcc_menus.h"
#include "gAcc_menuscb.h"


/*** Create the "Operations' results list" dialog box ***********************/

void res_list_sel_cb (GtkCList *clist,
                      gint row,
                      gint column,
                      GdkEventButton *event,
                      void *data) {
    /* A list element has been selected */
    MY_LIST   *list             = (MY_LIST *)  data;
    GtkWidget *menu             = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *edit_menu_item   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *delete_menu_item = (GtkWidget *) my_list_get_element (list, 3);
    GtkWidget *mark_menu_item   = (GtkWidget *) my_list_get_element (list, 4);
    GtkWidget *cancel_menu_item = (GtkWidget *) my_list_get_element (list, 5);


    gtk_widget_set_sensitive (GTK_WIDGET (edit_menu_item),   TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET (delete_menu_item), TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET (mark_menu_item),   TRUE);
    gtk_widget_set_sensitive (GTK_WIDGET (cancel_menu_item), TRUE);


    selected_row = - get_operation_by_num (Results_List, row)->operation->id;
    #ifdef DEBUG_GACC
        printf ("Fentre de rsultats -- opration choisie : %d\n",
                 selected_row);
        printf ("Bouton utilis : %d\n", event->button);
    #endif
    if ( (event->button == 1) && (event->type == GDK_2BUTTON_PRESS) )
        edit_ope_cb (NULL, NULL);
    if (event->button == 2) mark_ope_cb (NULL, NULL);
    if ( (event->button == 3) && (event->type == GDK_2BUTTON_PRESS) )
        gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                        event->button, event->time);
}

void res_list_unsel_cb (GtkCList *clist,
                        gint row,
                        gint column,
                        GdkEventButton *event,
                        void *data) {
    /* A list element has been selected */
    MY_LIST   *list             = (MY_LIST *)  data;
    GtkWidget *edit_menu_item   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *delete_menu_item = (GtkWidget *) my_list_get_element (list, 3);
    GtkWidget *mark_menu_item   = (GtkWidget *) my_list_get_element (list, 4);
    GtkWidget *cancel_menu_item = (GtkWidget *) my_list_get_element (list, 5);


    gtk_widget_set_sensitive (GTK_WIDGET (edit_menu_item),   FALSE);
    gtk_widget_set_sensitive (GTK_WIDGET (delete_menu_item), FALSE);
    gtk_widget_set_sensitive (GTK_WIDGET (mark_menu_item),   FALSE);
    gtk_widget_set_sensitive (GTK_WIDGET (cancel_menu_item), FALSE);

/*
    GtkWidget *menu             = (GtkWidget *) my_list_get_element (list, 1);
    selected_row = row;
    if (event->button == 2) mark_ope_cb (NULL, NULL);
    if (event->button == 3)
        gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL,
                        event->button, event->time);
*/
}

void set_res_list (GtkWidget *list) {
    OPE_ELT  *ope = Results_List;
    GdkColor  bleu   = { 0, 49152, 49152, 65535},
              rouge  = { 0, 65535,     0,     0},
              violet = { 0, 49152,     0, 49152};
    GtkStyle *style;
    int       i;
    gchar    *results[MAX_OPE_COL];
    char     *amount;
    char     *sub_amount;
    char     *date;
    int       row = 0;
    float     tmpamount = 0, sub_total_amount = 0;

    gtk_clist_clear (GTK_CLIST (list) );
    gtk_clist_freeze (GTK_CLIST (list) );
    while (ope != NULL) {
        date       = format_date(ope->operation->date);
        results[0] = date;
        results[1] = (ope->operation->num != NULL ? ope->operation->num : "");
        results[2] = (ope->operation->object != NULL ?
                      ope->operation->object : "" );
        results[3] = (category_name (ope->operation->category) != NULL ?
                      category_name (ope->operation->category) : "");

        if (ope->operation->pointed == 1)
            results[4] = _("C");
        else
            results[4] = "";

        amount         = format_amount (ope->operation->amount);
        if (ope->operation->cancelled == FAUX ) {
            if (ope->operation->type == CREDIT) {
                results[5] = "";
                results[6] = amount;
                tmpamount  = ope->operation->amount;
            } else {
                results[5] = amount;
                results[6] = "";
                tmpamount  = -ope->operation->amount;
            }
        } else {
            results[5] = _("CANCELLED");
            results[6] = _("CANCELLED");
            tmpamount  = 0.0;
        }

        sub_total_amount = sub_total_amount + tmpamount;
        sub_amount = format_amount (sub_total_amount);
        if (ope->operation->cancelled == FAUX )
            results[7] = sub_amount;
        else
            results[7] = _("CANCELLED");

        gtk_clist_append (GTK_CLIST (list), results);

        if  (ope->operation->cancelled == VRAI)
            gtk_clist_set_foreground (GTK_CLIST (list), row, &violet);

        if ( (row / 2) == ( (float) row / 2) )
            gtk_clist_set_background (GTK_CLIST (list), row, &bleu );

        if ( (sub_total_amount <= 0.0) &&
             (ope->operation->cancelled == FAUX) ) {
            style = gtk_style_copy (gtk_widget_get_default_style () ); 
            if (style == NULL) fatal_error ("Gros PB avec le style de la cellule !");
            for (i = 0 ; i < 5 ; i++) style->fg[i] = rouge;
            if ( (row / 2) == ( (float) row / 2) ) {
                style->bg[GTK_STATE_NORMAL]   = bleu;
                style->base[GTK_STATE_NORMAL] = bleu;
            }
            gtk_clist_set_cell_style (GTK_CLIST (list), row, 7, style);
        }

        free (amount);
        free (sub_amount);
        free (date);
        ope = ope->next;
        row++;
    }

    row--;
    if (selected_row >= 0) {
        selected_row = row;
    } else if (selected_row < 0) {
        selected_row = ope_get_num_by_id (Results_List, selected_row) - 1;
    }
    gtk_clist_thaw (GTK_CLIST (list) );
    gtk_clist_unselect_all (GTK_CLIST (list) );
    if (gtk_clist_row_is_visible (GTK_CLIST (list), selected_row)
        != GTK_VISIBILITY_FULL) {
        #ifdef DEBUG_GACC
            printf ("La ligne %d n'est pas pleinement visible !\n",
                     selected_row);
            printf ("tat de la ligne : %d ", gtk_clist_row_is_visible (
                     GTK_CLIST (list), selected_row) );
            printf ("(FULL = %d, PARTIAL = %d, NONE = %d)\n",
                     GTK_VISIBILITY_FULL,
                     GTK_VISIBILITY_PARTIAL,
                     GTK_VISIBILITY_NONE);
        #endif
        gtk_clist_moveto (GTK_CLIST (list), selected_row, 0, 0.5, 0.0);
    }
}

void results_print_cb (GtkWidget *widget, void *data) {
    MY_LIST   *list = NULL;
    GtkWidget *print_dialog;

    list = my_list_add (list, NULL);
    list = my_list_add (list, Results_List);
    print_dialog = create_print_dialog (list);
    gtk_window_set_modal (GTK_WINDOW (print_dialog), TRUE);
    gtk_widget_show (GTK_WIDGET (print_dialog) );
}

void results_close_cb (GtkWidget *widget, void *data) {
    MY_LIST *list = (MY_LIST *) data;

    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (list, 0) );
    free_res_list (&Results_List);
    my_list_free (list);
    selected_row = 0;
    set_ope_list(ope_clist);
}


GtkWidget *create_results_dialog (OPE_ELT *operations_list) {
    GtkWidget     *Results_Dialog;
    GtkWidget     *bouton;
    GtkWidget     *scrolled_window;
    GtkWidget     *ope_list_menu;
    GtkWidget     *edit_ope_menu_item;
    GtkWidget     *mark_ope_menu_item;
    GtkWidget     *cancel_ope_menu_item;
    GtkWidget     *delete_ope_menu_item;
    GtkAccelGroup *accel_group;
    GtkStyle      *style;
    MY_LIST       *list = NULL;
    int            size, total = 0;
    gchar         *ope_titles[MAX_OPE_COL] = { _(" Date "),
                                               _(" Number "),
                                               _(" Object "),
                                               _(" Category "),
                                               _(" C "),
                                               _(" Debit "),
                                               _(" Credit "),
                                               _(" Balance ") };

    Results_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (Results_Dialog), _("Search results window") );
    list = my_list_add (list, Results_Dialog);
    gtk_signal_connect_object (GTK_OBJECT (Results_Dialog), "delete_event",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Results_Dialog));
    gtk_signal_connect_object (GTK_OBJECT (Results_Dialog), "destroy", 
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Results_Dialog));

    accel_group = gtk_accel_group_new();
    gtk_window_add_accel_group (GTK_WINDOW (Results_Dialog), accel_group);
    ope_list_menu  = create_opelist_menus (&accel_group,
                                           &edit_ope_menu_item,
                                           &mark_ope_menu_item,
                                           &cancel_ope_menu_item,
                                           &delete_ope_menu_item,
                                           FALSE);
    list = my_list_add (list, ope_list_menu);
    list = my_list_add (list, edit_ope_menu_item);
    list = my_list_add (list, mark_ope_menu_item);
    list = my_list_add (list, cancel_ope_menu_item);
    list = my_list_add (list, delete_ope_menu_item);
    Results_List = operations_list;

    bouton = gtk_button_new_with_label (_("Print") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (results_print_cb),
                        list);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Results_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label (_("Close") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (results_close_cb),
                        list);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Results_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_grab_default (GTK_WIDGET (bouton) );
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC,
                                    GTK_POLICY_ALWAYS);

    res_clist = gtk_clist_new_with_titles (MAX_OPE_COL, ope_titles);
    style = gtk_style_copy (gtk_widget_get_default_style () ); 
    /* Date */
    size = gdk_string_width (style->font, "00/00/0000"); /* 66 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (res_clist), 0, size);
    #ifdef DEBUG_GACC
        printf ("Date - size = %d\n", size);
    #endif
    /* Number */
    size = gdk_string_width (style->font, "1234567890"); /* 67 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (res_clist), 1, size);
    #ifdef DEBUG_GACC
        printf ("Number - size = %d\n", size);
    #endif
    /* Object */
    size = gdk_string_width (style->font, "123456789012345678901234567890"); /* 215 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (res_clist), 2, size);
    #ifdef DEBUG_GACC
        printf ("Object - size = %d\n", size);
    #endif
    /* Category */
    size = gdk_string_width (style->font, "123456789012345678901234"); /* 115 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (res_clist), 3, size);
    #ifdef DEBUG_GACC
        printf ("Category - size = %d\n", size);
    #endif
    /* Marked */
    size = gdk_string_width (style->font, "C");   /* 10 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (res_clist), 4, size);
    #ifdef DEBUG_GACC
        printf ("Marked - size = %d\n", size);
    #endif
    /* Debit */
    size = gdk_string_width (style->font, "1234567.00"); /* 88 */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (res_clist), 5, size);
    #ifdef DEBUG_GACC
        printf ("Debit/Credit/Balance - size = %d\n", size);
    #endif
    /* Credit */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (res_clist), 6, size);
    /* Balance */
    total += size;
    gtk_clist_set_column_width (GTK_CLIST (res_clist), 7, size);

    gtk_clist_column_titles_passive (GTK_CLIST (res_clist) );
    gtk_clist_set_column_justification (GTK_CLIST (res_clist), 4,
                                        GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification (GTK_CLIST (res_clist), 5,
                                        GTK_JUSTIFY_RIGHT);
    gtk_clist_set_column_justification (GTK_CLIST (res_clist), 6,
                                        GTK_JUSTIFY_RIGHT);
    gtk_clist_set_column_justification (GTK_CLIST (res_clist), 7,
                                        GTK_JUSTIFY_RIGHT);
    gtk_clist_set_selection_mode (GTK_CLIST (res_clist), GTK_SELECTION_SINGLE);
    gtk_clist_set_button_actions (GTK_CLIST (res_clist), 1, GTK_BUTTON_SELECTS);
    gtk_clist_set_button_actions (GTK_CLIST (res_clist), 2, GTK_BUTTON_SELECTS);
    gtk_clist_set_button_actions (GTK_CLIST (res_clist), 3, GTK_BUTTON_SELECTS);
    gtk_signal_connect (GTK_OBJECT (res_clist), "select-row",
                        GTK_SIGNAL_FUNC (res_list_sel_cb), list);
    gtk_signal_connect (GTK_OBJECT (res_clist), "unselect-row",
                        GTK_SIGNAL_FUNC (res_list_unsel_cb), list);

    gtk_container_add (GTK_CONTAINER (scrolled_window), res_clist);
    gtk_widget_show (res_clist);
    /* set_res_list (res_clist); */
    
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Results_Dialog)->vbox),
                        scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show (scrolled_window);

    gtk_widget_set_usize (GTK_WIDGET (Results_Dialog), total + 83, 350); /* 820 */

    return Results_Dialog;
}
