/*
 * operations.h
 * Thomas Nemeth, le 22.02.2000 (from acclists.h 18.09.1999)
 *
 * HEADER
 * Gestion de la liste des donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _OPERATIONS_H_
#define _OPERATIONS_H_

#include "structs.h"

/* ------++++++======*** OPRATIONS * OPERATIONS ***======++++++----- */

/* Ajoute une opration banquaire  un compte                         */
/* Add a bank operation to an account                                 */
void add_operation (ACCOUNT *acc, OPERATION *operation);

/* Enlve une opration d'un compte sans l'effacer                    */
/* Remove an operation from an account without deleting it            */
void remove_operation (ACC_ELT *acc, OPERATION *operation);

/* Enlve et efface une opration d'un compte                         */
/* Remove and delete an operation from an account                     */
void del_operation (ACC_ELT *acc, OPE_ELT *element);

/* Rcupre une opration dans la liste par son numro (premier == 0) */
/* Get an operation in the list by its number (first == 0)            */
OPE_ELT *get_operation_by_num (OPE_ELT *opl, int ope_num);

/* Rcupre une opration dans la liste par son id                    */
/* Get an operation in the list by its id                             */
OPE_ELT *get_operation_by_id (OPE_ELT *opl, int ope_id);

/* Rcupre un numro de position dans la liste par son id            */
/* Get an operation in the list by its id                             */
int ope_get_num_by_id (OPE_ELT *opl, int ope_id);

/* Rcupre le dernier numro d'opration utilis                     */
/* Get the last used operation number                                 */
char *get_last_ope_num (ACC_ELT *acc);

/* Rcupre le prochain id d'opration                                */
/* Get the next operation id                                          */
unsigned int ope_next_id (ACC_ELT *acc);

/* Copie les champs d'une opration dans un autre lment             */
/* Copy the fields of an operation in another element                 */
void operation_copy (OPERATION *source, OPERATION *dest);

/* Cr des listes des oprations d'un compte par 5 critres          */
/* Create lists of an accounts' operations by 5 criteria              */
OPE_ELT *create_list_by_medium (OPE_ELT *ope, int medium);
OPE_ELT *create_list_by_type (OPE_ELT *ope, int type);
OPE_ELT *create_list_by_cat (OPE_ELT *ope, int category);
OPE_ELT *create_list_by_status (OPE_ELT *ope, int pointed);
OPE_ELT *create_list_by_date (OPE_ELT *ope,
                              const char *date1,
                              const char *date2);

/* Libre la mmoire utilise par les oprations d'un(e) compte/liste */
/* Free the memory used by the operations from an account or a list   */
void free_ope_list (OPE_ELT **list);
void free_res_list (OPE_ELT **list);

/* Oprations sur les oprations                                      */
/* Operations on operations                                           */
OPERATION *operation_new ();
OPERATION *get_operation_from_line (const char *line);
OPERATION *get_operation_from_old_line (const char *line);
char *create_line_from_operation (OPERATION *ope);
OPE_ELT *ope_list_elt_new ();
void ope_set_id         (OPERATION *ope, unsigned int id);
void ope_set_parent     (OPERATION *ope, unsigned int parent);
void ope_set_num        (OPERATION *ope, const char  *num);
void ope_set_object     (OPERATION *ope, const char  *object);
void ope_set_date       (OPERATION *ope, const char  *date);
/* void ope_set_comment    (OPERATION *ope, const char *comment); */
void ope_set_amount     (OPERATION *ope, float        amount);
void ope_set_medium     (OPERATION *ope, int          medium);
void ope_set_type       (OPERATION *ope, int          type);
void ope_set_pointed    (OPERATION *ope, int          pointed);
void ope_set_cancelled  (OPERATION *ope, int          cancelled);
void ope_set_category   (OPERATION *ope, int          category);
void ope_set_tiers      (OPERATION *ope, int          tiers);
void ope_set_trsopid    (OPERATION *ope, int          trs_opeid);

/* Affiche le contenu d'une liste d'oprations (pour dbogage)        */
/* Display an operations' list contents (for debugging)               */
void display_all_list (OPE_ELT *ope_list);

#endif
