/*
 * usefull.c
 * Thomas Nemeth, le 11.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stdarg.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>
#include "structs.h"
#include "locale_formats.h"
#include "usefull.h"


extern char **environ;

int my_system (const char *command, const char *options) {
    int pid, status;

    if (command == 0)
        return 1;
    pid = fork ();
    if (pid == -1)
        return -1;
    if (pid == 0) {
        char *cmd;
        char *argv[4];
        MY_ALLOC (cmd, strlen (command) + strlen (options) + 2, char);
        strcpy (cmd, command);
        strcat (cmd, " ");
        strcat (cmd, options);
        #ifdef DEBUG_GACC
            printf("Lancement de : %s\n", cmd);
        #endif
        argv[0] = "sh";
        argv[1] = "-c";
        argv[2] = cmd;
        argv[3] = 0;
        execve ("/bin/sh", argv, environ);
        free (cmd);
        exit (127);
    }
    do {
        if (waitpid (pid, &status, 0) == -1) {
            if (errno != EINTR)
                return -1;
        } else
            return status;
    } while (1);
}

void fatal_error (char *message) {
    perror (message);
    exit (1);
}

/* UNUSED FUNCTIONS...
void my_printf (int affichage, char *format, ...) {
   va_list args;
 
   if ( (affichage == FAUX) || (affichage != debug_level) ) return;
   va_start (args, format);
   vprintf  (format, args);
   va_end   (args);
}
*/

/* REPLACED BY A MACRO IN defines.h
void *my_alloc (size_t size) {
    void *bloc;
    bloc = malloc (size);
    if (bloc == NULL) fatal_error ("Memory allocation error !");
    return bloc;
}
*/

int date_is_superior (char *new_date, char *lst_date) {
    long int d1, d2;
/*
    sscanf (new_date, "%d", &d1);
    sscanf (lst_date, "%d", &d2);
*/
    d1 = atol (new_date);
    d2 = atol (lst_date);
    /*
    #ifdef DEBUG_GACC
        printf ("La nouvelle date %d est ", d1);
        if (d1 >= d2)  printf (">= ");
        if (d2 > d1)  printf ("< ");
        if (d1 == d2) printf ("= ");
        printf (" la date de la liste %d :\n", d2);
        printf ("soit %d %c %d !\n", d1,
                (d1 > d2 ? '>' : (d2 > d1 ? '<' : '=') ),
                d2);
    #endif
    */
    return (d1 > d2);
}

int date_is_equal (char *new_date, char *lst_date) {
    long int d1, d2;

    d1 = atol (new_date);
    d2 = atol (lst_date);

    return (d1 == d2);
}

int num_is_inferior (char *new_num, char *lst_num) {
    long int n1 = 0, n2 = 0;

    if ( (new_num != NULL) && (lst_num != NULL) ) {
        n1 = atol (new_num);
        n2 = atol (lst_num);
        #ifdef DEBUG_GACC
            printf ("Le nouveau numro %ld est ", n1);
            if (n1 >= n2)  printf (">= ");
            if (n2 > n1)  printf ("< ");
            if (n1 == n2) printf ("= ");
            printf ("au numro de la liste %ld :\n", n2);
            printf ("soit %ld %c %ld !\n", n1,
                    (n1 > n2 ? '>' : (n2 > n1 ? '<' : '=') ),
                    n2);
        #endif
        return (n1 <= n2);
    }
    return FAUX;
}

int stop_loop (OPERATION *new_ope, OPERATION *lst_ope) {
    if (date_is_equal (new_ope->date, lst_ope->date) ) {
        if (num_is_inferior (new_ope->num, lst_ope->num) ) return VRAI;
        return FAUX;
    }
    if (date_is_superior (new_ope->date, lst_ope->date) ) return FAUX;
    return VRAI;
}

float compute_solde (float initial_amount, OPE_ELT *list_head) {
    OPE_ELT *ope;
    float    solde;

    solde = initial_amount;
    ope   = list_head;
    while (ope != NULL) {
        if (ope->operation->cancelled == FAUX) {
            if (ope->operation->type == CREDIT) {
                solde += ope->operation->amount;
            } else {
                solde -= ope->operation->amount;
            }
        }
        ope = ope->next;
    }
    
    return solde;
}

float compute_pointed_solde (float initial_amount, OPE_ELT *list_head) {
    OPE_ELT *ope;
    float    solde;

    solde = initial_amount;
    ope   = list_head;
    while (ope != NULL) {
        if ( (ope->operation->pointed == VRAI) &&
             (ope->operation->cancelled == FAUX) ) {
            if (ope->operation->type == CREDIT) {
                solde += ope->operation->amount;
            } else {
                solde -= ope->operation->amount;
            }
        }
        ope = ope->next;
    }
    
    return solde;
}

char *default_filename (int save_as) {
    char      *filename;
    char    *Home;

    if ( (config.accfilename != NULL) && (save_as == FAUX) )
        return config.accfilename;
    MY_ALLOC (filename, (MAXSTRLEN + 1), char);
    Home = getenv ("HOME");
    sprintf(filename, "%s/%s", Home, ACCOUNT_DEFAULT_FILENAME);
    return filename;
}

int Debug () {
    #ifdef DEBUG_GACC
        return VRAI;
    #endif
    return FAUX;
}

void Usage () {
    printf("Usage: gAcc [-h] [-v] [-f file]\n\
   -h             : short usage help\n\
   -v             : show version\n\
   -f filename    : input account filename\n\n");
    exit(1);
}


char *traite_argv (int argc, char* argv[]) {
    int   ind = 1;
    char *filename = NULL;
    char *month;
    char *year;

    month = get_month_n (COMPILATION_DATE);
    year  = get_year    (COMPILATION_DATE);
    /*
    if (argc == 1) {
        Usage ();
    }
    */
    while (ind < argc) {
        if (argv[ind][0] == '-') {
            switch (argv[ind][1]) {
                case 'h' :
                    printf ("gAcc by Thomas Nemeth - V %s - build on %s %s\n",
                            VERSION,
                            month,
                            year);
                    Usage  ();
                    break;
                case 'v' :
                    printf ("gAcc by Thomas Nemeth - V %s - build on %s %s\n",
                            VERSION,
                            month,
                            year);
                    exit (1);
                    break;
                case 'f' :
                    ind++;
                    MY_ALLOC (filename, strlen (argv[ind]) + 1, char);
                    strcpy (filename, argv[ind]);
                    break;
                default:
                    printf ("Unknown option: %s\n", argv[ind]);
                    Usage  ();
                    break;
            }
        } else {
            printf ("Unknown option: %s\n", argv[ind]);
            Usage  ();
        }
        ind++;
    }
    free (month);
    free (year);

    return filename;
}

int bissextile (int year) {
    if ( (year) % 4 == 0 && ( (year) % 100 != 0 || (year) % 400 == 0) )
        return VRAI;
    return FAUX;
}

int year_size (int year) {
    if (bissextile (year) == VRAI) return 366;
    return 365;
}

int month_size (int year, int month, int day) {
    switch (month) {
        case  1 :
        case  3 :
        case  5 :
        case  7 :
        case  8 :
        case 10 :
        case 12 : return 31 - day;
        case  4 :
        case  6 :
        case  9 :
        case 11 : return 30 - day;
        case  2 : if (bissextile (year) == VRAI) return 29 - day;
                  else return 28 - day;
    }
    return -1;
}

int diffdays (const char *date1, const char *date0) {
    int d0 = get_day_i   (date0);
    int m0 = get_month_i (date0);
    int y0 = get_year_i  (date0);
    int d1 = get_day_i   (date1);
    int m1 = get_month_i (date1);
    int y1 = get_year_i  (date1);
    int result = 0;
    int tmp    = 0;
    int m, y;

    #ifdef DEBUG_GACC
        printf ("Date0 : %d . %d . %d \t Date1 : %d . %d . %d \n",
                 d0, m0, y0, d1, m1, y1);
    #endif
    if ( (y0 == y1) && (m0 == m1) ) return d1 - d0;
    if (y0 == y1) {
        if ( (tmp = month_size (y0, m0, d0) ) == -1) return -1;
        result = tmp;
        m = m0 + 1;
        while (m < m1) {
            if ( (tmp = month_size (y0, m, 0) ) == -1) return -1;
            result += tmp;
            m++;
        }
        result += d1;
        return result;
    }
    if ( (tmp = month_size (y0, m0, d0) ) == -1) return -1;
    result = tmp;
    m = m0 + 1;
    while (m <= 12) {
        if ( (tmp = month_size (y0, m, 0) ) == -1) return -1;
        result += tmp;
        m++;
    }
    y = y0 + 1;
    while (y < y1) {
        result += year_size (y);
        y++;
    }
    m = 1;
    while (m < m1) {
        if ( (tmp = month_size (y1, m, 0) ) == -1) return -1;
        result += tmp;
        m++;
    }
    result += d1;
    return result;
}

int get_hs_nb (const char *first, const char *last) {
    int m0 = get_month_i (first);
    int y0 = get_year_i  (first);
    int m1 = get_month_i (last);
    int y1 = get_year_i  (last);
    int nb = 0;
    int m;
    /* How many scale points will we need ? */
    if (y0 == y1) {
        m  = m0 + 1;
        /* if (m != 13) */ nb = 1;
        if (m == m1) nb++;
    } else {
        m  = m0 + 1;
        if (m != 13) nb = 1;
        while (m <= 12) {m++; nb++; }
        m = 1;
        nb++;
    }
    while (m < m1) { m++; nb++; }
    return nb + 1;
}

void get_hscale (G_LABEL *pts, const char *first, const char *last) {
    int m0 = get_month_i (first);
    int y0 = get_year_i  (first);
    int m1 = get_month_i (last);
    int y1 = get_year_i  (last);
    int nb = 0;
    int m;
    char date[11];

    /* Build scale points' list */
    if (y0 == y1) {
        if ( (m0 != m1) && (m1 != m0 + 1) )
            m  = m0 + 1;
        else m = m0;
        sprintf (date, "%4d%2d01", y0, m);
        #ifdef DEBUG_GACC
            printf (" hscale (a) : diffdays (%s, %s) = %d\n",
                    date, first, diffdays (date, first) );
            printf ("   | pts[%d].x     = %d\n", nb, diffdays (date, first) );
            printf ("   | pts[%d].month = %d\n", nb, m - 1);
        #endif
        pts[nb].x     = diffdays (date, first);
        pts[nb].month = m - 1;
        nb = 1;
    } else {
        m  = m0 + 1;
        if (m != 13) {
            sprintf (date, "%4d%2d01", y0, m);
            #ifdef DEBUG_GACC
                printf (" hscale (b) : diffdays (%s, %s) = %d\n",
                        date, first, diffdays (date, first) );
                printf ("   | pts[%d].x     = %d\n", nb, diffdays (date, first) );
                printf ("   | pts[%d].month = %d\n", nb, m - 1);
            #endif
            pts[nb].x     = diffdays (date, first);
            pts[nb].month = m - 1;
            nb = 1;
        }
        while (m < 12) {
            m++;
            sprintf (date, "%4d%2d01", y0, m);
            #ifdef DEBUG_GACC
                printf (" hscale (c) : diffdays (%s, %s) = %d\n",
                        date, first, diffdays (date, first) );
                printf ("   | pts[%d].x     = %d\n", nb, diffdays (date, first) );
                printf ("   | pts[%d].month = %d\n", nb, m - 1);
            #endif
            pts[nb].x     = diffdays (date, first);
            pts[nb].month = m - 1;
            nb++;
        }
        m = 1;
        sprintf (date, "%4d%2d01", y1, m);
        #ifdef DEBUG_GACC
            printf (" hscale (d) : diffdays (%s, %s) = %d\n",
                    date, first, diffdays (date, first) );
            printf ("   | pts[%d].x     = %d\n", nb, diffdays (date, first) );
            printf ("   | pts[%d].month = %d\n", nb, m - 1);
        #endif
        pts[nb].x     = diffdays (date, first);
        pts[nb].month = m - 1;
        nb++;
    }
    while (m < m1) {
        m++;
        sprintf (date, "%4d%2d01", y1, m);
        #ifdef DEBUG_GACC
            printf (" hscale (e) : diffdays (%s, %s) = %d\n",
                     date, first, diffdays (date, first) );
            printf ("   | pts[%d].x     = %d\n", nb, diffdays (date, first) );
            printf ("   | pts[%d].month = %d\n", nb, m - 1);
        #endif
        pts[nb].x     = diffdays (date, first);
        pts[nb].month = m - 1;
        nb++;
    }
    #ifdef DEBUG_GACC
        printf ("Dernier point : %d\n", nb);
    #endif
    pts[nb].x     = -1;
    pts[nb].month = -1;
}

int get_vscale (int max, int min) {
    int total = max - min;
    int i     = 1;

    #ifdef DEBUG_GACC
        printf ("Valeurs extrmes : MAX = %d\tMIN = %d\n", max, min);
    #endif
    if (total < 10)  return 1;
    if (total < 100) return 10;
    while (i < 1000000000) {
        i *= 10;
        #ifdef DEBUG_GACC
            printf ("i = %d\n", i);
            printf ("10 * i (%d) <= total (%d) && total < 20 * i (%d) : %s\n",
                    10 * i, total, 20 * i,
                    ( (10 * i <= total) && (total < 20 * i) ) ? "OUI" : "NON");
            printf ("20 * i (%d) <= total (%d) && total < 50 * i (%d) : %s\n",
                    20 * i, total, 50 * i,
                    ( (20 * i <= total) && (total < 50 * i) ) ? "OUI" : "NON");
            printf ("50 * i (%d) <= total (%d) && total < 100 * i (%d) : %s\n",
                    50 * i, total, 100 * i,
                    ( (50 * i <= total) && (total < 100 * i) ) ? "OUI" : "NON");
        #endif
        if ( (10 * i <= total) && (total <  20 * i) ) return 1 * i;
        if ( (20 * i <= total) && (total <  50 * i) ) return 2 * i;
        if ( (50 * i <= total) && (total < 100 * i) ) return 5 * i;
    }
    return 1000000000;
}
