/* © 2005 Joachim Breitner
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
# include "../gt_config.h"
#endif

#define GAIM_PLUGINS

#include <unistd.h>

#include "gt_internal.h"

#include <debug.h>
#include <gaim.h>
#include <plugin.h>
#include <conversation.h>
#include <version.h>
#include <eventloop.h>
#include <string.h>

#define OFF    0
#define ON     1
#define TOGGLE 2

#define PROCFILE "/proc/acpi/ibm/light"

static char* commands[2] = {"off", "on"};

struct blinky {
	int	state;
	int	time;
};

static struct blinky seq[4] = {
	{TOGGLE,	150},
	{TOGGLE,	125},
	{TOGGLE,	150},
	{TOGGLE,	0}
};

static guint
blink(struct blinky *seq) {
	FILE *file;
	char *new_state = NULL;
	char old_state[10] = "";
	int ret;

	gaim_debug_info("gaim-thinklight","blink called with parameter: %i\n", seq->state);
	
	if (seq->state == ON)  new_state=commands[ON];
        if (seq->state == OFF) new_state=commands[OFF];
	if (seq->state == TOGGLE) {
 	        gaim_debug_info("gaim-thinklight","trying to toggle\n");
                file = fopen(PROCFILE,"r");
                      if (file == NULL) { perror ("Trying to open " PROCFILE " for reading"); return FALSE;};
                ret = fscanf(file,"status: %9s",old_state);
                      if (ret == EOF)  { perror ("Trying to read from " PROCFILE); return FALSE;};
                ret = fclose(file);
                      if (ret != 0) { perror ("Trying to close " PROCFILE); return FALSE;};
 	        gaim_debug_info("gaim-thinklight","done reading old state %s\n", old_state);

                if (strcmp(old_state,commands[ON])  == 0) new_state=commands[OFF];
                if (strcmp(old_state,commands[OFF]) == 0) new_state=commands[ON];
        }
	
	if (new_state == NULL) {
                gaim_debug_info("gaim-thinklight","No new state defined\n");
		return FALSE;
        }
 	gaim_debug_info("gaim-thinklight","setting new state: %s\n", new_state);

	file = fopen(PROCFILE,"w");
                if (file == NULL) { perror ("Trying to open " PROCFILE " for writing"); return FALSE;};
        ret = fprintf(file,"%s",new_state);
	        if (ret < 0)   { perror ("Trying to write to " PROCFILE); return FALSE;};
        ret = fclose(file);
                if (ret != 0) { perror ("Trying to close " PROCFILE); return FALSE;};

 	gaim_debug_info("gaim-thinklight","done setting new state: %s\n", new_state);
	
	if (seq->time) 
		gaim_timeout_add(seq->time,(GSourceFunc)blink,seq+1);

	return FALSE;
}

	

static void
gt_blink(GaimAccount *account, const gchar *sender,
         const gchar *message, int flags, gpointer data)
{
	blink(seq);
}

static void
gt_events_init(GaimPlugin *plugin) {
	gaim_debug_info("gaim-thinklight","Registering\n");
	gaim_signal_connect(
		gaim_conversations_get_handle(),
		"received-im-msg",
		plugin,
		GAIM_CALLBACK(gt_blink),
		NULL
	);
}


static gboolean
gt_load(GaimPlugin *plugin) {
	gt_events_init(plugin);

	// Make /proc file writable
	if (!fork())
		execl("/usr/lib/gaim-thinklight/thinklight-fixperm","thinklight-fixperm",NULL);

	gaim_debug_info("gaim-thinklight","gaim-thinklight has loaded\n");
	return TRUE;
}

static gboolean
gt_unload(GaimPlugin *plugin) {

	gaim_debug_info("gaim-thinklight","gaim-thinklight has unloaded\n");
	return TRUE;
}

static GaimPluginInfo gt_info = {
	GAIM_PLUGIN_MAGIC,									/* plugin magic		*/
	GAIM_MAJOR_VERSION,									/* major gaim version	*/
	GAIM_MINOR_VERSION,									/* minor gaim version	*/
	GAIM_PLUGIN_STANDARD,									/* type			*/
	"",											/* ui requirement	*/
	0,											/* flags		*/
	NULL,											/* dependencies		*/
	GAIM_PRIORITY_DEFAULT,									/* priority		*/
	"gtk-nomeata-thinklight",								/* id			*/
	NULL,											/* name			*/
	VERSION,										/* version		*/
	NULL,											/* summary		*/
	NULL,											/* description		*/

	"Joachim Breitner <mail@joachim-breitner.de>",						/* author		*/
	GT_WEBSITE,										/* homepage		*/

	gt_load,										/* load			*/
	gt_unload,										/* unload		*/
	NULL,											/* destroy		*/

	NULL,											/* ui info		*/
	NULL,											/* extra info		*/
	NULL,											/* plugin prefs		*/
	NULL											/* plugin actions	*/
};

static void
init_plugin(GaimPlugin *plugin) {

#ifdef ENABLE_NLS
	bindtextdomain(GT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset(GT_PACKAGE, "UTF-8");
#endif

	gt_info.name		= _("Gaim-Thinklight");
	gt_info.summary		= _("Flickering Messages");
	gt_info.description	= _("Gaim-Thinklight:\n"
							"Flashes the ThinkLight upon new messages\n"
							"To use this, you need to have the ibm-acpi kernel module loaded.");

	gaim_debug_info("gaim-thinklight","gaim-thinklight has init'ed");
}

GAIM_INIT_PLUGIN(Gaim-Thinklight, init_plugin, gt_info)
