#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>


#define PROCFILE "/proc/acpi/ibm/light"


int main(int argc, char* argv[]) {
	struct stat *info;

	if (stat(PROCFILE, info) != 0) {
		perror ("Could not stat " PROCFILE);
		exit(EXIT_FAILURE);
	}
	
	if (chmod(PROCFILE, (info->st_mode & 000777) | S_IWOTH) != 0) {
		perror ("Could not change permissions of " PROCFILE);
		exit(EXIT_FAILURE);
	}

	return(EXIT_SUCCESS);
}
