/*
 * Galaxium Messenger
 *
 * Copyright (C) 2007 Paul Burton <paulburton89@gmail.com>
 * Copyright (C) 2007 Philippe Durand <draekz@gmail.com>
 * 
 * License: GNU General Public License (GPL)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Collections;
using System.Drawing;
using System.IO;

using Galaxium.Protocol;

namespace Galaxium.Gui
{
	public class BaseEmoticon: IEmoticon
	{
		private string _name = string.Empty;
		private string[] _equivalents = new string[0];
		private string _filename = string.Empty;
		
		public string Name { get { return _name; } }
		public string[] Equivalents { get { return _equivalents; } }
		public string Filename { get { return _filename; } set { _filename = value; } }
		
		byte[] _data = new byte[0];
		public byte[] Data
		{
			get
			{
				if (((_data == null) || (_data.Length == 0)) && (!string.IsNullOrEmpty(_filename)) && File.Exists(_filename))
					return File.ReadAllBytes(_filename);
				
				return _data;
			}
			set { _data = value; }
		}		
		
		public virtual int Width
		{
			get
			{
				try
				{
					Image img = null;
					
					if (!string.IsNullOrEmpty(_filename) && File.Exists(_filename))
						img = Image.FromFile(_filename);
					else if (_data != null && _data.Length > 0)
					{
						MemoryStream stream = new MemoryStream(_data);
						img = Image.FromStream(stream);
					}
					
					if (img != null)
						return img.Width;
				}
				catch { }
				
				return 0;
			}
		}
		
		public virtual int Height
		{
			get
			{
				try
				{
					Image img = null;
					
					if (!string.IsNullOrEmpty(_filename) && File.Exists(_filename))
						img = Image.FromFile(_filename);
					else if (_data != null && _data.Length > 0)
					{
						MemoryStream stream = new MemoryStream(_data);
						img = Image.FromStream(stream);
					}
					
					if (img != null)
						return img.Height;
				}
				catch { }
				
				return 0;
			}
		}
		
		public BaseEmoticon(string name, string[] equivalents, string filename, byte[] data)
		{
			_name = name;
			_equivalents = equivalents;
			_filename = filename;
			_data = data;
		}
	}
}