/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon-config.h"

#include "nsCOMPtr.h"
#include "nsIURI.h"
#include "nsISupportsArray.h"
#include "nsIServiceManager.h"
#include "nsString.h"
#include "nsReadableUtils.h"
#include "nsIRequestObserver.h"

#include "GlobalHistory.h"

/**
 * class GlobalHistory: 
 *
 */

#if MOZILLA_SNAPSHOT > 13
NS_IMPL_ISUPPORTS2(MozGlobalHistory, nsIGlobalHistory, nsIGlobalHistory2)
#else
NS_IMPL_ISUPPORTS2(MozGlobalHistory, nsIGlobalHistory, nsIBrowserHistory)
#endif

MozGlobalHistory::MozGlobalHistory ()
{
	NS_INIT_ISUPPORTS();

	mGlobalHistory = galeon_embed_shell_get_global_history (embed_shell);
}

MozGlobalHistory::~MozGlobalHistory ()
{
}

#if MOZILLA_SNAPSHOT > 13
/* void addPage (in string aURL); */
NS_IMETHODIMP MozGlobalHistory::AddURI (nsIURI *aURI,
					PRBool aRedirect,
					PRBool aTopLevel)
{
	nsCAutoString spec;
	aURI->GetSpec(spec);

	mLastPageVisited.Assign(spec);

	global_history_visited (mGlobalHistory, spec.get());
	
	return NS_OK;
}
#endif

NS_IMETHODIMP MozGlobalHistory::AddPage (const char *aURL)
{
	global_history_visited (mGlobalHistory, aURL);
	
	return NS_OK;
}

/* boolean isVisited (in string aURL); */
#if MOZILLA_SNAPSHOT > 13
NS_IMETHODIMP MozGlobalHistory::IsVisited (nsIURI *aURI, PRBool *_retval)
{
	nsCAutoString spec;
	aURI->GetSpec(spec);

	*_retval = global_history_is_visited (mGlobalHistory, spec.get());

	return NS_OK;
}
#endif

NS_IMETHODIMP MozGlobalHistory::IsVisited (const char *aURL, PRBool *_retval)
{
	*_retval = global_history_is_visited (mGlobalHistory, aURL);
	
	return NS_OK;
}

/* void setPageTitle (in string aURL, in wstring aTitle); */
#if MOZILLA_SNAPSHOT > 13
NS_IMETHODIMP MozGlobalHistory::SetPageTitle (nsIURI *aURI, 
					      const nsAString& aTitle)
{
	const nsACString &title = NS_ConvertUCS2toUTF8(aTitle);

	nsCAutoString spec;
	aURI->GetSpec(spec);

	global_history_set_page_title(mGlobalHistory, spec.get(),
				      PromiseFlatCString(title).get());

	return NS_OK;
}
#else
NS_IMETHODIMP MozGlobalHistory::SetPageTitle (const char *aURL, 
					      const PRUnichar *aTitle)
{
	const nsACString &title = NS_ConvertUCS2toUTF8 (aTitle);
	
	global_history_set_page_title (mGlobalHistory, aURL, PromiseFlatCString(title).get());

	/* done */
	return NS_OK;
}
#endif

/* void removePage (in string aURL); */
NS_IMETHODIMP MozGlobalHistory::RemovePage(const char *aURL)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removePagesFromHost (in string aHost, in boolean aEntireDomain); */
NS_IMETHODIMP MozGlobalHistory::RemovePagesFromHost(const char *aHost, 
						 PRBool aEntireDomain)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeAllPages (); */
NS_IMETHODIMP MozGlobalHistory::RemoveAllPages()
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

#if MOZILLA_SNAPSHOT > 14
/* readonly attribute string lastPageVisited; */
NS_IMETHODIMP MozGlobalHistory::GetLastPageVisited(nsACString& aLastPageVisited)
{
	aLastPageVisited.Assign(mLastPageVisited);
	return NS_OK;
}
#else
/* readonly attribute string lastPageVisited; */
NS_IMETHODIMP MozGlobalHistory::GetLastPageVisited(char **aLastPageVisited)
{
	*aLastPageVisited = ToNewCString(mLastPageVisited);
	return NS_OK;
}
#endif

/* readonly attribute PRUint32 count; */
NS_IMETHODIMP MozGlobalHistory::GetCount(PRUint32 *aCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

#if MOZILLA_SNAPSHOT > 8 && MOZILLA_SNAPSHOT <= 13
NS_IMETHODIMP MozGlobalHistory::SetLastPageVisited(const char *aLastPageVisited)
{
	mLastPageVisited.Assign(aLastPageVisited);
	return NS_OK;
}
#endif

#if MOZILLA_SNAPSHOT > 13
NS_IMETHODIMP MozGlobalHistory::HidePage(nsIURI *url)
{
	return NS_ERROR_NOT_IMPLEMENTED;

}
#else
NS_IMETHODIMP MozGlobalHistory::HidePage(const char *url)
{
	return NS_ERROR_NOT_IMPLEMENTED;

}
#endif

/* void markPageAsTyped (in string url); */
NS_IMETHODIMP MozGlobalHistory::MarkPageAsTyped(const char *url)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
