/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.StatusUpdate;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.OsShutdown;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class UploadProgress
extends JDialog
implements StatusUpdate,
ActionListener {
    public static final String MODULE = "UploadProgress";
    JPanel jPanel1 = new JPanel();
    JLabel jComputer1 = new JLabel();
    JLabel jUploading = new JLabel();
    JLabel jComputer2 = new JLabel();
    JLabel jLabelGlobal = new JLabel();
    JProgressBar jProgressGlobal = new JProgressBar();
    JLabel jLabelDetail = new JLabel();
    JProgressBar jProgressDetail = new JProgressBar();
    JPanel jPanel2 = new JPanel();
    JLabel[] jLabel = new JLabel[6];
    JProgressBar[] jProgress = new JProgressBar[6];
    ActionListener cancelListener = null;
    JButton jCancel = new JButton();
    JCheckBox jShutdown = new JCheckBox();

    public UploadProgress(Frame f) {
        super(f);
        this.jbInit();
        this.jLabel[3] = this.jLabelDetail;
        this.jLabel[4] = this.jLabelGlobal;
        this.jProgress[3] = this.jProgressDetail;
        this.jProgress[4] = this.jProgressGlobal;
        try {
            this.pack();
        }
        catch (NullPointerException e) {
            Log.log(1, MODULE, "Wierd VM bug");
            Log.logException(1, MODULE, e);
            this.setSize(400, 300);
        }
        DialogUtil.center(this, f);
        this.setVisible(true);
    }

    private void jbInit() {
        this.setDefaultCloseOperation(0);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jComputer1.setIcon(GalleryRemote.iComputer);
        this.jComputer2.setIcon(GalleryRemote.iComputer);
        this.jUploading.setIcon(GalleryRemote.iUploading);
        this.jLabelGlobal.setText(GRI18n.getString(MODULE, "upImgNM"));
        this.jLabelDetail.setText(GRI18n.getString(MODULE, "upImgGif"));
        this.jCancel.setText(GRI18n.getString(MODULE, "Cancel"));
        this.jCancel.addActionListener(this);
        this.jCancel.setActionCommand("Cancel");
        this.jShutdown.setToolTipText(GRI18n.getString(MODULE, "shutDownTip"));
        this.jShutdown.setText(GRI18n.getString(MODULE, "shutDown"));
        this.jPanel1.add((Component)this.jComputer1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jUploading, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jComputer2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.jPanel1.add((Component)this.jLabelGlobal, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jProgressGlobal, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 15, 0, 15), 0, 0));
        this.jPanel1.add((Component)this.jLabelDetail, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jProgressDetail, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 15, 0, 15), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        try {
            if (OsShutdown.canShutdown()) {
                this.jPanel2.add((Component)this.jShutdown, null);
            }
        }
        catch (NoClassDefFoundError e) {
            Log.log(3, MODULE, "OsShutdown not supported, hiding checkbox");
        }
        this.jPanel2.add((Component)this.jCancel, null);
    }

    public void startProgress(int level, int minValue, int maxValue, String message, boolean undetermined) {
        if (this.checkLevel(level)) {
            this.jProgress[level].setMinimum(minValue);
            this.jProgress[level].setMaximum(maxValue);
            try {
                this.jProgress[level].setIndeterminate(undetermined);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.jLabel[level].setText(message);
        }
    }

    public void updateProgressValue(int level, int value) {
        if (this.checkLevel(level)) {
            this.jProgress[level].setValue(value);
        }
    }

    public void updateProgressValue(int level, int value, int maxValue) {
        if (this.checkLevel(level)) {
            this.jProgress[level].setValue(value);
            this.jProgress[level].setMaximum(maxValue);
        }
    }

    public void updateProgressStatus(int level, String message) {
        if (this.checkLevel(level)) {
            this.jLabel[level].setText(message);
        }
    }

    public void setUndetermined(int level, boolean undetermined) {
        try {
            this.jProgress[level].setIndeterminate(undetermined);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void stopProgress(int level, String message) {
        if (this.checkLevel(level)) {
            this.jProgress[level].setMaximum(this.jProgress[level].getMinimum());
            this.jLabel[level].setText(message);
            try {
                this.jProgress[level].setIndeterminate(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (level == 4) {
                this.setVisible(false);
            }
        }
    }

    public void setInProgress(boolean inProgress) {
        GalleryRemote._().getCore().setInProgress(inProgress);
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, GRI18n.getString(MODULE, "Error"), 0);
    }

    public void setStatus(String message) {
        this.updateProgressStatus(0, message);
    }

    public int getProgressValue(int level) {
        if (this.checkLevel(level)) {
            return this.jProgress[level].getValue();
        }
        return 0;
    }

    public int getProgressMinValue(int level) {
        if (this.checkLevel(level)) {
            return this.jProgress[level].getMinimum();
        }
        return 0;
    }

    public int getProgressMaxValue(int level) {
        if (this.checkLevel(level)) {
            return this.jProgress[level].getMaximum();
        }
        return 0;
    }

    boolean checkLevel(int level) {
        return level == 3 || level == 4;
    }

    public void actionPerformed(ActionEvent e) {
        final ActionEvent fe = e;
        new Thread(){

            public void run() {
                if (UploadProgress.this.cancelListener != null) {
                    UploadProgress.this.cancelListener.actionPerformed(fe);
                }
            }
        }.start();
    }

    public void setCancelListener(ActionListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    public boolean isShutdown() {
        return this.jShutdown.isSelected();
    }
}

