/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote.prefs;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.prefs.PreferencePanel;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PreferencesDialog
extends JDialog
implements ListSelectionListener,
ActionListener {
    public static final String MODULE = "PrefsDlog";
    DefaultListModel panels = new DefaultListModel();
    HashMap panelNames = new HashMap();
    private boolean isOK = false;
    JPanel jPanel1 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList jIcons = new JList();
    JPanel jPanels = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    CardLayout jPanelsLayout = new CardLayout();
    JPanel jPanel2 = new JPanel();
    JButton jOK = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    JButton jRevert = new JButton();
    JButton jCancel = new JButton();

    public PreferencesDialog(Frame owner) {
        super(owner, true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Log.logException((int)1, (String)MODULE, (Throwable)e);
        }
        this.loadPanes();
        this.jIcons.setSelectedIndex(0);
        DialogUtil.center((Window)this, (Window)owner);
    }

    private void loadPanes() {
        Properties panes = new Properties();
        try {
            panes.load(this.getClass().getResourceAsStream("panes.properties"));
            int i = 1;
            String className = null;
            while ((className = panes.getProperty("pane." + i++)) != null) {
                try {
                    PreferencePanel pp = (PreferencePanel)Class.forName(className).newInstance();
                    pp.setDialog((JDialog)this);
                    pp.buildUI();
                    this.panels.addElement(pp);
                    this.jPanels.add(className, (Component)pp);
                    this.panelNames.put(className, pp);
                }
                catch (Exception e) {
                    Log.log((int)1, (String)MODULE, (String)("Bad panel: " + className));
                    Log.logException((int)1, (String)MODULE, (Throwable)e);
                }
            }
            this.jIcons.setModel(this.panels);
        }
        catch (IOException e) {
            Log.logException((int)1, (String)MODULE, (Throwable)e);
        }
    }

    public void setPanel(String className) {
        PreferencePanel pp = (PreferencePanel)this.panelNames.get(className);
        this.jIcons.setSelectedValue(pp, true);
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jScrollPane1.setAlignmentY(0.5f);
        this.jScrollPane1.setPreferredSize(new Dimension(100, 200));
        this.jPanels.setLayout(this.jPanelsLayout);
        this.setTitle(GRI18n.getString((String)MODULE, (String)"title"));
        this.jOK.setMnemonic('0');
        this.jOK.setText(GRI18n.getString((String)"Common", (String)"OK"));
        this.jOK.setActionCommand("OK");
        this.jPanel2.setLayout(this.gridLayout1);
        this.jRevert.setToolTipText(GRI18n.getString((String)MODULE, (String)"revertTip"));
        this.jRevert.setText(GRI18n.getString((String)MODULE, (String)"revert"));
        this.jRevert.setActionCommand("revert");
        this.jCancel.setText(GRI18n.getString((String)"Common", (String)"Cancel"));
        this.jCancel.setActionCommand("cancel");
        this.gridLayout1.setHgap(5);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(10, 10, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanels, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanel2.add((Component)this.jOK, null);
        this.jScrollPane1.getViewport().add((Component)this.jIcons, null);
        this.jPanel2.add((Component)this.jCancel, null);
        this.jPanel2.add((Component)this.jRevert, null);
        this.jIcons.setCellRenderer(new IconsCellRenderer());
        this.jIcons.addListSelectionListener(this);
        this.jOK.addActionListener(this);
        this.jCancel.addActionListener(this);
        this.jRevert.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.getRootPane().setDefaultButton(this.jOK);
    }

    public void valueChanged(ListSelectionEvent e) {
        PreferencePanel pp = (PreferencePanel)this.jIcons.getSelectedValue();
        String className = pp.getClass().getName();
        Log.log((int)3, (String)MODULE, (String)("Showing panel: " + className));
        pp.readPropertiesFirst(GalleryRemote._().properties);
        this.jPanelsLayout.show(this.jPanels, className);
        this.jRevert.setEnabled(pp.isReversible());
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        Log.log((int)2, (String)MODULE, (String)("Command selected " + cmd));
        if (cmd.equals("OK")) {
            GalleryRemote._().properties.uncache();
            Enumeration enumeration = this.panels.elements();
            while (enumeration.hasMoreElements()) {
                PreferencePanel pp = (PreferencePanel)enumeration.nextElement();
                if (!pp.hasBeenRead()) continue;
                Log.log((int)3, (String)MODULE, (String)("Writing properties for panel " + pp.getClass()));
                pp.writeProperties(GalleryRemote._().properties);
            }
            this.isOK = true;
            this.setVisible(false);
        } else if (cmd.equals("cancel")) {
            this.setVisible(false);
        } else if (cmd.equals("revert")) {
            PreferencePanel pp = (PreferencePanel)this.jIcons.getSelectedValue();
            Log.log((int)3, (String)MODULE, (String)("Reverting panel " + pp.getClass()));
            pp.readProperties(GalleryRemote._().properties);
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public class IconsCellRenderer
    extends DefaultListCellRenderer {
        public IconsCellRenderer() {
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setHorizontalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
            if (value != null && index != -1) {
                PreferencePanel pp = (PreferencePanel)value;
                this.setText(pp.getIcon().getText());
                this.setIcon(pp.getIcon().getIcon());
            } else {
                this.setText("dummy");
            }
            return this;
        }
    }
}

