/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.DroppableList;
import com.gallery.GalleryRemote.GRApplet;
import com.gallery.GalleryRemote.GRAppletMini;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.GalleryRemoteCore;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.SlideshowFrame;
import com.gallery.GalleryRemote.StatusBar;
import com.gallery.GalleryRemote.model.Album;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.prefs.PreferenceNames;
import com.gallery.GalleryRemote.prefs.SlideshowPanel;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class GRAppletSlideshow
extends GRAppletMini
implements GalleryRemoteCore,
ActionListener,
ListDataListener,
PreferenceNames {
    public static final String MODULE = "AppletSlideshow";
    JButton jStart;
    SlideshowPanel jSlidePanel;
    SlideshowFrame slideshowFrame = null;
    GRApplet.AppletInfo info;

    public GRAppletSlideshow() {
        this.coreClass = "com.gallery.GalleryRemote.GalleryRemoteMini";
    }

    public void startup() {
        this.galleries = new DefaultComboBoxModel();
        this.info = this.getGRAppletInfo();
        this.gallery = this.info.gallery;
        this.galleries.addElement(this.gallery);
        ImageUtils.deferredTasks();
        this.album = new Album(this.gallery);
        this.album.setName(this.info.albumName);
        this.album.addListDataListener(this);
        this.album.fetchAlbumImages(this.jStatusBar, GalleryRemote._().properties.getBooleanProperty("slideshowRecursive", true), GalleryRemote._().properties.getIntProperty("slideshowMaxPictures", 0));
    }

    protected void jbInit() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.jStart = new JButton(GRI18n.getString(MODULE, "Start"));
        this.jStatusBar = new StatusBar(75);
        this.jSlidePanel = new SlideshowPanel();
        this.getContentPane().add((Component)this.jSlidePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JLabel(GRI18n.getString(MODULE, "Disabled")), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)this.jStart, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.getContentPane().add((Component)this.jStatusBar, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jSlidePanel.buildUI();
        this.jSlidePanel.remove(this.jSlidePanel.spacerPanel);
        this.jSlidePanel.readProperties(GalleryRemote._().properties);
        this.jStart.addActionListener(this);
        this.jStart.setEnabled(false);
        this.jPicturesList = new DroppableList();
    }

    public void setInProgress(boolean inProgress) {
        this.jStart.setEnabled(!inProgress && this.album.getSize() > 0);
        this.inProgress = inProgress;
    }

    public void actionPerformed(ActionEvent e) {
        this.jSlidePanel.writeProperties(GalleryRemote._().properties);
        if (this.slideshowFrame == null) {
            this.slideshowFrame = new SlideshowFrame();
        }
        this.slideshowFrame.showSlideshow();
        this.slideshowFrame.start(this.album.getPicturesList());
        this.slideshowFrame = null;
    }

    public void shutdown() {
        if (this.hasStarted && GalleryRemote._() != null) {
            this.jSlidePanel.writeProperties(GalleryRemote._().properties);
        }
        super.shutdown();
    }

    public void contentsChanged(ListDataEvent e) {
        if (this.album.isHasFetchedImages()) {
            Log.log(3, MODULE, "Pictures were just added to the album. Preload the first one.");
            new Thread(){

                public void run() {
                    GRAppletSlideshow.this.slideshowFrame = new SlideshowFrame();
                    int index = 0;
                    ArrayList picturesList = GRAppletSlideshow.this.album.getPicturesList();
                    if (GRAppletSlideshow.this.info.slideshowFrom != null) {
                        for (int i = 0; i < picturesList.size(); ++i) {
                            if (!GRAppletSlideshow.this.info.slideshowFrom.equals(((Picture)picturesList.get(i)).getUniqueId())) continue;
                            Log.log(3, GRAppletSlideshow.MODULE, "Starting slideshow from index " + i);
                            index = i;
                            GRAppletSlideshow.this.slideshowFrame.wantIndex = i - 1;
                            break;
                        }
                    }
                    if (GRAppletSlideshow.this.album.getSize() > index) {
                        ImageUtils.download((Picture)picturesList.get(index), GRAppletSlideshow.this.getGraphicsConfiguration().getBounds().getSize(), GalleryRemote._().getCore().getMainStatusUpdate(), null);
                    } else {
                        JOptionPane.showMessageDialog(GRAppletSlideshow.this, GRI18n.getString(GRAppletSlideshow.MODULE, "emptyAlbum"));
                    }
                }
            }.start();
        }
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }
}

