<?php
/*
 * $RCSfile: GalleryDerivative.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @package GalleryCore
 * @subpackage ClassInterfaces
 * @version $Revision: 1.44 $ $Date: 2005/08/23 03:49:04 $
 * @author Bharat Mediratta <bharat@menalto.com>
 */

/**
 * Interface class for the GalleryDerivative class.
 * (Class schema version: 1.1)
 *
 * This file is automatically generated from XML embedded in the
 * class, combined with the ClassCode.xsl file.  You should not modify
 * it by hand, as your changes will be lost next time this file is
 * rebuilt.  If you want to add more getters/setters, you should add
 * them in the core class.  If you want to change the format of this
 * file, then you should edit the XSL template.
 *
 * @package GalleryCore
 * @subpackage Classes
 */
class GalleryDerivative extends GalleryDerivative_core {
  
    /**
     * Return meta information about the members of this class
     *
     * @return array member => array(type, class)
     */
    function getPersistentMemberInfo() {
	$meta = parent::getPersistentMemberInfo();
	$meta['members']['derivativeSourceId'] = array('class' => 'GalleryDerivative', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['derivativeOperations'] = array('class' => 'GalleryDerivative', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['derivativeOrder'] = array('class' => 'GalleryDerivative', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['derivativeSize'] = array('class' => 'GalleryDerivative', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['derivativeType'] = array('class' => 'GalleryDerivative', 'type' => STORAGE_TYPE_INTEGER);
    
	$meta['members']['mimeType'] = array('class' => 'GalleryDerivative', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['postFilterOperations'] = array('class' => 'GalleryDerivative', 'type' => STORAGE_TYPE_STRING);
    
	$meta['members']['isBroken'] = array('class' => 'GalleryDerivative', 'type' => STORAGE_TYPE_BOOLEAN);
    
	return $meta;
    }

    /**
     * Get the data from this persistent object as an associative array
     *
     * @return array memberName => memberValue
     */
    function getMemberData() {
	$data = parent::getMemberData();
        $data['derivativeSourceId'] = isset($this->_derivativeSourceId) ? $this->_derivativeSourceId : null;
        $data['derivativeOperations'] = isset($this->_derivativeOperations) ? $this->_derivativeOperations : null;
        $data['derivativeOrder'] = isset($this->_derivativeOrder) ? $this->_derivativeOrder : null;
        $data['derivativeSize'] = isset($this->_derivativeSize) ? $this->_derivativeSize : null;
        $data['derivativeType'] = isset($this->_derivativeType) ? $this->_derivativeType : null;
        $data['mimeType'] = isset($this->_mimeType) ? $this->_mimeType : null;
        $data['postFilterOperations'] = isset($this->_postFilterOperations) ? $this->_postFilterOperations : null;
        $data['isBroken'] = isset($this->_isBroken) ? $this->_isBroken : null;
	return $data;
    }
  
    /**
     * Return the name of this class with the proper mix of uppercase and
     * lowercase (get_class() always returns lowercase)
     *
     * @return string class name
     */
    function getClassName() {
	return 'GalleryDerivative';
    }

    /** 
     * Return the path to the PHP file for this class, relative to the gallery2 dir
     * 
     * @return string path
     */ 
    function getClassFile() { 
        return 'modules/' .  
            basename(dirname(dirname(dirname(__FILE__)))) .  
            '/classes/GalleryDerivative.class'; 
    }
    
    /**
     * Get the value of derivativeSourceId
     *
     * @return INTEGER the value
     */
    function getderivativeSourceId() {
	if (!isset($this->_derivativeSourceId)) {
	    return null;
	}
	return $this->_derivativeSourceId;
    }

    /**
     * Set the value of derivativeSourceId
     *
     * @param INTEGER the value
     */
    function setderivativeSourceId($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_derivativeSourceId) ? $this->_derivativeSourceId : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('derivativeSourceId', $value);
	    $this->_derivativeSourceId = $value;
	}
    }
  
    /**
     * Get the value of derivativeOperations
     *
     * @return STRING the value
     */
    function getderivativeOperations() {
	if (!isset($this->_derivativeOperations)) {
	    return null;
	}
	return $this->_derivativeOperations;
    }

    /**
     * Set the value of derivativeOperations
     *
     * @param STRING the value
     */
    function setderivativeOperations($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 255);
	$orig = isset($this->_derivativeOperations) ? $this->_derivativeOperations : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('derivativeOperations', $value);
	    $this->_derivativeOperations = $value;
	}
    }
  
    /**
     * Get the value of derivativeOrder
     *
     * @return INTEGER the value
     */
    function getderivativeOrder() {
	if (!isset($this->_derivativeOrder)) {
	    return null;
	}
	return $this->_derivativeOrder;
    }

    /**
     * Set the value of derivativeOrder
     *
     * @param INTEGER the value
     */
    function setderivativeOrder($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_derivativeOrder) ? $this->_derivativeOrder : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('derivativeOrder', $value);
	    $this->_derivativeOrder = $value;
	}
    }
  
    /**
     * Get the value of derivativeSize
     *
     * @return INTEGER the value
     */
    function getderivativeSize() {
	if (!isset($this->_derivativeSize)) {
	    return null;
	}
	return $this->_derivativeSize;
    }

    /**
     * Set the value of derivativeSize
     *
     * @param INTEGER the value
     */
    function setderivativeSize($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_derivativeSize) ? $this->_derivativeSize : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('derivativeSize', $value);
	    $this->_derivativeSize = $value;
	}
    }
  
    /**
     * Get the value of derivativeType
     *
     * @return INTEGER the value
     */
    function getderivativeType() {
	if (!isset($this->_derivativeType)) {
	    return null;
	}
	return $this->_derivativeType;
    }

    /**
     * Set the value of derivativeType
     *
     * @param INTEGER the value
     */
    function setderivativeType($value) {
	/* Type cast the incoming value to be an integer */
	if ($value != null) {
	    $value = (int)$value;
	}
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_derivativeType) ? $this->_derivativeType : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('derivativeType', $value);
	    $this->_derivativeType = $value;
	}
    }
  
    /**
     * Get the value of mimeType
     *
     * @return STRING the value
     */
    function getmimeType() {
	if (!isset($this->_mimeType)) {
	    return null;
	}
	return $this->_mimeType;
    }

    /**
     * Set the value of mimeType
     *
     * @param STRING the value
     */
    function setmimeType($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 128);
	$orig = isset($this->_mimeType) ? $this->_mimeType : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('mimeType', $value);
	    $this->_mimeType = $value;
	}
    }
  
    /**
     * Get the value of postFilterOperations
     *
     * @return STRING the value
     */
    function getpostFilterOperations() {
	if (!isset($this->_postFilterOperations)) {
	    return null;
	}
	return $this->_postFilterOperations;
    }

    /**
     * Set the value of postFilterOperations
     *
     * @param STRING the value
     */
    function setpostFilterOperations($value) {
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
        $value = $this->_truncateString($value, 255);
	$orig = isset($this->_postFilterOperations) ? $this->_postFilterOperations : null;

        /* Only take action if the value actually changes */
        if ($value != $orig) {
	    $this->setModifiedFlag('postFilterOperations', $value);
	    $this->_postFilterOperations = $value;
	}
    }
  
    /**
     * Get the value of isBroken
     *
     * @return BOOLEAN the value
     */
    function getisBroken() {
	if (!isset($this->_isBroken)) {
	    return null;
	}
	return $this->_isBroken;
    }

    /**
     * Set the value of isBroken
     *
     * @param BOOLEAN the value
     */
    function setisBroken($value) {
	/* Set the incoming value to be a 1 or 0 */
	$value = empty($value) ? 0 : 1;
        
	/* Convert unset values to null, to avoid generating warnings. */
	$value = isset($value) ? $value : null;
      
	$orig = isset($this->_isBroken) ? $this->_isBroken : null;

        /* Only take action if the value actually changes */
        if ($value !== $orig) {
	    $this->setModifiedFlag('isBroken', $value);
	    $this->_isBroken = $value;
	}
    }
  
}
?>
