<?php
/*
 * $RCSfile: AdminSelfRegistration.inc,v $
 *
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2005 Bharat Mediratta
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA  02110-1301, USA.
 */
/**
 * @version $Revision: 1.11 $ $Date: 2005/08/23 03:49:52 $
 * @package SelfRegistration
 * @author Sebastian Eichner <mailsp@sebastian-eichner.de>
 */

/**
 * @package SelfRegistration
 * @subpackage UserInterface
 */
class AdminSelfRegistrationController extends GalleryController {

    /**
     * @see GalleryController::handleRequest
     */
    function handleRequest($form) {
	global $gallery;

	$ret = GalleryCoreApi::assertUserIsSiteAdministrator();
	if ($ret->isError()) {
	    return array($ret->wrap(__FILE__, __LINE__), null);
	}

	$error = array();
	$status = array();
	if (isset($form['action']['save'])) {

	    $form['emailadmins'] = isset($form['emailadmins']) ? 1 : 0;
	    foreach (array('confirmation', 'emailadmins', 'adminsubject', 'subject', 'from')
		    as $key) {
		if (isset($form[$key])) {
		    $ret = GalleryCoreApi::setPluginParameter(
					   'module', 'register', $key, trim($form[$key]));
		    if ($ret->isError()) {
			return array($ret->wrap(__FILE__, __LINE__), null);
		    }
		}
	    }

	    $status['saved'] = 1;
	} else if (isset($form['action']['activate'])) {
	    GalleryCoreApi::relativeRequireOnce(
		'modules/register/classes/GalleryPendingUserHelper.class');
	    list ($ret, $pendingUser) = GalleryCoreApi::loadEntitiesById($form['userId']);
	    if ($ret->isError()) {
		return array($ret->wrap(__FILE__, __LINE__), null);
	    }
	    $userName = $pendingUser->getUserName();
	    $ret = GalleryPendingUserHelper::createGalleryUser($pendingUser);
	    if ($ret->isError()) {
		return array($ret->wrap(__FILE__, __LINE__), null);
	    }
	    $status['activated'] = $userName;
	} else if (isset($form['action']['delete'])) {
	    list ($ret, $pendingUser) = GalleryCoreApi::loadEntitiesById($form['userId']);
	    if ($ret->isError()) {
		return array($ret->wrap(__FILE__, __LINE__), null);
	    }
	    $userName = $pendingUser->getUserName();
	    list($ret, $lock) = GalleryCoreApi::acquireWriteLock(array($pendingUser->getId()));
	    if ($ret->isError()) {
		return array($ret->wrap(__FILE__, __LINE__), null);
	    }
	    $ret = $pendingUser->delete();
	    if ($ret->isError()) {
		return array($ret->wrap(__FILE__, __LINE__), null);
	    }
	    $ret = GalleryCoreApi::releaseLocks($lock);
	    if ($ret->isError()) {
		return array($ret->wrap(__FILE__, __LINE__), null);
	    }
	    $status['deleted'] = $userName;
	} /* else $form['action']['cancel'] */

	if (empty($error)) {
	    $results['redirect'] = array('view' => 'core.SiteAdmin',
					 'subView' => 'register.AdminSelfRegistration');
	} else {
	    $results['delegate']['view'] = 'core.SiteAdmin';
	    $results['delegate']['subView'] = 'register.AdminSelfRegistration';
	}
	$results['status'] = $status;
	$results['error'] = $error;

	return array(GalleryStatus::success(), $results);
    }
}

/**
 * @package SelfRegistration
 * @subpackage UserInterface
 */
class AdminSelfRegistrationView extends GalleryView {

    /**
     * @see GalleryView::loadTemplate
     */
    function loadTemplate(&$template, &$form) {
	GalleryCoreApi::relativeRequireOnce(
	    'modules/register/classes/GalleryPendingUserHelper.class');
	global $gallery;

	list($ret, $module) = GalleryCoreApi::loadPlugin('module', 'register');
	if ($ret->isError())
	    return array($ret->wrap(__FILE__, __LINE__), null);

	/* Load our default values if we didn't just come from this form. */
	if ($form['formName'] != 'AdminSelfRegistration') {
	    foreach (array('confirmation', 'emailadmins', 'adminsubject', 'subject', 'from')
		    as $key) {
		list ($ret, $form[$key]) =
		    GalleryCoreApi::getPluginParameter('module', 'register', $key);
		if ($ret->isError()) {
		    return array($ret->wrap(__FILE__, __LINE__), null);
		}
	    }
	    $form['formName'] = 'AdminSelfRegistration';
	}

	if (!isset($form['list']['page']) || $form['list']['page'] < 1) {
	    $form['list']['page'] = 1;
	}

	list ($ret, $form['list']['count']) = GalleryPendingUserHelper::fetchUserCount();
	if ($ret->isError()) {
	    return array($ret->wrap(__FILE__, __LINE__), null);
	}
	if ($form['list']['count'] > 0) {

	    $form['list']['pageSize'] = min($form['list']['count'], 10);
	    $form['list']['maxPages'] = ceil($form['list']['count'] / $form['list']['pageSize']);
	    if ($form['list']['page'] > $form['list']['maxPages']) {
		$form['list']['page'] = $form['list']['maxPages'];
	    }
	    $form['list']['nextPage'] = min($form['list']['page']+1, $form['list']['maxPages']);
	    $form['list']['backPage'] = max(1, $form['list']['page']-1);

	    list ($ret, $form['list']['userNames']) = GalleryPendingUserHelper::fetchUserData(
		$form['list']['pageSize'], ($form['list']['page'] - 1) * $form['list']['pageSize']);
	    if ($ret->isError()) {
		return array($ret->wrap(__FILE__, __LINE__), null);
	    }
	}

	$selfregistration = array();
	$selfregistration['emailConfirmationList'] = array(
	    'admin' => $module->translate('Activation by administrator'),
	    'email' => $module->translate('Use confirmation emails'),
	    'auto' => $module->translate('Accept without confirmation') );
	$selfregistration['reallySendList'] = array(
	    'true' => $module->translate('Yes'), 'false' => $module->translate('No') );
	$template->setVariable('SelfRegistration', $selfregistration);
	$template->setVariable('controller', 'register.AdminSelfRegistration');

	return array(GalleryStatus::success(),
		     array('body' => 'modules/register/templates/AdminSelfRegistration.tpl'));
    }
}
?>
