/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import HTTPClient.Cookie;
import HTTPClient.CookieModule;
import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.model.Gallery;
import com.gallery.GalleryRemote.util.DialogUtil;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class GRApplet
extends JApplet {
    public static final String MODULE = "GRApplet";
    protected JLabel jLabel;
    boolean hasStarted = false;
    String coreClass = "com.gallery.GalleryRemote.GalleryRemoteMainFrame";

    public void init() {
        System.out.println("Applet init");
    }

    public void start() {
        System.out.println("Applet transitionStart");
        this.initGalleryRemote();
        if (this.hasStarted) {
            GalleryRemote._().initializeGR();
            String localeString = this.getParameter("gr_locale");
            if (localeString != null && localeString.length() > 1) {
                Locale locale = GRI18n.parseLocaleString(localeString);
                GRI18n.setLocale(locale.getLanguage(), locale.getCountry());
                Log.log(2, MODULE, "Set locale to: " + locale);
            }
            this.initUI();
            new Thread(){

                public void run() {
                    GalleryRemote._().runGR();
                }
            }.start();
        } else {
            this.initDummyUI();
        }
    }

    protected void initUI() {
        this.jLabel = new JLabel("<HTML><CENTER>The Gallery Remote applet is running. Please don't close this window or navigate away!</CENTER></HTML>");
        this.getContentPane().add(this.jLabel);
    }

    protected void initDummyUI() {
        this.jLabel = new JLabel("<HTML><CENTER>The Gallery Remote applet is not running because another is running in the same browser</CENTER></HTML>");
        this.getContentPane().add(this.jLabel);
    }

    protected void initGalleryRemote() {
        if (!GalleryRemote.createInstance(this.coreClass, this)) {
            JOptionPane.showMessageDialog(DialogUtil.findParentWindow(this), "Only one instance of the Gallery Remote can run at the same time...", "Error", 0);
        } else {
            this.hasStarted = true;
        }
    }

    public void stop() {
        System.out.println("Applet stop");
        if (this.hasStarted && GalleryRemote._() != null) {
            GalleryRemote._().getCore().shutdown();
        }
        ImageUtils.purgeTemp();
        Log.log(2, MODULE, "Shutting down log");
        Log.shutdown();
    }

    public void hasShutdown() {
        this.jLabel.setText("<HTML><CENTER>The Gallery Remote applet has stopped, you can navigate away or close the window</CENTER></HTML>");
    }

    protected AppletInfo getGRAppletInfo() {
        AppletInfo info = new AppletInfo();
        info.gallery = new Gallery(GalleryRemote._().getCore().getMainStatusUpdate());
        info.gallery.setBlockWrites(true);
        String url = this.getParameter("gr_url");
        String urlFull = this.getParameter("gr_url_full");
        String urlOverride = this.getParameter("gr_url_override");
        String cookieName = this.getParameter("gr_cookie_name");
        String cookieValue = this.getParameter("gr_cookie_value");
        String cookieDomain = this.getParameter("gr_cookie_domain");
        String cookiePath = this.getParameter("gr_cookie_path");
        String userAgent = this.getParameter("gr_user_agent");
        String galleryVersion = this.getParameter("gr_gallery_version");
        String slideshowFrom = this.getParameter("gr_slideshow_start_from");
        info.albumName = this.getParameter("gr_album");
        Log.log(2, MODULE, "Applet parameters:");
        Log.log(2, MODULE, "gr_url: " + url);
        Log.log(2, MODULE, "gr_url_full: " + urlFull);
        Log.log(2, MODULE, "gr_url_override: " + urlOverride);
        Log.log(2, MODULE, "gr_cookie_name: " + cookieName);
        Log.log(2, MODULE, "gr_cookie_domain: " + cookieDomain);
        Log.log(2, MODULE, "gr_cookie_path: " + cookiePath);
        Log.log(2, MODULE, "gr_album: " + info.albumName);
        Log.log(2, MODULE, "gr_user_agent: " + userAgent);
        Log.log(2, MODULE, "gr_gallery_version: " + galleryVersion);
        Log.log(2, MODULE, "gr_slideshow_start_from: " + slideshowFrom);
        if (cookieDomain == null || cookieDomain.length() < 1) {
            try {
                cookieDomain = new URL(url).getHost();
            }
            catch (MalformedURLException e) {
                URL documentBase = this.getDocumentBase();
                cookieDomain = documentBase.getHost();
                Log.log(2, MODULE, "URL probably doesn't have a host part because the Gallery is in (unsupported) relative mode. Using the Applet documentBase: " + cookieDomain);
                try {
                    url = new URL(documentBase.getProtocol(), documentBase.getHost(), documentBase.getPort(), url).toString();
                }
                catch (MalformedURLException e1) {
                    Log.logException(1, MODULE, e1);
                }
            }
        }
        if (urlOverride != null) {
            info.gallery.setType(99);
            info.gallery.setApUrlString(urlOverride);
            urlFull = urlOverride;
        } else if (urlFull != null) {
            URL documentBase = this.getDocumentBase();
            try {
                URL urlFullU = new URL(urlFull);
                if (!urlFullU.getHost().equals(documentBase.getHost()) || urlFullU.getPort() != documentBase.getPort()) {
                    Log.log(3, MODULE, "urlFull doesn't match documentBase for important data");
                    throw new MalformedURLException();
                }
                info.gallery.setType(99);
                info.gallery.setApUrlString(urlFull);
                Log.log(3, MODULE, "Full URL: " + urlFull);
            }
            catch (MalformedURLException e) {
                Log.log(3, MODULE, "urlFull is not a valid URL: recomposing it from documentBase");
                try {
                    String path = null;
                    if (urlFull.startsWith("/")) {
                        path = urlFull;
                    } else {
                        path = documentBase.getPath();
                        int i = path.lastIndexOf("/");
                        if (i != -1) {
                            path = path.substring(0, i);
                        }
                        path = path + "/" + urlFull;
                    }
                    urlFull = new URL(documentBase.getProtocol(), documentBase.getHost(), documentBase.getPort(), path).toString();
                    info.gallery.setType(99);
                    info.gallery.setApUrlString(urlFull);
                    Log.log(3, MODULE, "Full URL: " + urlFull);
                }
                catch (MalformedURLException ee) {
                    Log.logException(1, MODULE, ee);
                    urlFull = null;
                }
            }
        }
        if (urlFull == null) {
            info.gallery.setType(0);
            info.gallery.setStUrlString(url);
        }
        info.gallery.setUserAgent(userAgent);
        info.gallery.cookieLogin = true;
        if (galleryVersion != null) {
            try {
                info.gallery.forceGalleryVersion = Integer.parseInt(galleryVersion);
            }
            catch (RuntimeException e) {
                Log.logException(1, MODULE, e);
            }
        }
        info.slideshowFrom = slideshowFrom;
        CookieModule.discardAllCookies();
        if (cookieName != null) {
            Cookie cookie = new Cookie(cookieName, cookieValue, cookieDomain, cookiePath, null, false);
            Log.log(3, MODULE, "Adding cookie: " + cookie);
            CookieModule.addCookie((Cookie)cookie);
        }
        int cookieNum = 1;
        String name = null;
        while ((name = this.getParameter("gr_cookie" + cookieNum + "_name")) != null) {
            String value = this.getParameter("gr_cookie" + cookieNum + "_value");
            Cookie cookie1 = new Cookie(name, value, cookieDomain, cookiePath, null, false);
            Log.log(3, MODULE, "Adding cookie: " + cookie1);
            CookieModule.addCookie((Cookie)cookie1);
            ++cookieNum;
        }
        return info;
    }

    class AppletInfo {
        String albumName;
        Gallery gallery;
        String slideshowFrom;

        AppletInfo() {
        }
    }
}

